/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.util;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.Nullable;

public final class LanguageHandler {
    private LanguageHandler() {
    }

    public static void sendPlayerMessage(Player player, String key, Object ... message) {
        player.m_6352_((Component)LanguageHandler.buildChatComponent(key.toLowerCase(Locale.US), message), player.m_142081_());
    }

    public static MutableComponent buildChatComponent(String key, Object ... message) {
        TranslatableComponent translation = null;
        int onlyArgsUntil = 0;
        for (Object object : message) {
            if (object instanceof Component) {
                if (onlyArgsUntil != 0) break;
                onlyArgsUntil = -1;
                break;
            }
            ++onlyArgsUntil;
        }
        if (onlyArgsUntil >= 0) {
            Object[] args = new Object[onlyArgsUntil];
            System.arraycopy(message, 0, args, 0, onlyArgsUntil);
            translation = new TranslatableComponent(key, args);
        }
        for (Object object : message) {
            if (translation == null) {
                if (object instanceof Component) {
                    translation = new TranslatableComponent(key);
                } else {
                    translation = new TranslatableComponent(key, new Object[]{object});
                    continue;
                }
            }
            if (object instanceof Component) {
                translation.m_7220_(TextComponent.f_131282_);
                translation.m_7220_((Component)object);
                continue;
            }
            if (!(object instanceof String)) continue;
            boolean isInArgs = false;
            for (Object obj : translation.m_131329_()) {
                if (!obj.equals(object)) continue;
                isInArgs = true;
                break;
            }
            if (isInArgs) continue;
            translation.m_130946_(" " + object);
        }
        return translation;
    }

    public static String format(String inputKey, Object ... args) {
        String key = inputKey.toLowerCase(Locale.US);
        String result = args.length == 0 ? new TranslatableComponent(key).getString() : new TranslatableComponent(key, args).getString();
        return result.isEmpty() ? key : result;
    }

    public static void sendPlayersMessage(@Nullable List<Player> players, String key, Object ... message) {
        if (players == null || players.isEmpty()) {
            return;
        }
        MutableComponent textComponent = LanguageHandler.buildChatComponent(key.toLowerCase(Locale.US), message);
        for (Player player : players) {
            player.m_6352_((Component)textComponent, player.m_142081_());
        }
    }

    public static void sendMessageToPlayer(Player player, String key, Object ... format) {
        player.m_6352_((Component)new TextComponent(LanguageHandler.translateKeyWithFormat(key, format)), player.m_142081_());
    }

    public static String translateKeyWithFormat(String key, Object ... format) {
        return String.format(LanguageHandler.translateKey(key), format);
    }

    public static String translateKey(String key) {
        return LanguageCache.getInstance().translateKey(key.toLowerCase(Locale.US));
    }

    public static void setMClanguageLoaded() {
        LanguageCache.getInstance().isMCloaded = true;
        LanguageCache.getInstance().languageMap = null;
    }

    public static void loadLangPath(String path) {
        LanguageCache.getInstance().load(path);
    }

    private static class LanguageCache {
        private static final LanguageCache instance = new LanguageCache();
        private boolean isMCloaded = false;
        private Map<String, String> languageMap;

        private LanguageCache() {
            this.load("assets/structurize/lang/%s.json");
        }

        private void load(String path) {
            InputStream is;
            String defaultLocale = "en_us";
            String locale = (String)DistExecutor.unsafeCallWhenOn((Dist)Dist.CLIENT, () -> () -> Minecraft.m_91087_() == null ? null : Minecraft.m_91087_().f_91066_.f_92075_);
            if (locale == null) {
                locale = "en_us";
            }
            if ((is = Thread.currentThread().getContextClassLoader().getResourceAsStream(String.format(path, locale))) == null) {
                is = Thread.currentThread().getContextClassLoader().getResourceAsStream(String.format(path, "en_us"));
            }
            this.languageMap = (Map)new Gson().fromJson((Reader)new InputStreamReader(is, StandardCharsets.UTF_8), new TypeToken<Map<String, String>>(){}.getType());
            IOUtils.closeQuietly((InputStream)is);
        }

        private static LanguageCache getInstance() {
            return instance;
        }

        private String translateKey(String key) {
            if (this.isMCloaded) {
                return Language.m_128107_().m_6834_(key);
            }
            String res = this.languageMap.get(key);
            return res == null ? Language.m_128107_().m_6834_(key) : res;
        }
    }
}

