/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.util;

import com.ldtteam.structurize.Network;
import com.ldtteam.structurize.Structurize;
import com.ldtteam.structurize.api.util.ItemStackUtils;
import com.ldtteam.structurize.network.messages.UpdateClientRender;
import com.ldtteam.structurize.placement.AbstractBlueprintIterator;
import com.ldtteam.structurize.placement.BlockPlacementResult;
import com.ldtteam.structurize.placement.StructurePhasePlacementResult;
import com.ldtteam.structurize.placement.StructurePlacer;
import com.ldtteam.structurize.placement.handlers.placement.IPlacementHandler;
import com.ldtteam.structurize.placement.handlers.placement.PlacementHandlers;
import com.ldtteam.structurize.placement.structure.IStructureHandler;
import com.ldtteam.structurize.util.BlockUtils;
import com.ldtteam.structurize.util.BlueprintPositionInfo;
import com.ldtteam.structurize.util.ChangeStorage;
import com.mojang.authlib.GameProfile;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.TriPredicate;
import org.jetbrains.annotations.Nullable;

public class TickedWorldOperation {
    private final OperationType operation;
    private BlockPos startPos;
    private BlockPos currentPos;
    private final BlockPos endPos;
    @Nullable
    private Player player = null;
    private final ChangeStorage storage;
    private ChangeStorage undoStorage;
    private final ItemStack firstBlock;
    private final ItemStack secondBlock;
    private final StructurePlacer placer;
    private int structurePhase = 0;
    private int pct;

    public TickedWorldOperation(OperationType type, BlockPos startPos, BlockPos endPos, @Nullable Player player, ItemStack firstBlock, ItemStack secondBlock, int pct) {
        this.operation = type;
        this.startPos = new BlockPos(Math.min(startPos.m_123341_(), endPos.m_123341_()), Math.min(startPos.m_123342_(), endPos.m_123342_()), Math.min(startPos.m_123343_(), endPos.m_123343_()));
        this.currentPos = new BlockPos(Math.min(startPos.m_123341_(), endPos.m_123341_()), Math.min(startPos.m_123342_(), endPos.m_123342_()), Math.min(startPos.m_123343_(), endPos.m_123343_()));
        this.endPos = new BlockPos(Math.max(startPos.m_123341_(), endPos.m_123341_()), Math.max(startPos.m_123342_(), endPos.m_123342_()), Math.max(startPos.m_123343_(), endPos.m_123343_()));
        this.player = player;
        this.firstBlock = firstBlock;
        this.secondBlock = secondBlock;
        this.storage = new ChangeStorage(type.toString(), player != null ? player.m_142081_() : UUID.randomUUID());
        this.placer = null;
        this.pct = pct;
    }

    public TickedWorldOperation(ChangeStorage storage, @Nullable Player player, OperationType operation) {
        this.operation = operation;
        this.startPos = BlockPos.f_121853_;
        this.currentPos = BlockPos.f_121853_;
        this.endPos = BlockPos.f_121853_;
        this.player = player;
        this.firstBlock = ItemStack.f_41583_;
        this.secondBlock = ItemStack.f_41583_;
        this.storage = storage;
        storage.resetUnRedo();
        if (operation == OperationType.UNDO && storage.getOperation().indexOf(OperationType.UNDO.toString()) != 0) {
            this.undoStorage = new ChangeStorage(operation.toString() + ":" + storage.getOperation(), player != null ? player.m_142081_() : UUID.randomUUID());
        }
        this.placer = null;
    }

    public TickedWorldOperation(StructurePlacer placer, @Nullable Player player) {
        this.operation = OperationType.PLACE_STRUCTURE;
        this.startPos = BlockPos.f_121853_;
        this.currentPos = AbstractBlueprintIterator.NULL_POS;
        this.endPos = BlockPos.f_121853_;
        this.player = player;
        this.firstBlock = ItemStack.f_41583_;
        this.secondBlock = ItemStack.f_41583_;
        this.storage = new ChangeStorage(this.operation + ":" + placer.getHandler().getBluePrint().getName(), player != null ? player.m_142081_() : UUID.randomUUID());
        this.placer = placer;
    }

    public boolean apply(ServerLevel world) {
        if (this.player != null && this.player.f_19853_.m_46472_() != world.m_46472_()) {
            return false;
        }
        if (this.operation == OperationType.UNDO) {
            return this.storage.undo((Level)world, this.undoStorage);
        }
        if (this.operation == OperationType.REDO) {
            return this.storage.redo((Level)world);
        }
        if (this.operation == OperationType.PLACE_STRUCTURE) {
            if (this.placer.getHandler().getWorld().m_46472_().m_135782_().equals((Object)world.m_46472_().m_135782_())) {
                StructurePhasePlacementResult result;
                switch (this.structurePhase) {
                    case 0: {
                        result = this.placer.executeStructureStep((Level)world, this.storage, this.currentPos, StructurePlacer.Operation.WATER_REMOVAL, () -> this.placer.getIterator().decrement((TriPredicate<BlueprintPositionInfo, BlockPos, IStructureHandler>)((TriPredicate)(info, pos, handler) -> info.getBlockInfo().getState().m_60815_())), false);
                        this.currentPos = result.getIteratorPos();
                        break;
                    }
                    case 1: {
                        result = this.placer.executeStructureStep((Level)world, this.storage, this.currentPos, StructurePlacer.Operation.BLOCK_PLACEMENT, () -> this.placer.getIterator().increment((TriPredicate<BlueprintPositionInfo, BlockPos, IStructureHandler>)((TriPredicate)(info, pos, handler) -> !info.getBlockInfo().getState().m_60767_().m_76333_())), false);
                        this.currentPos = result.getIteratorPos();
                        break;
                    }
                    case 2: {
                        result = this.placer.executeStructureStep((Level)world, this.storage, this.currentPos, StructurePlacer.Operation.BLOCK_PLACEMENT, () -> this.placer.getIterator().increment((TriPredicate<BlueprintPositionInfo, BlockPos, IStructureHandler>)((TriPredicate)(info, pos, handler) -> info.getBlockInfo().getState().m_60767_().m_76333_())), false);
                        this.currentPos = result.getIteratorPos();
                        break;
                    }
                    default: {
                        result = this.placer.executeStructureStep((Level)world, this.storage, this.currentPos, StructurePlacer.Operation.BLOCK_PLACEMENT, () -> this.placer.getIterator().increment((TriPredicate<BlueprintPositionInfo, BlockPos, IStructureHandler>)((TriPredicate)(info, pos, handler) -> info.getEntities().length == 0)), true);
                        this.currentPos = result.getIteratorPos();
                    }
                }
                if (result.getBlockResult().getResult() == BlockPlacementResult.Result.FINISHED) {
                    ++this.structurePhase;
                    if (this.structurePhase > 3) {
                        this.structurePhase = 0;
                        this.currentPos = null;
                    }
                }
                return this.currentPos == null;
            }
            return false;
        }
        return this.run(world);
    }

    private boolean run(ServerLevel world) {
        FakePlayer fakePlayer = new FakePlayer(world, new GameProfile(this.player == null ? UUID.randomUUID() : this.player.m_142081_(), "structurizefakeplayer"));
        int count = 0;
        for (int y = this.currentPos.m_123342_(); y <= this.endPos.m_123342_(); ++y) {
            for (int x = this.currentPos.m_123341_(); x <= this.endPos.m_123341_(); ++x) {
                for (int z = this.currentPos.m_123343_(); z <= this.endPos.m_123343_(); ++z) {
                    BlockPos here = new BlockPos(x, y, z);
                    BlockState blockState = world.m_8055_(here);
                    BlockEntity tileEntity = world.m_7702_(here);
                    boolean isMatch = false;
                    boolean handled = false;
                    if (this.firstBlock.m_41720_() == Items.f_41852_ && blockState.m_60795_()) {
                        isMatch = true;
                    } else {
                        for (IPlacementHandler handler : PlacementHandlers.handlers) {
                            if (!handler.canHandle((Level)world, BlockPos.f_121853_, blockState)) continue;
                            List<ItemStack> itemList = handler.getRequiredItems((Level)world, here, blockState, tileEntity == null ? null : tileEntity.m_187480_(), true);
                            if (!itemList.isEmpty() && ItemStackUtils.compareItemStacksIgnoreStackSize(itemList.get(0), this.firstBlock).booleanValue()) {
                                isMatch = true;
                            }
                            handled = true;
                            break;
                        }
                        if (!handled && ItemStackUtils.compareItemStacksIgnoreStackSize(BlockUtils.getItemStackFromBlockState(blockState), this.firstBlock).booleanValue()) {
                            isMatch = true;
                        }
                    }
                    if (!isMatch || this.pct < 100 && fakePlayer.m_21187_().nextInt(100) > this.pct || blockState.m_60734_() instanceof DoorBlock && blockState.m_61143_((Property)DoorBlock.f_52730_) == DoubleBlockHalf.UPPER || blockState.m_60734_() instanceof BedBlock && blockState.m_61143_((Property)BedBlock.f_49440_) == BedPart.HEAD) continue;
                    ++count;
                    this.storage.addPreviousDataFor(here, (Level)world);
                    if (this.operation != OperationType.REPLACE_BLOCK && (blockState.m_60734_() instanceof BucketPickup || blockState.m_60734_() instanceof LiquidBlock)) {
                        BlockUtils.removeFluid((Level)world, here);
                        if (this.firstBlock.m_41720_() instanceof BucketItem && !(blockState.m_60734_() instanceof LiquidBlock)) {
                            if (count < (Integer)Structurize.getConfig().getServer().maxOperationsPerTick.get()) continue;
                            this.currentPos = new BlockPos(x, y, z);
                            return false;
                        }
                    }
                    if (this.operation == OperationType.REPLACE_BLOCK) {
                        BlockUtils.handleCorrectBlockPlacement((Level)world, fakePlayer, this.secondBlock, blockState, here);
                    } else {
                        world.m_7471_(here, false);
                    }
                    this.storage.addPostDataFor(here, (Level)world);
                    if (count < (Integer)Structurize.getConfig().getServer().maxOperationsPerTick.get()) continue;
                    this.currentPos = new BlockPos(x, y, z);
                    return false;
                }
                this.currentPos = new BlockPos(x, y, this.startPos.m_123343_());
            }
            this.currentPos = new BlockPos(this.startPos.m_123341_(), y, this.startPos.m_123343_());
        }
        Network.getNetwork().sendToEveryone(new UpdateClientRender(this.startPos, this.endPos));
        return true;
    }

    private static boolean correctBlockToRemoveOrReplace(ItemStack replacementStack, BlockState worldState, ItemStack compareStack) {
        return replacementStack != null && replacementStack.m_41656_(compareStack) || compareStack.m_41720_() instanceof BucketItem && ((BucketItem)compareStack.m_41720_()).getFluid() == worldState.m_60819_().m_76152_() || compareStack.m_41720_() instanceof BucketItem && worldState.m_60734_() instanceof LiquidBlock && ((BucketItem)compareStack.m_41720_()).getFluid() == ((LiquidBlock)worldState.m_60734_()).getFluid() || compareStack.m_41720_() == Items.f_41852_ && worldState.m_60734_() == Blocks.f_50016_;
    }

    public ChangeStorage getChangeStorage() {
        return this.storage;
    }

    public boolean isUndoRedo() {
        return this.operation == OperationType.UNDO || this.operation == OperationType.REDO;
    }

    public static enum OperationType {
        REMOVE_BLOCK,
        REPLACE_BLOCK,
        REMOVE_ENTITY,
        SCAN,
        PLACE_STRUCTURE,
        UNDO,
        REDO;

    }
}

