/*
 * Decompiled with CFR 0.152.
 */
package xyz.vsngamer.elevatorid.blocks;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import xyz.vsngamer.elevatorid.ElevatorModTab;
import xyz.vsngamer.elevatorid.init.ModConfig;
import xyz.vsngamer.elevatorid.tile.ElevatorTileEntity;
import xyz.vsngamer.elevatorid.util.FakeUseContext;

public class ElevatorBlock
extends HorizontalDirectionalBlock
implements EntityBlock {
    public static final BooleanProperty DIRECTIONAL = BooleanProperty.m_61465_((String)"directional");
    public static final BooleanProperty SHOW_ARROW = BooleanProperty.m_61465_((String)"show_arrow");
    private ElevatorBlockItem blockItem;
    private final DyeColor dyeColor;

    public ElevatorBlock(DyeColor color) {
        super(BlockBehaviour.Properties.m_60941_((Material)Material.f_76272_, (DyeColor)color).m_60918_(SoundType.f_56745_).m_60978_(0.8f).m_60988_().m_60955_());
        this.setRegistryName("elevatorid", "elevator_" + color.m_41065_());
        this.dyeColor = color;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_, DIRECTIONAL, SHOW_ARROW});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)DIRECTIONAL, (Comparable)Boolean.valueOf(false));
    }

    @Nullable
    public BlockEntity m_142194_(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return new ElevatorTileEntity(pos, state);
    }

    public boolean m_6864_(@Nonnull BlockState state, @Nonnull BlockPlaceContext useContext) {
        return false;
    }

    @Nonnull
    public InteractionResult m_6227_(@Nonnull BlockState state, Level worldIn, @Nonnull BlockPos pos, @Nonnull Player player, @Nonnull InteractionHand handIn, @Nonnull BlockHitResult hit) {
        if (worldIn.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        ItemStack handStack = player.m_21120_(handIn);
        ElevatorTileEntity tile = this.getElevatorTile((BlockGetter)worldIn, pos);
        if (tile == null) {
            return InteractionResult.FAIL;
        }
        Block handBlock = Block.m_49814_((Item)handStack.m_41720_());
        BlockState stateToApply = handBlock.m_5573_((BlockPlaceContext)new FakeUseContext(player, handIn, hit));
        if (tile.setCamoAndUpdate(stateToApply)) {
            return InteractionResult.SUCCESS;
        }
        if (player.m_6047_() && tile.getHeldState() != null) {
            tile.setCamoAndUpdate(null);
            return InteractionResult.SUCCESS;
        }
        NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)tile, (BlockPos)pos);
        return InteractionResult.SUCCESS;
    }

    public boolean isValidSpawn(BlockState state, BlockGetter world, BlockPos pos, SpawnPlacements.Type type, @Nullable EntityType<?> entityType) {
        return (Boolean)ModConfig.GENERAL.mobSpawn.get() != false && super.isValidSpawn(state, world, pos, type, entityType);
    }

    @Nonnull
    public VoxelShape m_5939_(@Nonnull BlockState state, @Nonnull BlockGetter worldIn, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        ElevatorTileEntity tile = this.getElevatorTile(worldIn, pos);
        if (tile != null && tile.getHeldState() != null) {
            return tile.getHeldState().m_60742_(worldIn, pos, context);
        }
        return super.m_5939_(state, worldIn, pos, context);
    }

    public boolean collisionExtendsVertically(BlockState state, BlockGetter world, BlockPos pos, Entity collidingEntity) {
        ElevatorTileEntity tile = this.getElevatorTile(world, pos);
        if (tile != null && tile.getHeldState() != null) {
            return tile.getHeldState().collisionExtendsVertically(world, pos, collidingEntity);
        }
        return false;
    }

    @Nonnull
    public VoxelShape m_5940_(@Nonnull BlockState state, @Nonnull BlockGetter worldIn, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        ElevatorTileEntity tile = this.getElevatorTile(worldIn, pos);
        if (tile != null && tile.getHeldState() != null) {
            return tile.getHeldState().m_60651_(worldIn, pos, context);
        }
        return super.m_5940_(state, worldIn, pos, context);
    }

    public float getFriction(@Nonnull BlockState state, @Nonnull LevelReader world, @Nonnull BlockPos pos, @Nullable Entity entity) {
        ElevatorTileEntity tile = this.getElevatorTile((BlockGetter)world, pos);
        if (tile != null && tile.getHeldState() != null) {
            return tile.getHeldState().getFriction(world, pos, entity);
        }
        return super.getFriction(state, world, pos, entity);
    }

    public void m_7892_(@Nonnull BlockState state, @Nonnull Level worldIn, @Nonnull BlockPos pos, @Nonnull Entity entityIn) {
        ElevatorTileEntity tile = this.getElevatorTile((BlockGetter)worldIn, pos);
        if (tile != null && tile.getHeldState() != null) {
            try {
                tile.getHeldState().m_60682_(worldIn, pos, entityIn);
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        super.m_7892_(state, worldIn, pos, entityIn);
    }

    public float m_49961_() {
        return super.m_49961_();
    }

    public float m_49964_() {
        return super.m_49964_();
    }

    @Nonnull
    public BlockState m_7417_(@Nonnull BlockState stateIn, @Nonnull Direction facing, @Nonnull BlockState facingState, LevelAccessor worldIn, @Nonnull BlockPos currentPos, @Nonnull BlockPos facingPos) {
        BlockState updatedState;
        ElevatorTileEntity tile;
        if (!worldIn.m_5776_() && (tile = this.getElevatorTile((BlockGetter)worldIn, currentPos)) != null && tile.getHeldState() != null && (updatedState = tile.getHeldState().m_60728_(facing, facingState, worldIn, currentPos, facingPos)) != tile.getHeldState()) {
            tile.setHeldState(updatedState);
        }
        return super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean m_7899_(@Nonnull BlockState state) {
        return true;
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter world, BlockPos pos, @Nullable Direction side) {
        ElevatorTileEntity tile = this.getElevatorTile(world, pos);
        if (tile != null && tile.getHeldState() != null) {
            return tile.getHeldState().canRedstoneConnectTo(world, pos, side);
        }
        return false;
    }

    public boolean shouldCheckWeakPower(BlockState state, LevelReader world, BlockPos pos, Direction side) {
        ElevatorTileEntity tile = this.getElevatorTile((BlockGetter)world, pos);
        if (tile != null && tile.getHeldState() != null) {
            return tile.getHeldState().shouldCheckWeakPower(world, pos, side);
        }
        return super.shouldCheckWeakPower(state, world, pos, side);
    }

    public int m_6378_(@Nonnull BlockState state, @Nonnull BlockGetter reader, @Nonnull BlockPos pos, @Nonnull Direction direction) {
        ElevatorTileEntity tile = this.getElevatorTile(reader, pos);
        if (tile != null && tile.getHeldState() != null) {
            return tile.getHeldState().m_60746_(reader, pos, direction);
        }
        return super.m_6378_(state, reader, pos, direction);
    }

    public int m_6376_(@Nonnull BlockState state, @Nonnull BlockGetter reader, @Nonnull BlockPos pos, @Nonnull Direction direction) {
        ElevatorTileEntity tile = this.getElevatorTile(reader, pos);
        if (tile != null && tile.getHeldState() != null) {
            return tile.getHeldState().m_60775_(reader, pos, direction);
        }
        return super.m_6376_(state, reader, pos, direction);
    }

    public boolean m_7278_(@Nonnull BlockState state) {
        return false;
    }

    public int m_6782_(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos) {
        return 0;
    }

    public int getLightEmission(BlockState state, BlockGetter world, BlockPos pos) {
        ElevatorTileEntity tile = this.getElevatorTile(world, pos);
        if (tile != null && tile.getHeldState() != null) {
            return tile.getHeldState().getLightEmission(world, pos);
        }
        return super.getLightEmission(state, world, pos);
    }

    public boolean m_7420_(@Nonnull BlockState state, @Nonnull BlockGetter reader, @Nonnull BlockPos pos) {
        return true;
    }

    public float m_7749_(@Nonnull BlockState state, @Nonnull BlockGetter worldIn, @Nonnull BlockPos pos) {
        ElevatorTileEntity tile = this.getElevatorTile(worldIn, pos);
        if (tile != null && tile.getHeldState() != null) {
            return tile.getHeldState().m_60792_(worldIn, pos);
        }
        return super.m_7749_(state, worldIn, pos);
    }

    public int m_7753_(@Nonnull BlockState state, @Nonnull BlockGetter worldIn, @Nonnull BlockPos pos) {
        ElevatorTileEntity tile = this.getElevatorTile(worldIn, pos);
        if (tile != null && tile.getHeldState() != null) {
            return tile.getHeldState().m_60739_(worldIn, pos);
        }
        return worldIn.m_7469_();
    }

    public SoundType getSoundType(BlockState state, LevelReader world, BlockPos pos, @Nullable Entity entity) {
        ElevatorTileEntity tile = this.getElevatorTile((BlockGetter)world, pos);
        if (tile != null && tile.getHeldState() != null) {
            return tile.getHeldState().getSoundType(world, pos, entity);
        }
        return super.getSoundType(state, world, pos, entity);
    }

    public DyeColor getColor() {
        return this.dyeColor;
    }

    private ElevatorTileEntity getElevatorTile(BlockGetter world, BlockPos pos) {
        if (world == null || pos == null) {
            return null;
        }
        BlockEntity tile = world.m_7702_(pos);
        if (tile instanceof ElevatorTileEntity && tile.m_58903_().m_155262_(world.m_8055_(pos))) {
            return (ElevatorTileEntity)tile;
        }
        return null;
    }

    @Nonnull
    public Item m_5456_() {
        if (this.blockItem == null) {
            this.blockItem = new ElevatorBlockItem();
        }
        return this.blockItem;
    }

    public class ElevatorBlockItem
    extends BlockItem {
        ElevatorBlockItem() {
            super((Block)ElevatorBlock.this, new Item.Properties().m_41491_(ElevatorModTab.TAB));
            ResourceLocation name = ElevatorBlock.this.getRegistryName();
            if (name != null) {
                this.setRegistryName(name);
            }
        }
    }
}

