/*
 * Decompiled with CFR 0.152.
 */
package terrablender.worldgen;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.OverworldBiomeBuilder;
import net.minecraft.world.level.levelgen.SurfaceRules;
import org.apache.logging.log4j.util.TriConsumer;
import terrablender.api.BiomeProvider;
import terrablender.api.BiomeProviders;
import terrablender.api.GenerationSettings;
import terrablender.core.TerraBlender;
import terrablender.data.DataPackManager;
import terrablender.worldgen.TBClimate;
import terrablender.worldgen.surface.NamespacedSurfaceRuleSource;

public class BiomeProviderUtils {
    private static final List<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> VANILLA_POINTS;
    private static Map<ResourceKey<Biome>, List<Climate.ParameterPoint>> biomeParameterPointCache;
    private static Map<Integer, Float> uniquenessMidPointCache;
    private static Map<Integer, Climate.Parameter> uniquenessParameterCache;

    public static SurfaceRules.RuleSource createOverworldRules(SurfaceRules.RuleSource base) {
        return BiomeProviderUtils.createNamespacedRuleSource(base, provider -> provider.getOverworldSurfaceRules());
    }

    public static SurfaceRules.RuleSource createOverworldRules() {
        return BiomeProviderUtils.createOverworldRules(GenerationSettings.getDefaultOverworldSurfaceRules());
    }

    public static SurfaceRules.RuleSource createNetherRules(SurfaceRules.RuleSource base) {
        return BiomeProviderUtils.createNamespacedRuleSource(base, provider -> provider.getNetherSurfaceRules());
    }

    public static SurfaceRules.RuleSource createNetherRules() {
        return BiomeProviderUtils.createNetherRules(GenerationSettings.getDefaultNetherSurfaceRules());
    }

    private static SurfaceRules.RuleSource createNamespacedRuleSource(SurfaceRules.RuleSource base, Function<BiomeProvider, Optional<SurfaceRules.RuleSource>> source) {
        return new NamespacedSurfaceRuleSource(base, (Map<String, SurfaceRules.RuleSource>)ImmutableMap.copyOf(BiomeProviderUtils.collectRuleSources(source)));
    }

    public static Climate.Parameter getUniquenessParameter(int index) {
        if (uniquenessParameterCache.containsKey(index)) {
            return uniquenessParameterCache.get(index);
        }
        Climate.Parameter parameter = new Climate.Parameter((long)index, (long)index);
        uniquenessParameterCache.put(index, parameter);
        return parameter;
    }

    public static List<Climate.ParameterPoint> getVanillaParameterPoints(ResourceKey<Biome> biome) {
        if (biomeParameterPointCache.containsKey(biome)) {
            return biomeParameterPointCache.get(biome);
        }
        List points = (List)VANILLA_POINTS.stream().filter(pair -> pair.getSecond() == biome).map(pair -> (Climate.ParameterPoint)pair.getFirst()).collect(ImmutableList.toImmutableList());
        biomeParameterPointCache.put(biome, points);
        return points;
    }

    public static <T> List<Integer> getUniquenessValues(List<Pair<TBClimate.ParameterPoint, T>> parameters) {
        List uniquenesses = (List)((ImmutableSet)parameters.stream().filter(value -> ((TBClimate.ParameterPoint)value.getFirst()).uniqueness().f_186813_() == ((TBClimate.ParameterPoint)value.getFirst()).uniqueness().f_186814_()).map(value -> (int)((TBClimate.ParameterPoint)value.getFirst()).uniqueness().f_186813_()).collect(ImmutableSet.toImmutableSet())).stream().sorted().collect(ImmutableList.toImmutableList());
        if (uniquenesses.isEmpty()) {
            TerraBlender.LOGGER.error("No uniqueness values found in parameter values. Things may not work well!");
            return ImmutableList.of((Object)0);
        }
        if ((Integer)uniquenesses.get(0) != 0) {
            throw new IllegalStateException("Uniqueness values must start at 0");
        }
        return uniquenesses;
    }

    public static List<TBClimate.ParameterPoint> getAllSpawnTargets() {
        ImmutableList.Builder builder = new ImmutableList.Builder();
        BiomeProviders.get().forEach(provider -> builder.addAll(provider.getSpawnTargets()));
        return builder.build();
    }

    public static void addAllOverworldBiomes(Registry<Biome> registry, Consumer<Pair<TBClimate.ParameterPoint, ResourceKey<Biome>>> mapper) {
        BiomeProviderUtils.addBiomesWithVerification(registry, mapper, BiomeProvider::getOverworldWeight, (TriConsumer<BiomeProvider, Registry<Biome>, Consumer<Pair<TBClimate.ParameterPoint, ResourceKey<Biome>>>>)((TriConsumer)BiomeProvider::addOverworldBiomes));
    }

    public static void addAllNetherBiomes(Registry<Biome> registry, Consumer<Pair<TBClimate.ParameterPoint, ResourceKey<Biome>>> mapper) {
        BiomeProviderUtils.addBiomesWithVerification(registry, mapper, BiomeProvider::getNetherWeight, (TriConsumer<BiomeProvider, Registry<Biome>, Consumer<Pair<TBClimate.ParameterPoint, ResourceKey<Biome>>>>)((TriConsumer)BiomeProvider::addNetherBiomes));
    }

    private static void addBiomesWithVerification(Registry<Biome> registry, Consumer<Pair<TBClimate.ParameterPoint, ResourceKey<Biome>>> mapper, Function<BiomeProvider, Integer> weight, TriConsumer<BiomeProvider, Registry<Biome>, Consumer<Pair<TBClimate.ParameterPoint, ResourceKey<Biome>>>> add) {
        HashSet unusedIndices = Sets.newHashSet();
        BiomeProviders.get().forEach(provider -> {
            if ((Integer)weight.apply((BiomeProvider)provider) > 0 && provider.getName() != DataPackManager.DATA_PACK_PROVIDER_LOCATION) {
                unusedIndices.add(provider.getIndex());
            }
        });
        Consumer<Pair> verificationMapper = pair -> {
            Climate.Parameter uniqueness;
            if (!unusedIndices.isEmpty() && (uniqueness = ((TBClimate.ParameterPoint)pair.getFirst()).uniqueness()).f_186813_() == uniqueness.f_186814_()) {
                unusedIndices.remove((int)uniqueness.f_186813_());
            }
            mapper.accept((Pair<TBClimate.ParameterPoint, ResourceKey<Biome>>)pair);
        };
        BiomeProviders.get().forEach(provider -> add.accept(provider, (Object)registry, (Object)verificationMapper));
        if (unusedIndices.size() > 0) {
            throw new RuntimeException("Biome indices have been registered but haven't been utilised: " + unusedIndices + ". Either utilise the uniqueness assigned to your biome provider or set your provider's weight to 0.");
        }
    }

    private static Map<String, SurfaceRules.RuleSource> collectRuleSources(Function<BiomeProvider, Optional<SurfaceRules.RuleSource>> rulesSource) {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (BiomeProvider provider : BiomeProviders.get()) {
            Optional<SurfaceRules.RuleSource> rules = rulesSource.apply(provider);
            if (!rules.isPresent()) continue;
            builder.put((Object)provider.getName().m_135827_(), (Object)rules.get());
        }
        return builder.build();
    }

    private static void onIndexReset() {
        uniquenessMidPointCache.clear();
        uniquenessParameterCache.clear();
    }

    static {
        biomeParameterPointCache = Maps.newHashMap();
        uniquenessMidPointCache = Maps.newHashMap();
        uniquenessParameterCache = Maps.newHashMap();
        BiomeProviders.addIndexResetListener(BiomeProviderUtils::onIndexReset);
        ImmutableList.Builder builder = new ImmutableList.Builder();
        new OverworldBiomeBuilder().m_187175_(pair -> builder.add(pair));
        VANILLA_POINTS = builder.build();
    }
}

