/*
 * Decompiled with CFR 0.152.
 */
package terrablender.worldgen;

import com.mojang.datafixers.util.Pair;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.MultiNoiseBiomeSource;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.WorldGenSettings;
import terrablender.api.BiomeProvider;
import terrablender.api.ParameterUtils;
import terrablender.core.TerraBlender;
import terrablender.worldgen.TBClimate;

public class DataPackBiomeProvider
extends BiomeProvider {
    private WorldGenSettings settings;
    private ChunkGenerator overworldGenerator;
    private ChunkGenerator netherGenerator;
    private Optional<SurfaceRules.RuleSource> overworldSurfaceRules = Optional.empty();
    private Optional<SurfaceRules.RuleSource> netherSurfaceRules = Optional.empty();

    public DataPackBiomeProvider(ResourceLocation name, int overworldWeight, int netherWeight, WorldGenSettings settings) {
        super(name, overworldWeight, netherWeight);
        LevelStem netherStem;
        this.settings = settings;
        this.overworldGenerator = settings.m_64666_();
        if (this.overworldGenerator instanceof NoiseBasedChunkGenerator) {
            NoiseGeneratorSettings generatorSettings = (NoiseGeneratorSettings)((NoiseBasedChunkGenerator)this.overworldGenerator).f_64318_.get();
            this.overworldSurfaceRules = Optional.of(generatorSettings.m_188891_());
        }
        ChunkGenerator chunkGenerator = this.netherGenerator = (netherStem = (LevelStem)settings.m_64663_().m_6246_(LevelStem.f_63972_)) != null ? netherStem.m_63990_() : null;
        if (this.netherGenerator != null && this.netherGenerator instanceof NoiseBasedChunkGenerator) {
            NoiseGeneratorSettings generatorSettings = (NoiseGeneratorSettings)((NoiseBasedChunkGenerator)this.netherGenerator).f_64318_.get();
            this.netherSurfaceRules = Optional.of(generatorSettings.m_188891_());
        }
    }

    @Override
    public void addOverworldBiomes(Registry<Biome> registry, Consumer<Pair<TBClimate.ParameterPoint, ResourceKey<Biome>>> mapper) {
        if (!(this.overworldGenerator.m_62218_() instanceof MultiNoiseBiomeSource)) {
            return;
        }
        MultiNoiseBiomeSource biomeSource = (MultiNoiseBiomeSource)this.overworldGenerator.m_62218_();
        Climate.Parameter uniquenessParameter = this.getUniquenessParameter();
        TerraBlender.LOGGER.info("Adding overworld biomes for datapack " + this.getName() + " with uniqueness " + uniquenessParameter);
        biomeSource.f_48435_.m_186850_().stream().forEach(pair -> {
            TBClimate.ParameterPoint parameters = ParameterUtils.convertParameterPoint((Climate.ParameterPoint)pair.getFirst(), uniquenessParameter);
            Optional key = registry.m_7854_((Object)((Biome)((Supplier)pair.getSecond()).get()));
            if (key.isPresent()) {
                this.addBiome(mapper, parameters, (ResourceKey<Biome>)((ResourceKey)key.get()));
            }
        });
    }

    @Override
    public void addNetherBiomes(Registry<Biome> registry, Consumer<Pair<TBClimate.ParameterPoint, ResourceKey<Biome>>> mapper) {
        if (this.netherGenerator == null || !(this.netherGenerator.m_62218_() instanceof MultiNoiseBiomeSource)) {
            return;
        }
        MultiNoiseBiomeSource biomeSource = (MultiNoiseBiomeSource)this.netherGenerator.m_62218_();
        Climate.Parameter uniquenessParameter = this.getUniquenessParameter();
        TerraBlender.LOGGER.info("Adding nether biomes for datapack " + this.getName() + " with uniqueness " + uniquenessParameter);
        biomeSource.f_48435_.m_186850_().stream().forEach(pair -> {
            TBClimate.ParameterPoint parameters = ParameterUtils.convertParameterPoint((Climate.ParameterPoint)pair.getFirst(), uniquenessParameter);
            Optional key = registry.m_7854_((Object)((Biome)((Supplier)pair.getSecond()).get()));
            if (key.isPresent()) {
                this.addBiome(mapper, parameters, (ResourceKey<Biome>)((ResourceKey)key.get()));
            }
        });
    }

    @Override
    public Optional<SurfaceRules.RuleSource> getOverworldSurfaceRules() {
        return this.overworldSurfaceRules;
    }

    @Override
    public Optional<SurfaceRules.RuleSource> getNetherSurfaceRules() {
        return this.netherSurfaceRules;
    }
}

