/*
 * Decompiled with CFR 0.152.
 */
package team.creative.ambientsounds;

import java.util.LinkedHashMap;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import team.creative.ambientsounds.AmbientDimension;
import team.creative.ambientsounds.AmbientEngine;

public class AmbientEnviroment {
    public Level level;
    public boolean soundsDisabled = false;
    public boolean night;
    public boolean overallRaining;
    public boolean raining;
    public boolean snowing;
    public boolean thundering;
    public LinkedHashMap<BiomeArea, Float> biomes;
    public BlockEnviroment blocks = new BlockEnviroment();
    public Player player;
    public double underwater;
    public double averageHeight;
    public double relativeHeight;
    public int minHeight;
    public int maxHeight;
    public double biomeVolume = 1.0;
    public AmbientDimension dimension;

    public AmbientEnviroment(Player player) {
        this.player = player;
        this.level = player.f_19853_;
    }

    public void updateLevel() {
        this.overallRaining = this.level.m_46471_();
        this.raining = this.level.m_46758_(this.player.m_142538_());
        Biome biome = this.level.m_46857_(this.player.m_142538_());
        this.snowing = biome.m_47530_() == Biome.Precipitation.SNOW && this.level.m_46471_();
        this.thundering = this.level.m_46470_();
    }

    public void setSunAngle(float sunAngle) {
        this.night = sunAngle > 90.0f && sunAngle < 270.0f;
    }

    public void setUnderwater(double underwater) {
        this.underwater = underwater;
        if (underwater > 0.0) {
            this.blocks.outsideVolume = 0.0;
        }
    }

    public void setHeight(TerrainHeight terrain) {
        this.averageHeight = terrain.averageHeight;
        this.relativeHeight = this.player.m_20188_() - terrain.averageHeight;
        this.minHeight = terrain.minHeight;
        this.maxHeight = terrain.maxHeight;
    }

    public class BlockEnviroment {
        public double averageLight;
        public double outsideVolume;
        protected BlockSpot[] spots = new BlockSpot[Direction.values().length];

        public void updateAllDirections(AmbientEngine engine) {
            int lightspots = 0;
            this.averageLight = 0.0;
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
            for (Direction facing : Direction.values()) {
                BlockSpot spot = this.updateDirection(pos, facing, engine);
                if (spot != null) {
                    this.spots[facing.ordinal()] = spot;
                    this.averageLight += (double)spot.light;
                    ++lightspots;
                    continue;
                }
                this.spots[facing.ordinal()] = null;
            }
            this.averageLight = lightspots == 0 ? (double)AmbientEnviroment.this.level.m_7146_((BlockPos)pos.m_122190_((Vec3i)AmbientEnviroment.this.player.m_142538_())) : (this.averageLight /= (double)lightspots);
            this.outsideVolume = this.calculateOutsideVolume(engine);
        }

        protected BlockSpot updateDirection(BlockPos.MutableBlockPos pos, Direction facing, AmbientEngine engine) {
            pos.m_122190_((Vec3i)AmbientEnviroment.this.player.m_142538_());
            pos.m_142448_(pos.m_123342_() + 1);
            for (int i = 1; i < engine.blockScanDistance; ++i) {
                pos.m_122178_(pos.m_123341_() + facing.m_122429_(), pos.m_123342_() + facing.m_122430_(), pos.m_123343_() + facing.m_122431_());
                BlockState state = AmbientEnviroment.this.level.m_8055_((BlockPos)pos);
                if (!state.m_60838_((BlockGetter)AmbientEnviroment.this.level, (BlockPos)pos)) continue;
                return new BlockSpot(state, i, AmbientEnviroment.this.level.m_7146_((BlockPos)pos.m_122173_(facing.m_122424_())));
            }
            return null;
        }

        protected double calculateOutsideVolume(AmbientEngine engine) {
            Integer distanceX = this.spots[Direction.EAST.ordinal()] == null ? null : (this.spots[Direction.WEST.ordinal()] == null ? null : Integer.valueOf(this.spots[Direction.EAST.ordinal()].distance + this.spots[Direction.WEST.ordinal()].distance));
            Integer distanceY = this.spots[Direction.UP.ordinal()] == null ? null : (this.spots[Direction.DOWN.ordinal()] == null ? null : Integer.valueOf(this.spots[Direction.UP.ordinal()].distance + this.spots[Direction.DOWN.ordinal()].distance));
            Integer distanceZ = this.spots[Direction.SOUTH.ordinal()] == null ? null : (this.spots[Direction.NORTH.ordinal()] == null ? null : Integer.valueOf(this.spots[Direction.SOUTH.ordinal()].distance + this.spots[Direction.NORTH.ordinal()].distance));
            double volumeVertical = distanceY == null ? 1.0 : Mth.m_14008_((double)((double)(distanceY - engine.outsideDistanceMin) / (double)(engine.outsideDistanceMax - engine.outsideDistanceMin)), (double)0.0, (double)1.0);
            double volumeHorizontal = distanceX == null || distanceZ == null ? 1.0 : Mth.m_14008_((double)((double)(Math.max(distanceX, distanceZ) - engine.outsideDistanceMin) / (double)(engine.outsideDistanceMax - engine.outsideDistanceMin)), (double)0.0, (double)1.0);
            return volumeHorizontal * volumeVertical;
        }
    }

    public static class TerrainHeight {
        public final double averageHeight;
        public final int minHeight;
        public final int maxHeight;

        public TerrainHeight(double averageHeight, int minHeight, int maxHeight) {
            this.averageHeight = averageHeight;
            this.minHeight = minHeight;
            this.maxHeight = maxHeight;
        }
    }

    public static class BiomeArea {
        public final Biome biome;
        public final BlockPos pos;

        public BiomeArea(Biome biome, BlockPos pos) {
            this.biome = biome;
            this.pos = pos;
        }

        public boolean checkBiome(String[] names) {
            for (String name : names) {
                String biomename = this.biome.m_47567_().m_47645_().toLowerCase().replace("_", " ");
                if (!biomename.matches(".*" + name.replace("*", ".*") + ".*")) continue;
                return true;
            }
            return false;
        }

        public boolean checkTopBlock(List<Block> topBlocks) {
            return topBlocks.contains(this.biome.m_47536_().m_47824_().m_6743_().m_60734_());
        }

        public boolean equals(Object object) {
            if (object instanceof BiomeArea) {
                return ((BiomeArea)object).biome == this.biome;
            }
            return false;
        }

        public int hashCode() {
            return this.biome.hashCode();
        }
    }

    public static class BlockSpot {
        public BlockState state;
        public int distance;
        public int light;

        public BlockSpot(BlockState state, int distance, int light) {
            this.state = state;
            this.distance = distance;
            this.light = light;
        }

        public Material getMaterial() {
            return this.state.m_60767_();
        }
    }
}

