/*
 * Decompiled with CFR 0.152.
 */
package team.creative.ambientsounds;

import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Options;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import team.creative.ambientsounds.AmbientSound;

public class AmbientSoundEngine {
    public SoundManager manager;
    public Options options;
    private List<AmbientSound.SoundStream> sounds = new ArrayList<AmbientSound.SoundStream>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int playingCount() {
        List<AmbientSound.SoundStream> list = this.sounds;
        synchronized (list) {
            return this.sounds.size();
        }
    }

    public AmbientSoundEngine(SoundManager manager, Options options) {
        this.options = options;
        this.manager = manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tick() {
        List<AmbientSound.SoundStream> list = this.sounds;
        synchronized (list) {
            Double mute = null;
            try {
                for (AmbientSound.SoundStream sound : this.sounds) {
                    double soundMute = sound.mute();
                    if (!(soundMute > 0.0) || mute != null && !(mute < soundMute)) continue;
                    mute = soundMute;
                }
                Iterator<AmbientSound.SoundStream> iterator = this.sounds.iterator();
                while (iterator.hasNext()) {
                    boolean playing;
                    AmbientSound.SoundStream sound;
                    sound = iterator.next();
                    if (!this.manager.m_120403_((SoundInstance)sound)) {
                        if (!sound.hasPlayedOnce()) continue;
                        playing = false;
                    } else {
                        playing = true;
                    }
                    if (sound.hasPlayedOnce() && !playing) {
                        sound.onFinished();
                        this.manager.m_120399_((SoundInstance)sound);
                        iterator.remove();
                        continue;
                    }
                    if (!sound.hasPlayedOnce() && playing) {
                        sound.setPlayedOnce();
                    }
                    if (mute == null || sound.mute() >= mute) {
                        sound.generatedVoume = (float)sound.volume;
                        continue;
                    }
                    sound.generatedVoume = (float)(sound.volume * (1.0 - mute));
                }
            }
            catch (ConcurrentModificationException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(AmbientSound.SoundStream sound) {
        this.manager.m_120399_((SoundInstance)sound);
        List<AmbientSound.SoundStream> list = this.sounds;
        synchronized (list) {
            this.sounds.remove(sound);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void play(AmbientSound.SoundStream stream) {
        this.manager.m_120367_((SoundInstance)stream);
        stream.onStart();
        List<AmbientSound.SoundStream> list = this.sounds;
        synchronized (list) {
            this.sounds.add(stream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopAll() {
        List<AmbientSound.SoundStream> list = this.sounds;
        synchronized (list) {
            for (AmbientSound.SoundStream sound : this.sounds) {
                this.stop(sound);
                sound.onFinished();
            }
        }
    }
}

