/*
 * Decompiled with CFR 0.152.
 */
package team.creative.ambientsounds.env;

import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.material.Material;
import team.creative.ambientsounds.AmbientDimension;
import team.creative.ambientsounds.AmbientEngine;
import team.creative.ambientsounds.AmbientSelection;
import team.creative.ambientsounds.AmbientTickHandler;
import team.creative.ambientsounds.env.BiomeEnviroment;
import team.creative.ambientsounds.env.TerrainEnviroment;
import team.creative.creativecore.common.util.type.list.Pair;

public class AmbientEnviroment {
    public AmbientDimension dimension;
    public boolean muted = false;
    public boolean night;
    public double time;
    public boolean overallRaining;
    public boolean raining;
    public boolean snowing;
    public boolean thundering;
    public BiomeEnviroment biome = new BiomeEnviroment();
    public TerrainEnviroment terrain = new TerrainEnviroment();
    public double biomeVolume = 0.0;
    public double absoluteHeight;
    public double relativeHeight;
    public double relativeMinHeight;
    public double relativeMaxHeight;
    public double underwater;
    public double temperature;

    public void analyzeFast(AmbientDimension dimension, Player player, Level level, float deltaTime) {
        this.dimension = dimension;
        this.overallRaining = level.m_46471_();
        this.raining = level.m_46758_(player.m_142538_());
        this.snowing = level.m_46857_(player.m_142538_()).m_47519_((LevelReader)level, player.m_142538_()) && level.m_46471_();
        this.thundering = level.m_46470_();
        this.absoluteHeight = player.m_20188_();
        this.relativeHeight = this.absoluteHeight - this.terrain.averageHeight;
        this.relativeMinHeight = this.absoluteHeight - (double)this.terrain.minHeight;
        this.relativeMaxHeight = this.absoluteHeight - (double)this.terrain.maxHeight;
        this.temperature = player.f_19853_.m_46857_(player.m_146901_()).m_47554_();
        this.analyzeUnderwater(player, level);
        this.analyzeTime(level, deltaTime);
    }

    public void analyzeTime(Level level, float deltaTime) {
        double sunAngle = Math.toDegrees(level.m_46490_(deltaTime));
        this.night = sunAngle > 90.0 && sunAngle < 270.0;
        double fadeTime = 10.0;
        this.time = sunAngle > 90.0 - fadeTime && sunAngle < 90.0 + fadeTime ? Math.min((sunAngle - (90.0 - fadeTime)) / (fadeTime * 2.0), 1.0) : (sunAngle > 270.0 - fadeTime && sunAngle < 270.0 + fadeTime ? Math.max(1.0 - (sunAngle - (270.0 - fadeTime)) / (fadeTime * 2.0), 0.0) : (this.night ? 0.0 : 1.0));
    }

    public void analyzeUnderwater(Player player, Level level) {
        int depth = 0;
        if (player.m_19941_((Tag)FluidTags.f_13131_)) {
            BlockPos blockpos = new BlockPos((Vec3i)player.m_142538_());
            while (level.m_8055_(blockpos).m_60767_() == Material.f_76305_) {
                ++depth;
                blockpos = blockpos.m_7494_();
            }
            --depth;
        }
        this.underwater = depth;
    }

    public void analyzeSlow(AmbientDimension dimension, AmbientEngine engine, Player player, Level level, float deltaTime) {
        this.terrain.analyze(engine, dimension, player, level);
        AmbientSelection surface = dimension.surfaceSelector != null ? dimension.surfaceSelector.value(this) : null;
        this.biome = new BiomeEnviroment(engine, player, level, this.biomeVolume, surface != null ? surface.getEntireVolume() : 0.0);
    }

    public void collectLevelDetails(List<Pair<String, Object>> details) {
        details.add((Pair<String, Object>)new Pair((Object)"dimension", (Object)this.dimension));
        details.add((Pair<String, Object>)new Pair((Object)"night", (Object)this.night));
        details.add((Pair<String, Object>)new Pair((Object)"rain", (Object)this.raining));
        details.add((Pair<String, Object>)new Pair((Object)"worldRain", (Object)this.overallRaining));
        details.add((Pair<String, Object>)new Pair((Object)"snow", (Object)this.snowing));
        details.add((Pair<String, Object>)new Pair((Object)"storm", (Object)this.thundering));
        details.add((Pair<String, Object>)new Pair((Object)"time", (Object)this.time));
    }

    public void collectPlayerDetails(List<Pair<String, Object>> details, Player player) {
        details.add((Pair<String, Object>)new Pair((Object)"underwater", (Object)this.underwater));
        details.add((Pair<String, Object>)new Pair((Object)"temp", (Object)this.temperature));
        details.add((Pair<String, Object>)new Pair((Object)"height", (Object)("r:" + AmbientTickHandler.df.format(this.relativeHeight) + ",a:" + AmbientTickHandler.df.format(this.terrain.averageHeight) + " (" + AmbientTickHandler.df.format(player.m_20188_() - (double)this.terrain.minHeight) + "," + AmbientTickHandler.df.format(player.m_20188_() - (double)this.terrain.maxHeight) + ")")));
    }

    public void collectTerrainDetails(List<Pair<String, Object>> details) {
        details.add((Pair<String, Object>)new Pair((Object)"features", (Object)this.terrain.airPocket.features.toString(AmbientTickHandler.df)));
        details.add((Pair<String, Object>)new Pair((Object)"light", (Object)this.terrain.airPocket.averageLight));
        details.add((Pair<String, Object>)new Pair((Object)"sky-light", (Object)this.terrain.airPocket.averageSkyLight));
        details.add((Pair<String, Object>)new Pair((Object)"air", (Object)this.terrain.airPocket.air));
    }

    public void collectBiomeDetails(List<Pair<String, Object>> details) {
        details.add((Pair<String, Object>)new Pair((Object)"b-volume", (Object)this.biomeVolume));
        for (Map.Entry<BiomeEnviroment.BiomeArea, Float> pair : this.biome.biomes.entrySet()) {
            details.add((Pair<String, Object>)new Pair((Object)pair.getKey().location.toString(), (Object)pair.getValue()));
        }
    }

    public void reload() {
        this.terrain.scanner = null;
    }
}

