/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.config;

import com.google.common.collect.Lists;
import fuzs.puzzleslib.PuzzlesLib;
import fuzs.puzzleslib.config.AbstractConfig;
import fuzs.puzzleslib.config.ConfigHolder;
import fuzs.puzzleslib.core.ModLoaderEnvironment;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.commons.lang3.StringUtils;

public class ConfigHolderImpl<C extends AbstractConfig, S extends AbstractConfig>
implements ConfigHolder<C, S> {
    @Nullable
    private final C client;
    @Nullable
    private final S server;
    private final List<Runnable> clientCallbacks = Lists.newArrayList();
    private final List<Runnable> serverCallbacks = Lists.newArrayList();
    private String clientFileName = "";
    private String serverFileName = "";

    ConfigHolderImpl(@Nonnull Supplier<C> client, @Nonnull Supplier<S> server) {
        this.client = ModLoaderEnvironment.isClient() ? (AbstractConfig)client.get() : null;
        this.server = (AbstractConfig)server.get();
    }

    private void onModConfig(ModConfig config, String modId, boolean reloading) {
        if (config.getModId().equals(modId)) {
            ModConfig.Type type = config.getType();
            switch (type) {
                case CLIENT: {
                    this.clientCallbacks.forEach(Runnable::run);
                    break;
                }
                case SERVER: {
                    this.serverCallbacks.forEach(Runnable::run);
                    break;
                }
                case COMMON: {
                    throw new RuntimeException("Common config type not supported");
                }
            }
            PuzzlesLib.LOGGER.info("{} {} config for {}", (Object)(reloading ? "Reloading" : "Loading"), (Object)type.extension(), (Object)modId);
        }
    }

    private <T> void addSaveCallback(ModConfig.Type type, ForgeConfigSpec.ConfigValue<T> entry, Consumer<T> save) {
        switch (type) {
            case CLIENT: {
                this.clientCallbacks.add(() -> save.accept(entry.get()));
                break;
            }
            case SERVER: {
                this.serverCallbacks.add(() -> save.accept(entry.get()));
                break;
            }
            case COMMON: {
                throw new RuntimeException("Common config type not supported");
            }
        }
    }

    public void addConfigs(String modId) {
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        modBus.addListener(evt -> this.onModConfig(evt.getConfig(), modId, evt instanceof ModConfigEvent.Reloading));
        this.registerConfigs(ModLoadingContext.get());
    }

    private void registerConfigs(ModLoadingContext context) {
        if (this.client != null) {
            this.addClientCallback(() -> this.client.afterConfigReload());
            this.registerConfig(context, ModConfig.Type.CLIENT, (AbstractConfig)this.client, this.clientFileName);
        }
        if (this.server != null) {
            this.addServerCallback(() -> this.server.afterConfigReload());
            this.registerConfig(context, ModConfig.Type.SERVER, (AbstractConfig)this.server, this.serverFileName);
        }
    }

    private void registerConfig(ModLoadingContext context, final ModConfig.Type type, AbstractConfig config, String fileName) {
        ConfigHolder.ConfigCallback saveCallback = new ConfigHolder.ConfigCallback(){

            @Override
            public <T> void accept(ForgeConfigSpec.ConfigValue<T> entry, Consumer<T> save) {
                ConfigHolderImpl.this.addSaveCallback(type, entry, save);
            }
        };
        if (StringUtils.isEmpty((CharSequence)fileName)) {
            context.registerConfig(type, (IConfigSpec)this.buildSpec(config, saveCallback));
        } else {
            context.registerConfig(type, (IConfigSpec)this.buildSpec(config, saveCallback), fileName);
        }
    }

    private ForgeConfigSpec buildSpec(AbstractConfig config, ConfigHolder.ConfigCallback saveCallback) {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        config.setupConfig(builder, saveCallback);
        return builder.build();
    }

    public ConfigHolderImpl<C, S> setClientFileName(String fileName) {
        this.clientFileName = fileName;
        return this;
    }

    public ConfigHolderImpl<C, S> setServerFileName(String fileName) {
        this.serverFileName = fileName;
        return this;
    }

    @Override
    public C client() {
        return this.client;
    }

    @Override
    public S server() {
        return this.server;
    }

    @Override
    public void addClientCallback(Runnable callback) {
        this.clientCallbacks.add(callback);
    }

    @Override
    public void addServerCallback(Runnable callback) {
        this.serverCallbacks.add(callback);
    }
}

