/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.config.annotation;

import com.google.common.base.CaseFormat;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.ObjectArrays;
import fuzs.puzzleslib.config.AbstractConfig;
import fuzs.puzzleslib.config.ConfigHolder;
import fuzs.puzzleslib.config.annotation.Config;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.common.ForgeConfigSpec;

public class ConfigBuilder {
    public static void serialize(ForgeConfigSpec.Builder builder, ConfigHolder.ConfigCallback saveCallback, @Nonnull Object target) {
        ConfigBuilder.serialize(builder, saveCallback, Maps.newHashMap(), target.getClass(), target);
    }

    public static void serialize(ForgeConfigSpec.Builder builder, ConfigHolder.ConfigCallback saveCallback, Class<?> target) {
        ConfigBuilder.serialize(builder, saveCallback, Maps.newHashMap(), target, null);
    }

    public static void serialize(ForgeConfigSpec.Builder builder, ConfigHolder.ConfigCallback saveCallback, Map<List<String>, String[]> categoryComments, @Nonnull Object target) {
        ConfigBuilder.serialize(builder, saveCallback, categoryComments, target.getClass(), target);
    }

    public static void serialize(ForgeConfigSpec.Builder builder, ConfigHolder.ConfigCallback saveCallback, Map<List<String>, String[]> categoryComments, Class<?> target) {
        ConfigBuilder.serialize(builder, saveCallback, categoryComments, target, null);
    }

    public static <T> void serialize(ForgeConfigSpec.Builder builder, ConfigHolder.ConfigCallback saveCallback, Map<List<String>, String[]> categoryComments, Class<? extends T> target, @Nullable T instance) {
        HashMultimap pathToField = HashMultimap.create();
        for (Field field : ConfigBuilder.getAllFields(target)) {
            Config annotation = field.getDeclaredAnnotation(Config.class);
            if (annotation == null) continue;
            pathToField.put((Object)Lists.newArrayList((Object[])annotation.category()), (Object)field);
        }
        for (Map.Entry entry : pathToField.asMap().entrySet()) {
            List path = (List)entry.getKey();
            ArrayList currentPath = Lists.newArrayList();
            for (String category : path) {
                currentPath.add(category);
                String[] comment = categoryComments.remove(currentPath);
                if (comment != null && comment.length != 0) {
                    builder.comment(comment);
                }
                builder.push(category);
            }
            for (Field field : (Collection)entry.getValue()) {
                field.setAccessible(true);
                boolean isStatic = Modifier.isStatic(field.getModifiers());
                if (!isStatic) {
                    Objects.requireNonNull(instance, "Null instance for non-static field");
                }
                if (Modifier.isFinal(field.getModifiers())) {
                    throw new RuntimeException("Field may not be final");
                }
                ConfigBuilder.buildConfig(builder, saveCallback, isStatic ? null : instance, field, field.getDeclaredAnnotation(Config.class));
            }
            builder.pop(path.size());
        }
        if (!categoryComments.isEmpty()) {
            throw new RuntimeException(String.format("Unknown paths in category comments map: %s", categoryComments.keySet()));
        }
    }

    private static List<Field> getAllFields(Class<?> clazz) {
        LinkedList<Field> list = new LinkedList<Field>();
        while (clazz != Object.class) {
            list.addAll(Arrays.asList(clazz.getDeclaredFields()));
            clazz = clazz.getSuperclass();
        }
        return list;
    }

    private static void buildConfig(ForgeConfigSpec.Builder builder, ConfigHolder.ConfigCallback saveCallback, @Nullable Object instance, Field field, Config annotation) {
        Object defaultValue;
        String name = annotation.name();
        if (name.isEmpty()) {
            name = CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, field.getName());
        }
        Class<?> type = field.getType();
        try {
            defaultValue = field.get(instance);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        Object[] description = annotation.description();
        if (AbstractConfig.class.isAssignableFrom(type)) {
            if (defaultValue != null) {
                AbstractConfig.setupConfig((AbstractConfig)defaultValue, builder, saveCallback);
            } else {
                if (description.length != 0) {
                    builder.comment((String[])description);
                }
                builder.push(name);
                ConfigBuilder.serialize(builder, saveCallback, type);
                builder.pop();
            }
            return;
        }
        if (description.length != 0) {
            builder.comment((String[])description);
        }
        if (annotation.worldRestart()) {
            builder.worldRestart();
        }
        if (type == Boolean.TYPE) {
            ConfigBuilder.addCallback(saveCallback, builder.define(name, ((Boolean)defaultValue).booleanValue()), field, instance);
        } else if (type == Integer.TYPE) {
            int min = Integer.MIN_VALUE;
            int max = Integer.MAX_VALUE;
            Config.IntRange intRange = field.getDeclaredAnnotation(Config.IntRange.class);
            if (intRange != null) {
                min = intRange.min();
                max = intRange.max();
            }
            ConfigBuilder.addCallback(saveCallback, builder.defineInRange(name, ((Integer)defaultValue).intValue(), min, max), field, instance);
        } else if (type == Long.TYPE) {
            long min = Long.MIN_VALUE;
            long max = Long.MAX_VALUE;
            Config.LongRange longRange = field.getDeclaredAnnotation(Config.LongRange.class);
            if (longRange != null) {
                min = longRange.min();
                max = longRange.max();
            }
            ConfigBuilder.addCallback(saveCallback, builder.defineInRange(name, ((Long)defaultValue).longValue(), min, max), field, instance);
        } else if (type == Float.TYPE) {
            float min = Float.MIN_VALUE;
            float max = Float.MAX_VALUE;
            Config.FloatRange floatRange = field.getDeclaredAnnotation(Config.FloatRange.class);
            if (floatRange != null) {
                min = floatRange.min();
                max = floatRange.max();
            }
            ForgeConfigSpec.DoubleValue configValue = builder.defineInRange(name, (double)((Float)defaultValue).floatValue(), (double)min, (double)max);
            saveCallback.accept(configValue, v -> {
                try {
                    field.set(instance, Float.valueOf(((Double)configValue.get()).floatValue()));
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            });
        } else if (type == Double.TYPE) {
            double min = Double.MIN_VALUE;
            double max = Double.MAX_VALUE;
            Config.DoubleRange doubleRange = field.getDeclaredAnnotation(Config.DoubleRange.class);
            if (doubleRange != null) {
                min = doubleRange.min();
                max = doubleRange.max();
            }
            ConfigBuilder.addCallback(saveCallback, builder.defineInRange(name, ((Double)defaultValue).doubleValue(), min, max), field, instance);
        } else if (type == String.class) {
            Config.AllowedValues allowedValues = field.getDeclaredAnnotation(Config.AllowedValues.class);
            if (allowedValues != null && allowedValues.values().length != 0) {
                builder.comment((String[])ObjectArrays.concat((Object[])description, (Object)String.format("Allowed Values: %s", String.join((CharSequence)", ", allowedValues.values()))));
                ConfigBuilder.addCallback(saveCallback, builder.define(name, (Object)((String)defaultValue), o -> ConfigBuilder.testAllowedValues(allowedValues.values(), o)), field, instance);
            } else {
                ConfigBuilder.addCallback(saveCallback, builder.define(name, (Object)((String)defaultValue)), field, instance);
            }
        } else if (type.isEnum()) {
            Config.AllowedValues allowedValues = field.getDeclaredAnnotation(Config.AllowedValues.class);
            if (allowedValues != null && allowedValues.values().length != 0) {
                ConfigBuilder.addCallback(saveCallback, builder.defineEnum(name, (Enum)defaultValue, o -> ConfigBuilder.testAllowedValues(allowedValues.values(), o)), field, instance);
            } else {
                ConfigBuilder.addCallback(saveCallback, builder.defineEnum(name, (Enum)defaultValue), field, instance);
            }
        } else if (type == List.class) {
            Config.AllowedValues allowedValues = field.getDeclaredAnnotation(Config.AllowedValues.class);
            if (allowedValues != null && allowedValues.values().length != 0) {
                builder.comment((String[])ObjectArrays.concat((Object[])description, (Object)String.format("Allowed Values: %s", String.join((CharSequence)", ", allowedValues.values()))));
                ConfigBuilder.addCallback(saveCallback, builder.defineList(name, (List)defaultValue, o -> ConfigBuilder.testAllowedValues(allowedValues.values(), o)), field, instance);
            } else {
                ConfigBuilder.addCallback(saveCallback, builder.defineList(name, (List)defaultValue, o -> true), field, instance);
            }
        }
    }

    private static boolean testAllowedValues(String[] allowedValues, Object o) {
        if (o != null) {
            String value = o instanceof Enum ? ((Enum)o).name() : o.toString();
            for (String allowedValue : allowedValues) {
                if (!allowedValue.equals(value)) continue;
                return true;
            }
        }
        return false;
    }

    private static void addCallback(ConfigHolder.ConfigCallback saveCallback, ForgeConfigSpec.ConfigValue<?> configValue, Field field, @Nullable Object instance) {
        saveCallback.accept(configValue, v -> {
            try {
                field.set(instance, configValue.get());
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        });
    }
}

