/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.telepathicgrunt.repurposedstructures.biomeinjection.Dungeons;
import com.telepathicgrunt.repurposedstructures.biomeinjection.TemporaryBiomeInjection;
import com.telepathicgrunt.repurposedstructures.biomeinjection.Wells;
import com.telepathicgrunt.repurposedstructures.configs.RSBastionsConfig;
import com.telepathicgrunt.repurposedstructures.configs.RSBiomeDimConfig;
import com.telepathicgrunt.repurposedstructures.configs.RSCitiesConfig;
import com.telepathicgrunt.repurposedstructures.configs.RSDungeonsConfig;
import com.telepathicgrunt.repurposedstructures.configs.RSFortressesConfig;
import com.telepathicgrunt.repurposedstructures.configs.RSIgloosConfig;
import com.telepathicgrunt.repurposedstructures.configs.RSMansionsConfig;
import com.telepathicgrunt.repurposedstructures.configs.RSMapTradeConfig;
import com.telepathicgrunt.repurposedstructures.configs.RSMineshaftsConfig;
import com.telepathicgrunt.repurposedstructures.configs.RSMiscConfig;
import com.telepathicgrunt.repurposedstructures.configs.RSModdedLootConfig;
import com.telepathicgrunt.repurposedstructures.configs.RSNaturalMobSpawningConfig;
import com.telepathicgrunt.repurposedstructures.configs.RSOutpostsConfig;
import com.telepathicgrunt.repurposedstructures.configs.RSPyramidsConfig;
import com.telepathicgrunt.repurposedstructures.configs.RSRuinedPortalsConfig;
import com.telepathicgrunt.repurposedstructures.configs.RSRuinsConfig;
import com.telepathicgrunt.repurposedstructures.configs.RSShipwrecksConfig;
import com.telepathicgrunt.repurposedstructures.configs.RSStrongholdsConfig;
import com.telepathicgrunt.repurposedstructures.configs.RSTemplesConfig;
import com.telepathicgrunt.repurposedstructures.configs.RSVillagesConfig;
import com.telepathicgrunt.repurposedstructures.configs.RSWellsConfig;
import com.telepathicgrunt.repurposedstructures.configs.RSWitchHutsConfig;
import com.telepathicgrunt.repurposedstructures.configs.omegaconfig.OmegaConfig;
import com.telepathicgrunt.repurposedstructures.misc.BiomeDimensionAllowDisallow;
import com.telepathicgrunt.repurposedstructures.misc.EndRemasteredDedicatedLoot;
import com.telepathicgrunt.repurposedstructures.misc.JSONConditionsRegistry;
import com.telepathicgrunt.repurposedstructures.misc.MobMapTrades;
import com.telepathicgrunt.repurposedstructures.misc.MobSpawnerManager;
import com.telepathicgrunt.repurposedstructures.misc.MobSpawningOverTime;
import com.telepathicgrunt.repurposedstructures.misc.NoiseSettingsDeepCopier;
import com.telepathicgrunt.repurposedstructures.misc.PoolAdditionMerger;
import com.telepathicgrunt.repurposedstructures.misc.StructureModdedLootImporter;
import com.telepathicgrunt.repurposedstructures.misc.StructurePieceCountsManager;
import com.telepathicgrunt.repurposedstructures.mixin.structures.StructureSettingsAccessor;
import com.telepathicgrunt.repurposedstructures.mixin.world.ChunkGeneratorAccessor;
import com.telepathicgrunt.repurposedstructures.modinit.RSConfiguredFeatures;
import com.telepathicgrunt.repurposedstructures.modinit.RSConfiguredStructures;
import com.telepathicgrunt.repurposedstructures.modinit.RSFeatures;
import com.telepathicgrunt.repurposedstructures.modinit.RSGlobalLootModifier;
import com.telepathicgrunt.repurposedstructures.modinit.RSPlacements;
import com.telepathicgrunt.repurposedstructures.modinit.RSPredicates;
import com.telepathicgrunt.repurposedstructures.modinit.RSProcessors;
import com.telepathicgrunt.repurposedstructures.modinit.RSStructureTagMap;
import com.telepathicgrunt.repurposedstructures.modinit.RSStructures;
import com.telepathicgrunt.repurposedstructures.utils.GeneralUtils;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.FlatLevelSource;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.StructureSettings;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.StructureFeatureConfiguration;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fml.loading.FileUtils;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="repurposed_structures")
public class RepurposedStructures {
    public static final String MODID = "repurposed_structures";
    public static final Logger LOGGER = LogManager.getLogger();
    public static final RSBiomeDimConfig omegaBiomeDimConfig = OmegaConfig.register(RSBiomeDimConfig.class);
    public static final RSNaturalMobSpawningConfig omegaMobSpawnConfig = OmegaConfig.register(RSNaturalMobSpawningConfig.class);
    public static final RSMapTradeConfig omegaMapTradeConfig = OmegaConfig.register(RSMapTradeConfig.class);
    public static MobSpawnerManager mobSpawnerManager = new MobSpawnerManager();
    public static StructurePieceCountsManager structurePieceCountsManager = new StructurePieceCountsManager();

    public RepurposedStructures() {
        JSONConditionsRegistry.registerTestJSONCondition();
        FileUtils.getOrCreateDirectory((Path)FMLPaths.CONFIGDIR.get().resolve("repurposed_structures-forge"), (String)"repurposed_structures-forge");
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)RSModdedLootConfig.GENERAL_SPEC, "repurposed_structures-forge/modded_loot.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)RSDungeonsConfig.GENERAL_SPEC, "repurposed_structures-forge/dungeons.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)RSMineshaftsConfig.GENERAL_SPEC, "repurposed_structures-forge/mineshafts.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)RSStrongholdsConfig.GENERAL_SPEC, "repurposed_structures-forge/strongholds.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)RSWellsConfig.GENERAL_SPEC, "repurposed_structures-forge/wells.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)RSShipwrecksConfig.GENERAL_SPEC, "repurposed_structures-forge/shipwrecks.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)RSOutpostsConfig.GENERAL_SPEC, "repurposed_structures-forge/outposts.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)RSTemplesConfig.GENERAL_SPEC, "repurposed_structures-forge/temples.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)RSVillagesConfig.GENERAL_SPEC, "repurposed_structures-forge/villages.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)RSMansionsConfig.GENERAL_SPEC, "repurposed_structures-forge/mansions.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)RSWitchHutsConfig.GENERAL_SPEC, "repurposed_structures-forge/witch_huts.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)RSBastionsConfig.GENERAL_SPEC, "repurposed_structures-forge/bastions.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)RSCitiesConfig.GENERAL_SPEC, "repurposed_structures-forge/cities.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)RSFortressesConfig.GENERAL_SPEC, "repurposed_structures-forge/fortresses.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)RSIgloosConfig.GENERAL_SPEC, "repurposed_structures-forge/igloos.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)RSRuinedPortalsConfig.GENERAL_SPEC, "repurposed_structures-forge/ruined_portals.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)RSRuinsConfig.GENERAL_SPEC, "repurposed_structures-forge/ruins.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)RSPyramidsConfig.GENERAL_SPEC, "repurposed_structures-forge/pyramids.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)RSMiscConfig.GENERAL_SPEC, "repurposed_structures-forge/misc.toml");
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        forgeBus.addListener(this::biomeModification);
        forgeBus.addListener(this::serverStarted);
        forgeBus.addListener(this::registerDatapackListener);
        forgeBus.addListener(EventPriority.HIGHEST, this::deepCopyDimensionalSpacing);
        forgeBus.addListener(this::addDimensionalSpacing);
        forgeBus.addListener(MobMapTrades::onVillagerTradesEvent);
        forgeBus.addListener(MobMapTrades::onWandererTradesEvent);
        forgeBus.addListener(PoolAdditionMerger::mergeAdditionPools);
        modEventBus.addListener(this::setup);
        RSFeatures.FEATURES.register(modEventBus);
        RSStructures.STRUCTURE_FEATURES.register(modEventBus);
        RSGlobalLootModifier.GLM.register(modEventBus);
        EndRemasteredDedicatedLoot.isEndRemasteredOn = ModList.get().isLoaded("endrem");
    }

    public void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            RSProcessors.registerProcessors();
            RSPredicates.registerPredicates();
            RSPlacements.registerPlacements();
            RSConfiguredFeatures.registerConfiguredFeatures();
            RSConfiguredFeatures.registerPlacedFeatures();
            RSStructures.setupStructures();
            RSConfiguredStructures.registerStructureFeatures();
            RSStructureTagMap.setupTags();
            RSGlobalLootModifier.registerLootData();
            BiomeDimensionAllowDisallow.setupAllowDisallowMaps();
            MobSpawningOverTime.setupMobSpawningMaps();
            MobMapTrades.setupMapTrades();
            BuiltinRegistries.f_123866_.m_6579_().forEach(settings -> {
                Map structureMap = ((NoiseGeneratorSettings)settings.getValue()).m_64457_().m_64590_();
                if (structureMap instanceof ImmutableMap) {
                    HashMap tempMap = new HashMap(structureMap);
                    tempMap.putAll(RSStructures.RS_STRUCTURES);
                    ((StructureSettingsAccessor)((NoiseGeneratorSettings)settings.getValue()).m_64457_()).setStructureConfig(tempMap);
                } else {
                    structureMap.putAll(RSStructures.RS_STRUCTURES);
                }
            });
        });
    }

    public void registerDatapackListener(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)mobSpawnerManager);
        event.addListener((PreparableReloadListener)structurePieceCountsManager);
    }

    public void biomeModification(BiomeLoadingEvent event) {
        RepurposedStructures.addFeaturesAndStructuresToBiomes(event);
    }

    public void serverStarted(ServerStartedEvent event) {
        GeneralUtils.clearCache();
        StructureModdedLootImporter.checkLoottables(event.getServer());
        EndRemasteredDedicatedLoot.checkLoottables(event.getServer());
    }

    public void deepCopyDimensionalSpacing(WorldEvent.Load event) {
        LevelAccessor levelAccessor = event.getWorld();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)levelAccessor;
            ResourceLocation cgRL = Registry.f_122890_.m_7981_(((ChunkGeneratorAccessor)serverLevel.m_7726_().m_8481_()).repurposedstructures_getCodec());
            if (cgRL != null && cgRL.m_135827_().equals("terraforged")) {
                return;
            }
            ChunkGenerator chunkGenerator = serverLevel.m_7726_().m_8481_();
            ((ChunkGeneratorAccessor)chunkGenerator).repurposedstructures_setSettings(NoiseSettingsDeepCopier.deepCopyDimensionStructuresSettings(chunkGenerator.m_62205_()));
        }
    }

    public void addDimensionalSpacing(WorldEvent.Load event) {
        block5: {
            HashMap tempMap;
            StructureSettings worldStructureSettings;
            block7: {
                Set possibleBiomes;
                Registry biomeRegistry;
                ServerLevel serverLevel;
                block6: {
                    LevelAccessor levelAccessor = event.getWorld();
                    if (!(levelAccessor instanceof ServerLevel)) break block5;
                    serverLevel = (ServerLevel)levelAccessor;
                    worldStructureSettings = serverLevel.m_7726_().m_8481_().m_62205_();
                    biomeRegistry = serverLevel.m_5962_().m_175515_(Registry.f_122885_);
                    possibleBiomes = serverLevel.m_7726_().m_8481_().m_62218_().m_196676_();
                    HashMap tempStructureToMultiMap = new HashMap();
                    ((StructureSettingsAccessor)worldStructureSettings).getConfiguredStructures().forEach((key, value) -> tempStructureToMultiMap.put((StructureFeature<?>)key, (Multimap<ConfiguredStructureFeature<?, ?>, ResourceKey<Biome>>)HashMultimap.create((Multimap)value)));
                    TemporaryBiomeInjection.addStructureToBiomes(tempStructureToMultiMap, (Registry<Biome>)biomeRegistry);
                    ImmutableMap.Builder immutableOuterMap = ImmutableMap.builder();
                    tempStructureToMultiMap.forEach((key, value) -> {
                        ImmutableMultimap.Builder immutableInnerMultiMap = ImmutableMultimap.builder();
                        immutableInnerMultiMap.putAll(value);
                        immutableOuterMap.put(key, (Object)immutableInnerMultiMap.build());
                    });
                    ((StructureSettingsAccessor)worldStructureSettings).setConfiguredStructures(immutableOuterMap.build());
                    ResourceLocation cgRL = Registry.f_122890_.m_7981_(((ChunkGeneratorAccessor)serverLevel.m_7726_().m_8481_()).repurposedstructures_getCodec());
                    if (cgRL != null && cgRL.m_135827_().equals("terraforged")) {
                        return;
                    }
                    tempMap = new HashMap(worldStructureSettings.m_64590_());
                    if (!(serverLevel.m_7726_().m_8481_() instanceof FlatLevelSource) || !serverLevel.m_46472_().equals((Object)Level.f_46428_)) break block6;
                    tempMap.keySet().removeAll(RSStructures.RS_STRUCTURES.keySet());
                    break block7;
                }
                for (Map.Entry<StructureFeature<?>, StructureFeatureConfiguration> structureFeatureEntry : RSStructures.RS_STRUCTURES.entrySet()) {
                    block9: {
                        block8: {
                            boolean isWorldBlacklisted = GeneralUtils.isBlacklistedForWorld((ServerLevelAccessor)serverLevel, ForgeRegistries.STRUCTURE_FEATURES.getKey(structureFeatureEntry.getKey()));
                            Set validBiomesForStructure = serverLevel.m_7726_().m_8481_().m_62205_().m_189371_(structureFeatureEntry.getKey()).values().stream().map(arg_0 -> ((Registry)biomeRegistry).m_6246_(arg_0)).collect(Collectors.toSet());
                            if (isWorldBlacklisted) break block8;
                            if (!validBiomesForStructure.stream().noneMatch(possibleBiomes::contains)) break block9;
                        }
                        tempMap.remove(structureFeatureEntry.getKey());
                        continue;
                    }
                    tempMap.putIfAbsent(structureFeatureEntry.getKey(), structureFeatureEntry.getValue());
                }
            }
            ((StructureSettingsAccessor)worldStructureSettings).setStructureConfig(tempMap);
        }
    }

    public static void addFeaturesAndStructuresToBiomes(BiomeLoadingEvent event) {
        Dungeons.addDungeons(event);
        Wells.addWells(event);
    }
}

