/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.biomeinjection;

import com.telepathicgrunt.repurposedstructures.configs.RSDungeonsConfig;
import com.telepathicgrunt.repurposedstructures.modinit.RSConfiguredFeatures;
import com.telepathicgrunt.repurposedstructures.utils.BiomeSelection;
import com.telepathicgrunt.repurposedstructures.utils.GeneralUtils;
import net.minecraft.data.worldgen.placement.CavePlacements;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.event.world.BiomeLoadingEvent;

public final class Dungeons {
    private Dungeons() {
    }

    public static void addDungeons(BiomeLoadingEvent event) {
        if ((Integer)RSDungeonsConfig.jungleDungeonAttemptsPerChunk.get() != 0 && BiomeSelection.isBiomeAllowed(event, RSConfiguredFeatures.JUNGLE_DUNGEONS_PLACED, () -> BiomeSelection.haveCategories(event, Biome.BiomeCategory.JUNGLE))) {
            event.getGeneration().getFeatures(GenerationStep.Decoration.UNDERGROUND_STRUCTURES).add(() -> RSConfiguredFeatures.JUNGLE_DUNGEONS_PLACED);
        }
        if ((Integer)RSDungeonsConfig.badlandsDungeonAttemptsPerChunk.get() != 0 && BiomeSelection.isBiomeAllowed(event, RSConfiguredFeatures.BADLANDS_DUNGEONS_PLACED, () -> BiomeSelection.haveCategories(event, Biome.BiomeCategory.MESA))) {
            event.getGeneration().getFeatures(GenerationStep.Decoration.UNDERGROUND_STRUCTURES).add(() -> RSConfiguredFeatures.BADLANDS_DUNGEONS_PLACED);
        }
        if ((Integer)RSDungeonsConfig.darkForestDungeonAttemptsPerChunk.get() != 0 && BiomeSelection.isBiomeAllowed(event, RSConfiguredFeatures.DARK_FOREST_DUNGEONS_PLACED, () -> BiomeSelection.haveCategories(event, Biome.BiomeCategory.FOREST) && BiomeSelection.hasName(event, "dark", "spooky", "dead", "haunted", "evil", "witch", "ominous", "ebony"))) {
            event.getGeneration().getFeatures(GenerationStep.Decoration.UNDERGROUND_STRUCTURES).add(() -> RSConfiguredFeatures.DARK_FOREST_DUNGEONS_PLACED);
        }
        if ((Integer)RSDungeonsConfig.desertDungeonAttemptsPerChunk.get() != 0 && BiomeSelection.isBiomeAllowed(event, RSConfiguredFeatures.DESERT_DUNGEONS_PLACED, () -> BiomeSelection.haveCategories(event, Biome.BiomeCategory.DESERT))) {
            event.getGeneration().getFeatures(GenerationStep.Decoration.UNDERGROUND_STRUCTURES).add(() -> RSConfiguredFeatures.DESERT_DUNGEONS_PLACED);
        }
        if ((Integer)RSDungeonsConfig.deepDungeonAttemptsPerChunk.get() != 0 && BiomeSelection.isBiomeAllowed(event, RSConfiguredFeatures.DEEP_DUNGEONS_PLACED, () -> !BiomeSelection.haveCategories(event, Biome.BiomeCategory.NETHER, Biome.BiomeCategory.THEEND, Biome.BiomeCategory.NONE))) {
            event.getGeneration().getFeatures(GenerationStep.Decoration.UNDERGROUND_STRUCTURES).add(() -> RSConfiguredFeatures.DEEP_DUNGEONS_PLACED);
            event.getGeneration().getFeatures(GenerationStep.Decoration.UNDERGROUND_STRUCTURES).removeIf(placedFeatureSupplier -> GeneralUtils.serializeAndCompareFeature((PlacedFeature)placedFeatureSupplier.get(), CavePlacements.f_195236_));
        }
        if ((Integer)RSDungeonsConfig.mushroomDungeonAttemptsPerChunk.get() != 0 && BiomeSelection.isBiomeAllowed(event, RSConfiguredFeatures.MUSHROOM_DUNGEONS_PLACED, () -> BiomeSelection.haveCategories(event, Biome.BiomeCategory.MUSHROOM))) {
            event.getGeneration().getFeatures(GenerationStep.Decoration.UNDERGROUND_STRUCTURES).add(() -> RSConfiguredFeatures.MUSHROOM_DUNGEONS_PLACED);
        }
        if ((Integer)RSDungeonsConfig.swampDungeonAttemptsPerChunk.get() != 0 && BiomeSelection.isBiomeAllowed(event, RSConfiguredFeatures.SWAMP_DUNGEONS_PLACED, () -> BiomeSelection.haveCategories(event, Biome.BiomeCategory.SWAMP))) {
            event.getGeneration().getFeatures(GenerationStep.Decoration.UNDERGROUND_STRUCTURES).add(() -> RSConfiguredFeatures.SWAMP_DUNGEONS_PLACED);
        }
        if ((Integer)RSDungeonsConfig.icyDungeonAttemptsPerChunk.get() != 0 && BiomeSelection.isBiomeAllowed(event, RSConfiguredFeatures.ICY_DUNGEONS_PLACED, () -> BiomeSelection.hasName(event, "icy", "ice", "frozen", "glacier", "glacial") && (BiomeSelection.haveCategories(event, Biome.BiomeCategory.ICY) || BiomeSelection.haveCategories(event, Biome.BiomeCategory.MOUNTAIN) && event.getClimate().f_47681_ < 0.0f))) {
            event.getGeneration().getFeatures(GenerationStep.Decoration.UNDERGROUND_STRUCTURES).add(() -> RSConfiguredFeatures.ICY_DUNGEONS_PLACED);
        }
        if ((Integer)RSDungeonsConfig.snowDungeonAttemptsPerChunk.get() != 0 && BiomeSelection.isBiomeAllowed(event, RSConfiguredFeatures.SNOW_DUNGEONS_PLACED, () -> !BiomeSelection.hasName(event, "icy", "ice", "frozen", "glacier", "glacial") && (BiomeSelection.hasName(event, "snow") || BiomeSelection.haveCategories(event, Biome.BiomeCategory.ICY) || BiomeSelection.haveCategories(event, Biome.BiomeCategory.MOUNTAIN) && event.getClimate().f_47681_ < 0.0f))) {
            event.getGeneration().getFeatures(GenerationStep.Decoration.UNDERGROUND_STRUCTURES).add(() -> RSConfiguredFeatures.SNOW_DUNGEONS_PLACED);
        }
        if ((Integer)RSDungeonsConfig.netherDungeonAttemptsPerChunk.get() != 0 && BiomeSelection.isBiomeAllowed(event, RSConfiguredFeatures.NETHER_DUNGEONS_PLACED, () -> BiomeSelection.haveCategories(event, Biome.BiomeCategory.NETHER))) {
            event.getGeneration().getFeatures(GenerationStep.Decoration.VEGETAL_DECORATION).add(() -> RSConfiguredFeatures.NETHER_DUNGEONS_PLACED);
        }
        if ((Integer)RSDungeonsConfig.endDungeonAttemptsPerChunk.get() != 0 && BiomeSelection.isBiomeAllowed(event, RSConfiguredFeatures.END_DUNGEONS_PLACED, () -> BiomeSelection.haveCategories(event, Biome.BiomeCategory.THEEND) && !BiomeSelection.isBiome(event, Biomes.f_48210_, Biomes.f_48162_))) {
            event.getGeneration().getFeatures(GenerationStep.Decoration.UNDERGROUND_STRUCTURES).add(() -> RSConfiguredFeatures.END_DUNGEONS_PLACED);
        }
        if ((Integer)RSDungeonsConfig.oceanDungeonAttemptsPerChunk.get() != 0) {
            if (BiomeSelection.isBiomeAllowed(event, RSConfiguredFeatures.OCEAN_LUKEWARM_DUNGEONS_PLACED, () -> BiomeSelection.haveCategories(event, Biome.BiomeCategory.OCEAN) && (BiomeSelection.hasName(event, "lukewarm") || !BiomeSelection.hasNamespace(event, "minecraft") && event.getClimate().f_47681_ >= 0.9f && event.getClimate().f_47681_ < 1.5f))) {
                event.getGeneration().getFeatures(GenerationStep.Decoration.UNDERGROUND_STRUCTURES).add(() -> RSConfiguredFeatures.OCEAN_LUKEWARM_DUNGEONS_PLACED);
            }
            if (BiomeSelection.isBiomeAllowed(event, RSConfiguredFeatures.OCEAN_WARM_DUNGEONS_PLACED, () -> BiomeSelection.haveCategories(event, Biome.BiomeCategory.OCEAN) && (BiomeSelection.hasName(event, "hot", "tropic", "warm") && !BiomeSelection.hasName(event, "lukewarm") || !BiomeSelection.hasNamespace(event, "minecraft") && event.getClimate().f_47681_ >= 1.5f))) {
                event.getGeneration().getFeatures(GenerationStep.Decoration.UNDERGROUND_STRUCTURES).add(() -> RSConfiguredFeatures.OCEAN_WARM_DUNGEONS_PLACED);
            }
            if (BiomeSelection.isBiomeAllowed(event, RSConfiguredFeatures.OCEAN_COLD_DUNGEONS_PLACED, () -> BiomeSelection.haveCategories(event, Biome.BiomeCategory.OCEAN) && (BiomeSelection.hasName(event, "cold") || !BiomeSelection.hasNamespace(event, "minecraft") && event.getClimate().f_47681_ >= 0.0f && event.getClimate().f_47681_ < 0.5f))) {
                event.getGeneration().getFeatures(GenerationStep.Decoration.UNDERGROUND_STRUCTURES).add(() -> RSConfiguredFeatures.OCEAN_COLD_DUNGEONS_PLACED);
            }
            if (BiomeSelection.isBiomeAllowed(event, RSConfiguredFeatures.OCEAN_FROZEN_DUNGEONS_PLACED, () -> BiomeSelection.haveCategories(event, Biome.BiomeCategory.OCEAN) && (BiomeSelection.hasName(event, "frozen", "snow", "ice") || !BiomeSelection.hasNamespace(event, "minecraft") && event.getClimate().f_47681_ >= 0.9f && event.getClimate().f_47681_ < 1.5f))) {
                event.getGeneration().getFeatures(GenerationStep.Decoration.UNDERGROUND_STRUCTURES).add(() -> RSConfiguredFeatures.OCEAN_FROZEN_DUNGEONS_PLACED);
            }
            if (BiomeSelection.isBiomeAllowed(event, RSConfiguredFeatures.OCEAN_NEUTRAL_DUNGEONS_PLACED, () -> BiomeSelection.haveCategories(event, Biome.BiomeCategory.OCEAN) && (!BiomeSelection.hasName(event, "hot", "tropic", "warm", "cold", "frozen", "snow", "ice") || !BiomeSelection.hasNamespace(event, "minecraft") && event.getClimate().f_47681_ >= 0.5f && event.getClimate().f_47681_ < 0.9f))) {
                event.getGeneration().getFeatures(GenerationStep.Decoration.UNDERGROUND_STRUCTURES).add(() -> RSConfiguredFeatures.OCEAN_NEUTRAL_DUNGEONS_PLACED);
            }
        }
    }
}

