/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.biomeinjection;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.telepathicgrunt.repurposedstructures.biomeinjection.Bastions;
import com.telepathicgrunt.repurposedstructures.biomeinjection.Cities;
import com.telepathicgrunt.repurposedstructures.biomeinjection.Fortresses;
import com.telepathicgrunt.repurposedstructures.biomeinjection.Igloos;
import com.telepathicgrunt.repurposedstructures.biomeinjection.Mansions;
import com.telepathicgrunt.repurposedstructures.biomeinjection.Mineshafts;
import com.telepathicgrunt.repurposedstructures.biomeinjection.Outposts;
import com.telepathicgrunt.repurposedstructures.biomeinjection.Pyramids;
import com.telepathicgrunt.repurposedstructures.biomeinjection.RuinedPortals;
import com.telepathicgrunt.repurposedstructures.biomeinjection.Ruins;
import com.telepathicgrunt.repurposedstructures.biomeinjection.Shipwrecks;
import com.telepathicgrunt.repurposedstructures.biomeinjection.Strongholds;
import com.telepathicgrunt.repurposedstructures.biomeinjection.Temples;
import com.telepathicgrunt.repurposedstructures.biomeinjection.Villages;
import com.telepathicgrunt.repurposedstructures.biomeinjection.WitchHuts;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import net.minecraft.world.level.levelgen.feature.StructureFeature;

public final class TemporaryBiomeInjection {
    private TemporaryBiomeInjection() {
    }

    public static void addStructureToBiomes(Map<StructureFeature<?>, Multimap<ConfiguredStructureFeature<?, ?>, ResourceKey<Biome>>> structureToMultiMap, Registry<Biome> biomeRegistry) {
        TemporaryBiomeInjection.addConfiguredStructureEntries(structureToMultiMap, biomeRegistry, Bastions::addBastions);
        TemporaryBiomeInjection.addConfiguredStructureEntries(structureToMultiMap, biomeRegistry, Cities::addCities);
        TemporaryBiomeInjection.addConfiguredStructureEntries(structureToMultiMap, biomeRegistry, Fortresses::addJungleFortress);
        TemporaryBiomeInjection.addConfiguredStructureEntries(structureToMultiMap, biomeRegistry, Igloos::addIgloos);
        TemporaryBiomeInjection.addConfiguredStructureEntries(structureToMultiMap, biomeRegistry, Mansions::addMansions);
        TemporaryBiomeInjection.addConfiguredStructureEntries(structureToMultiMap, biomeRegistry, Mineshafts::addMineshafts);
        TemporaryBiomeInjection.addConfiguredStructureEntries(structureToMultiMap, biomeRegistry, Outposts::addOutposts);
        TemporaryBiomeInjection.addConfiguredStructureEntries(structureToMultiMap, biomeRegistry, Pyramids::addPyramids);
        TemporaryBiomeInjection.addConfiguredStructureEntries(structureToMultiMap, biomeRegistry, RuinedPortals::addRuinedPortals);
        TemporaryBiomeInjection.addConfiguredStructureEntries(structureToMultiMap, biomeRegistry, Ruins::addRuins);
        TemporaryBiomeInjection.addConfiguredStructureEntries(structureToMultiMap, biomeRegistry, Shipwrecks::addShipwrecks);
        TemporaryBiomeInjection.addConfiguredStructureEntries(structureToMultiMap, biomeRegistry, Strongholds::addStrongholds);
        TemporaryBiomeInjection.addConfiguredStructureEntries(structureToMultiMap, biomeRegistry, Temples::addTemples);
        TemporaryBiomeInjection.addConfiguredStructureEntries(structureToMultiMap, biomeRegistry, Villages::addVillages);
        TemporaryBiomeInjection.addConfiguredStructureEntries(structureToMultiMap, biomeRegistry, WitchHuts::addWitchHuts);
    }

    private static void addConfiguredStructureEntries(Map<StructureFeature<?>, Multimap<ConfiguredStructureFeature<?, ?>, ResourceKey<Biome>>> structureToMultiMap, Registry<Biome> biomeRegistry, Consumer<BiomeInjectionHelper> structureAddition) {
        for (Map.Entry biomeEntry : biomeRegistry.m_6579_()) {
            structureAddition.accept(new BiomeInjectionHelper(biomeEntry, biomeRegistry, structureToMultiMap));
        }
    }

    public static class BiomeInjectionHelper {
        public final Biome biome;
        public final ResourceKey<Biome> biomeKey;
        public final Registry<Biome> biomeRegistry;
        public final Map<StructureFeature<?>, Multimap<ConfiguredStructureFeature<?, ?>, ResourceKey<Biome>>> structureToMultiMap;

        public BiomeInjectionHelper(Map.Entry<ResourceKey<Biome>, Biome> biomeEntry, Registry<Biome> biomeRegistry, Map<StructureFeature<?>, Multimap<ConfiguredStructureFeature<?, ?>, ResourceKey<Biome>>> structureToMultiMap) {
            this.biome = biomeEntry.getValue();
            this.biomeKey = biomeEntry.getKey();
            this.biomeRegistry = biomeRegistry;
            this.structureToMultiMap = structureToMultiMap;
        }

        public ResourceKey<Biome> getBiomeKey() {
            return (ResourceKey)this.biomeRegistry.m_7854_((Object)this.biome).get();
        }

        public void addStructure(ConfiguredStructureFeature<?, ?> configuredStructureFeature) {
            this.structureToMultiMap.computeIfAbsent(configuredStructureFeature.f_65403_, f -> HashMultimap.create());
            this.structureToMultiMap.get(configuredStructureFeature.f_65403_).put(configuredStructureFeature, this.biomeKey);
        }

        public void removeStructure(ConfiguredStructureFeature<?, ?> configuredStructureFeature) {
            Multimap<ConfiguredStructureFeature<?, ?>, ResourceKey<Biome>> structureFeatureResourceKeyMultimap = this.structureToMultiMap.get(configuredStructureFeature.f_65403_);
            structureFeatureResourceKeyMultimap.remove(configuredStructureFeature, this.biomeKey);
        }
    }
}

