/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.configs;

import net.minecraftforge.common.ForgeConfigSpec;

public class RSFortressesConfig {
    public static final ForgeConfigSpec GENERAL_SPEC;
    public static ForgeConfigSpec.IntValue jungleFortressAverageChunkDistance;
    public static ForgeConfigSpec.IntValue jungleFortressSize;
    public static ForgeConfigSpec.ConfigValue<Integer> jungleFortressMinHeight;
    public static ForgeConfigSpec.ConfigValue<Integer> jungleFortressMaxHeight;
    public static ForgeConfigSpec.ConfigValue<Integer> jungleFortressVerticalRange;

    private static void setupConfig(ForgeConfigSpec.Builder builder) {
        jungleFortressAverageChunkDistance = builder.comment(new String[]{"\n Average distance between spawn attempts for Jungle Fortresses.", " 1 for spawning in most chunks and 1001 for no spawn."}).translation("repurposedstructures.junglefortressaveragechunkdistance").defineInRange("jungleFortressAverageChunkDistance", 50, 1, 1001);
        jungleFortressSize = builder.comment("\n Size of the fortress. This is how many pieces long a branch can be from the start piece.").translation("repurposedstructures.jungleFortressSize").defineInRange("jungleFortressSize", 10, 1, 30);
        jungleFortressMinHeight = builder.comment("\n Min Y height that the starting point can spawn at.").translation("repurposedstructures.junglefortressminheight").define("jungleFortressMinHeight", (Object)56);
        jungleFortressMaxHeight = builder.comment(new String[]{"\n Max Y height that the starting point can spawn at.", "\nIf below min height, this will be read as min."}).translation("repurposedstructures.junglefortressmaxheight").define("jungleFortressMaxHeight", (Object)65);
        jungleFortressVerticalRange = builder.comment("\n How far above or below the fortress's pieces can generate away from the center piece.").translation("repurposedstructures.junglefortressverticalrange").define("jungleFortressVerticalRange", (Object)33);
    }

    static {
        ForgeConfigSpec.Builder configBuilder = new ForgeConfigSpec.Builder();
        RSFortressesConfig.setupConfig(configBuilder);
        GENERAL_SPEC = configBuilder.build();
    }
}

