/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.configs;

import com.telepathicgrunt.repurposedstructures.configs.omegaconfig.api.Comment;
import com.telepathicgrunt.repurposedstructures.configs.omegaconfig.api.Config;
import com.telepathicgrunt.repurposedstructures.misc.MobMapTrades;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RSMapTradeConfig
implements Config {
    @Comment(value="\n\n\n\n\n\n\n// Adds structure maps to any Villager's trades.\n// This should work with modded villager professions as well, but you will need to know its registry name.\n// Disabling a structure will not automatically remove the structure from the trades (The explorer map to the structure becomes an empty map).")
    public final Map<String, List<MobMapTrades.VillagerTradeEntry>> villagerMapTrades = new HashMap<String, List<MobMapTrades.VillagerTradeEntry>>(){
        {
            this.put("minecraft:cartographer", Arrays.asList(new MobMapTrades.VillagerTradeEntry("repurposed_structures:fortress_jungle", "BANNER_GREEN", 3, 13, 12, 10), new MobMapTrades.VillagerTradeEntry("repurposed_structures:fortress_jungle", "BANNER_GREEN", 4, 14, 12, 10), new MobMapTrades.VillagerTradeEntry("repurposed_structures:mansion_birch", "MANSION", 4, 14, 12, 10), new MobMapTrades.VillagerTradeEntry("repurposed_structures:mansion_desert", "MANSION", 4, 14, 12, 10), new MobMapTrades.VillagerTradeEntry("repurposed_structures:mansion_jungle", "MANSION", 4, 14, 12, 10), new MobMapTrades.VillagerTradeEntry("repurposed_structures:mansion_oak", "MANSION", 4, 14, 12, 10), new MobMapTrades.VillagerTradeEntry("repurposed_structures:mansion_savanna", "MANSION", 4, 14, 12, 10), new MobMapTrades.VillagerTradeEntry("repurposed_structures:mansion_snowy", "MANSION", 4, 14, 12, 10), new MobMapTrades.VillagerTradeEntry("repurposed_structures:mansion_taiga", "MANSION", 4, 14, 12, 10)));
        }
    };
    @Comment(value="\n\n\n\n\n\n\n// Adds structure maps to Wandering Trader's trades.\n// There is only two trade types for Wandering Trader and that's RARE and COMMON.\n// Disabling a structure will not automatically remove the structure from the trades (The explorer map to the structure becomes an empty map).")
    public final Map<String, List<MobMapTrades.WandingTraderTradeEntry>> wanderingTraderMapTrades = new HashMap<String, List<MobMapTrades.WandingTraderTradeEntry>>(){
        {
            this.put("RARE", Arrays.asList(new MobMapTrades.WandingTraderTradeEntry("repurposed_structures:bastion_underground", "BANNER_GRAY", 38, 1, 100), new MobMapTrades.WandingTraderTradeEntry("repurposed_structures:village_mushroom", "MANSION", 38, 1, 100), new MobMapTrades.WandingTraderTradeEntry("repurposed_structures:city_overworld", "MANSION", 38, 1, 200)));
        }
    };
    @Comment(value="\n\n\n\n\n\n\n// for internal use only. Do not change this.")
    public int configVersion = 1;

    @Override
    public String getName() {
        return "repurposed_structures-forge/map_trade_configs";
    }

    @Override
    public String getExtension() {
        return "json5";
    }

    @Override
    public void save() {
        if (this.configVersion == 1) {
            this.removeEntries(this.villagerMapTrades, "minecraft:cartographer", "repurposed_structures:mansion_savannna");
            this.addEntries(this.villagerMapTrades, "minecraft:cartographer", new MobMapTrades.VillagerTradeEntry("repurposed_structures:mansion_savanna", "MANSION", 4, 14, 12, 10));
        }
        this.configVersion = 2;
        Config.super.save();
    }

    private void addEntries(Map<String, List<MobMapTrades.VillagerTradeEntry>> map, String key, MobMapTrades.VillagerTradeEntry entry) {
        if (!map.containsKey(key) || map.get(key).stream().noneMatch(e -> e.structure.equals(entry.structure))) {
            ArrayList<MobMapTrades.VillagerTradeEntry> newList = new ArrayList<MobMapTrades.VillagerTradeEntry>();
            newList.add(entry);
            if (map.containsKey(key)) {
                newList.addAll((Collection)map.get(key));
            }
            map.put(key, newList);
        }
    }

    private void removeEntries(Map<String, List<MobMapTrades.VillagerTradeEntry>> map, String key, String entry) {
        if (map.containsKey(key)) {
            ArrayList<MobMapTrades.VillagerTradeEntry> newList = new ArrayList<MobMapTrades.VillagerTradeEntry>((Collection)map.get(key));
            newList.removeIf(listEntry -> listEntry.structure.equals(entry));
            map.put(key, newList);
        }
    }
}

