/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.misc;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.repurposedstructures.RepurposedStructures;
import com.telepathicgrunt.repurposedstructures.misc.JSONConditionsRegistry;
import com.telepathicgrunt.repurposedstructures.mixin.structures.ListPoolElementAccessor;
import com.telepathicgrunt.repurposedstructures.mixin.structures.SinglePoolElementAccessor;
import com.telepathicgrunt.repurposedstructures.mixin.structures.StructureManagerAccessor;
import com.telepathicgrunt.repurposedstructures.mixin.structures.StructurePoolAccessor;
import com.telepathicgrunt.repurposedstructures.utils.GeneralUtils;
import com.telepathicgrunt.repurposedstructures.utils.SafeDecodingRegistryOps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.WritableRegistry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.level.levelgen.feature.structures.ListPoolElement;
import net.minecraft.world.level.levelgen.feature.structures.SinglePoolElement;
import net.minecraft.world.level.levelgen.feature.structures.StructurePoolElement;
import net.minecraft.world.level.levelgen.feature.structures.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;
import net.minecraftforge.event.server.ServerAboutToStartEvent;

public final class PoolAdditionMerger {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().setLenient().disableHtmlEscaping().create();
    private static final String DATA_TYPE = "pool_additions";
    private static final int FILE_SUFFIX_LENGTH = ".json".length();

    private PoolAdditionMerger() {
    }

    public static void mergeAdditionPools(ServerAboutToStartEvent event) {
        ResourceManager resourceManager = ((StructureManagerAccessor)event.getServer().m_129909_()).repurposedstructures_getResourceManager();
        Map<ResourceLocation, List<JsonElement>> poolAdditionJSON = GeneralUtils.getAllDatapacksJSONElement(resourceManager, GSON, DATA_TYPE, FILE_SUFFIX_LENGTH);
        PoolAdditionMerger.parsePoolsAndBeginMerger(poolAdditionJSON, event.getServer().m_177941_(), event.getServer().m_129911_(), event.getServer().m_129909_());
    }

    private static void parsePoolsAndBeginMerger(Map<ResourceLocation, List<JsonElement>> poolAdditionJSON, ResourceManager resourceManager, RegistryAccess dynamicRegistryManager, StructureManager structureManager) {
        WritableRegistry poolRegistry = dynamicRegistryManager.m_175512_(Registry.f_122884_);
        SafeDecodingRegistryOps customRegistryOps = new SafeDecodingRegistryOps(JsonOps.INSTANCE, resourceManager, dynamicRegistryManager);
        for (Map.Entry<ResourceLocation, List<JsonElement>> entry : poolAdditionJSON.entrySet()) {
            if (poolRegistry.m_7745_(entry.getKey()) == null) continue;
            for (JsonElement jsonElement : entry.getValue()) {
                try {
                    AdditionalStructureTemplatePool.DIRECT_CODEC.parse(customRegistryOps, (Object)jsonElement).resultOrPartial(messageString -> PoolAdditionMerger.logBadData((ResourceLocation)entry.getKey(), messageString)).ifPresent(validPool -> PoolAdditionMerger.mergeIntoExistingPool(validPool, (StructureTemplatePool)poolRegistry.m_7745_((ResourceLocation)entry.getKey()), structureManager));
                }
                catch (Exception e) {
                    RepurposedStructures.LOGGER.error("\nRepurposed Structures: Pool Addition json failed to be parsed.\nThis is usually due to using a mod compat datapack without the other mod being on.\nEntry failed to be resolved: %s\nRegistry being used: %s\nError message is: %s".formatted(entry.getKey(), poolRegistry, e.getMessage()).indent(1));
                }
            }
        }
    }

    private static void mergeIntoExistingPool(AdditionalStructureTemplatePool feedingPool, StructureTemplatePool gluttonyPool, StructureManager structureManager) {
        ArrayList<StructurePoolElement> elements = new ArrayList<StructurePoolElement>(((StructurePoolAccessor)gluttonyPool).repurposedstructures_getTemplates());
        ArrayList<Pair<StructurePoolElement, Integer>> elementCounts = new ArrayList<Pair<StructurePoolElement, Integer>>(((StructurePoolAccessor)gluttonyPool).repurposedstructures_getRawTemplates());
        elements.addAll(((StructurePoolAccessor)((Object)feedingPool)).repurposedstructures_getTemplates());
        elementCounts.addAll(((StructurePoolAccessor)((Object)feedingPool)).repurposedstructures_getRawTemplates());
        for (StructurePoolElement element : elements) {
            if (element instanceof SinglePoolElement) {
                Optional structureTemplate;
                SinglePoolElement singlePoolElement = (SinglePoolElement)element;
                Optional nbtID = ((SinglePoolElementAccessor)singlePoolElement).repurposedstructures_getTemplate().left();
                if (nbtID.isEmpty() || !(structureTemplate = structureManager.m_163774_((ResourceLocation)nbtID.get())).isEmpty()) continue;
                RepurposedStructures.LOGGER.error("(Repurposed Structures POOL MERGER) Found an entry in {} that points to the non-existent nbt file called {}", (Object)feedingPool.m_69275_(), nbtID.get());
                continue;
            }
            if (!(element instanceof ListPoolElement)) continue;
            ListPoolElement listPoolElement = (ListPoolElement)element;
            for (StructurePoolElement listElement : ((ListPoolElementAccessor)listPoolElement).repurposedstructures_getElements()) {
                Optional structureTemplate;
                SinglePoolElement singlePoolElement;
                Optional nbtID;
                if (!(listElement instanceof SinglePoolElement) || (nbtID = ((SinglePoolElementAccessor)(singlePoolElement = (SinglePoolElement)listElement)).repurposedstructures_getTemplate().left()).isEmpty() || !(structureTemplate = structureManager.m_163774_((ResourceLocation)nbtID.get())).isEmpty()) continue;
                RepurposedStructures.LOGGER.error("(Repurposed Structures POOL MERGER) Found an entry in {} that points to the non-existent nbt file called {}", (Object)feedingPool.m_69275_(), nbtID.get());
            }
        }
        ((StructurePoolAccessor)gluttonyPool).repurposedstructures_setTemplates(elements);
        ((StructurePoolAccessor)gluttonyPool).repurposedstructures_setRawTemplates(elementCounts);
    }

    private static void logBadData(ResourceLocation poolPath, String messageString) {
        RepurposedStructures.LOGGER.error("(Repurposed Structures POOL MERGER) Failed to parse {} additions file. Error is: {}", (Object)poolPath, (Object)messageString);
    }

    private static class AdditionalStructureTemplatePool
    extends StructureTemplatePool {
        private static final Codec<ExpandedPoolEntry> EXPANDED_POOL_ENTRY_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)StructurePoolElement.f_69153_.fieldOf("element").forGetter(ExpandedPoolEntry::poolElement), (App)Codec.intRange((int)1, (int)5000).fieldOf("weight").forGetter(ExpandedPoolEntry::weight), (App)ResourceLocation.f_135803_.optionalFieldOf("condition").forGetter(ExpandedPoolEntry::condition)).apply((Applicative)instance, ExpandedPoolEntry::new));
        public static final Codec<AdditionalStructureTemplatePool> DIRECT_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.f_135803_.fieldOf("name").forGetter(StructureTemplatePool::m_69275_), (App)ResourceLocation.f_135803_.fieldOf("fallback").forGetter(StructureTemplatePool::m_69263_), (App)EXPANDED_POOL_ENTRY_CODEC.listOf().fieldOf("elements").forGetter(structureTemplatePool -> structureTemplatePool.rawTemplatesWithConditions)).apply((Applicative)instance, AdditionalStructureTemplatePool::new));
        protected final List<ExpandedPoolEntry> rawTemplatesWithConditions;

        public AdditionalStructureTemplatePool(ResourceLocation resourceLocation, ResourceLocation resourceLocation2, List<ExpandedPoolEntry> rawTemplatesWithConditions) {
            super(resourceLocation, resourceLocation2, rawTemplatesWithConditions.stream().filter(triple -> {
                if (triple.condition().isPresent()) {
                    Optional optionalSupplier = JSONConditionsRegistry.RS_JSON_CONDITIONS_REGISTRY.m_6612_(triple.condition.get());
                    if (optionalSupplier.isPresent()) {
                        return (Boolean)((Supplier)optionalSupplier.get()).get();
                    }
                    RepurposedStructures.LOGGER.error("Error: Found " + resourceLocation + " entry has a condition that does not exist.");
                }
                return true;
            }).map(triple -> Pair.of((Object)triple.poolElement(), (Object)triple.weight())).collect(Collectors.toList()));
            this.rawTemplatesWithConditions = rawTemplatesWithConditions;
        }

        public record ExpandedPoolEntry(StructurePoolElement poolElement, Integer weight, Optional<ResourceLocation> condition) {
        }
    }
}

