/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.misc;

import com.mojang.datafixers.util.Pair;
import com.telepathicgrunt.repurposedstructures.RepurposedStructures;
import java.util.ArrayList;
import java.util.Comparator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.FeatureAccess;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.StructureFeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.registries.RegistryObject;

public final class StructureSpacingDebugging {
    private StructureSpacingDebugging() {
    }

    public static <C extends FeatureConfiguration> void registerStructureDebugging(RegistryObject<StructureFeature<C>> structure) {
        MinecraftForge.EVENT_BUS.addListener(event -> {
            if (!event.getWorld().m_5776_() && event.getHand() == InteractionHand.MAIN_HAND) {
                RepurposedStructures.LOGGER.info("Started search");
                ServerLevel serverWorld = (ServerLevel)event.getWorld();
                ChunkGenerator chunkGenerator = serverWorld.m_7726_().m_8481_();
                StructureFeature structureToFind = (StructureFeature)structure.get();
                StructureFeatureConfiguration structureseparationsettings = chunkGenerator.m_62205_().m_64593_(structureToFind);
                ArrayList<Pair> structureStarts = new ArrayList<Pair>();
                int spacing = structureseparationsettings.m_68171_();
                int startX = 0;
                int startZ = 0;
                int maxRadius = 20;
                block0: for (int currentRadius = 0; currentRadius <= maxRadius; ++currentRadius) {
                    for (int xRadius = -currentRadius; xRadius <= currentRadius; ++xRadius) {
                        boolean onXEdge = xRadius == -currentRadius || xRadius == currentRadius;
                        for (int zRadius = -currentRadius; zRadius <= currentRadius; ++zRadius) {
                            boolean onZEdge;
                            boolean bl = onZEdge = zRadius == -currentRadius || zRadius == currentRadius;
                            if (onXEdge || onZEdge) {
                                int k1 = startX + spacing * xRadius;
                                int l1 = startZ + spacing * zRadius;
                                ChunkPos chunkpos = structureToFind.m_191122_(structureseparationsettings, serverWorld.m_7328_(), k1, l1);
                                ChunkAccess chunk = serverWorld.m_46819_(chunkpos.f_45578_, chunkpos.f_45579_, ChunkStatus.f_62315_);
                                StructureStart structurestart = serverWorld.m_8595_().m_47297_(SectionPos.m_123196_((ChunkPos)chunk.m_7697_(), (int)0), structureToFind, (FeatureAccess)chunk);
                                if (structurestart != null && structurestart.m_73603_()) {
                                    BlockPos pos = structurestart.m_163625_().m_45615_();
                                    double x = pos.m_123341_();
                                    double z = pos.m_123343_();
                                    structureStarts.add(Pair.of((Object)pos, (Object)Math.floor(Math.sqrt(x * x + z * z))));
                                }
                                if (currentRadius != 0) continue;
                                break;
                            }
                            zRadius = currentRadius - 1;
                        }
                        if (currentRadius == 0) continue block0;
                    }
                }
                structureStarts.sort(Comparator.comparingDouble(Pair::getSecond));
                structureStarts.forEach(pair -> RepurposedStructures.LOGGER.info("position: {} - distance: {}", pair.getFirst(), pair.getSecond()));
                boolean bl = true;
            }
        });
    }
}

