/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.mixin.features;

import com.telepathicgrunt.repurposedstructures.RepurposedStructures;
import com.telepathicgrunt.repurposedstructures.modinit.RSStructureTagMap;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.levelgen.feature.BasaltColumnsFeature;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BasaltColumnsFeature.class})
public class NoBasaltColumnsInStructuresMixin {
    @Inject(method={"canPlaceAt(Lnet/minecraft/world/level/LevelAccessor;ILnet/minecraft/core/BlockPos$MutableBlockPos;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private static void repurposedstructures_noBasaltColumnsInStructures(LevelAccessor levelAccessor, int seaLevel, BlockPos.MutableBlockPos mutableBlockPos, CallbackInfoReturnable<Boolean> cir) {
        SectionPos sectionPos = SectionPos.m_123199_((BlockPos)mutableBlockPos);
        if (!levelAccessor.m_6325_(sectionPos.m_123170_(), sectionPos.m_123222_()).m_6415_().m_62427_(ChunkStatus.f_62316_)) {
            RepurposedStructures.LOGGER.warn("Repurposed Structures: Detected a mod with a broken basalt columns configuredfeature that is trying to place blocks outside the 3x3 safe chunk area for features. Find the broken mod and report to them to fix the placement of their basalt columns feature.");
            return;
        }
        for (StructureFeature<?> structure : RSStructureTagMap.REVERSED_TAGGED_STRUCTURES.get((Object)RSStructureTagMap.STRUCTURE_TAGS.NO_DELTAS)) {
            List structureStarts = ((WorldGenLevel)levelAccessor).m_183409_(sectionPos, structure);
            boolean checkCenterOnly = RSStructureTagMap.TAGGED_STRUCTURES.get(structure).contains((Object)RSStructureTagMap.STRUCTURE_TAGS.DELTA_CHECK_CENTER_PIECE);
            if (structureStarts.isEmpty() || !(checkCenterOnly ? structureStarts.stream().anyMatch(structureStart -> ((StructurePiece)structureStart.m_73602_().get(0)).m_73547_().m_71051_((Vec3i)mutableBlockPos)) : structureStarts.stream().anyMatch(structureStart -> structureStart.m_73602_().stream().anyMatch(box -> box.m_73547_().m_71051_((Vec3i)mutableBlockPos))))) continue;
            cir.setReturnValue((Object)false);
            break;
        }
    }
}

