/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.processors;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.repurposedstructures.modinit.RSProcessors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class FloodWithWaterProcessor
extends StructureProcessor {
    public static final Codec<FloodWithWaterProcessor> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("flood_level").forGetter(config -> config.floodLevel)).apply((Applicative)instance, instance.stable(FloodWithWaterProcessor::new)));
    private final int floodLevel;

    private FloodWithWaterProcessor(int floodLevel) {
        this.floodLevel = floodLevel;
    }

    public StructureTemplate.StructureBlockInfo m_7382_(LevelReader levelReader, BlockPos pos, BlockPos blockPos, StructureTemplate.StructureBlockInfo structureBlockInfoLocal, StructureTemplate.StructureBlockInfo structureBlockInfoWorld, StructurePlaceSettings structurePlacementData) {
        WorldGenRegion worldGenRegion;
        if (structureBlockInfoWorld.f_74676_.m_60819_().m_76153_((Tag)FluidTags.f_13131_)) {
            this.tickWaterFluid(levelReader, structureBlockInfoWorld);
            return structureBlockInfoWorld;
        }
        if (levelReader instanceof WorldGenRegion && !(worldGenRegion = (WorldGenRegion)levelReader).m_143488_().equals((Object)new ChunkPos(structureBlockInfoWorld.f_74675_))) {
            return structureBlockInfoWorld;
        }
        if (structureBlockInfoWorld.f_74675_.m_123342_() <= this.floodLevel) {
            boolean flooded = false;
            if (structureBlockInfoWorld.f_74676_.m_60795_()) {
                structureBlockInfoWorld = new StructureTemplate.StructureBlockInfo(structureBlockInfoWorld.f_74675_, Blocks.f_49990_.m_49966_(), null);
                this.tickWaterFluid(levelReader, structureBlockInfoWorld);
                flooded = true;
            } else if (structureBlockInfoWorld.f_74676_.m_61138_((Property)BlockStateProperties.f_61362_)) {
                structureBlockInfoWorld = new StructureTemplate.StructureBlockInfo(structureBlockInfoWorld.f_74675_, (BlockState)structureBlockInfoWorld.f_74676_.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(true)), structureBlockInfoWorld.f_74677_);
                this.tickWaterFluid(levelReader, structureBlockInfoWorld);
                flooded = true;
            } else if (structureBlockInfoWorld.f_74676_.m_60734_() instanceof BushBlock) {
                structureBlockInfoWorld = new StructureTemplate.StructureBlockInfo(structureBlockInfoWorld.f_74675_, Blocks.f_49990_.m_49966_(), null);
                this.tickWaterFluid(levelReader, structureBlockInfoWorld);
                flooded = true;
            }
            if (flooded) {
                ChunkPos currentChunkPos = new ChunkPos(structureBlockInfoWorld.f_74675_);
                ChunkAccess currentChunk = levelReader.m_6325_(currentChunkPos.f_45578_, currentChunkPos.f_45579_);
                BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
                for (Direction direction : Direction.values()) {
                    BlockState neighboringBlock;
                    if (direction == Direction.UP) continue;
                    mutable.m_122190_((Vec3i)structureBlockInfoWorld.f_74675_).m_122173_(direction);
                    if (currentChunkPos.f_45578_ != mutable.m_123341_() >> 4 || currentChunkPos.f_45579_ != mutable.m_123343_() >> 4) {
                        currentChunk = levelReader.m_46865_((BlockPos)mutable);
                        currentChunkPos = new ChunkPos((BlockPos)mutable);
                    }
                    if ((neighboringBlock = currentChunk.m_8055_((BlockPos)mutable)).m_60815_() || !neighboringBlock.m_60819_().m_76178_()) continue;
                    currentChunk.m_6978_((BlockPos)mutable, Blocks.f_50224_.m_49966_(), false);
                }
            }
        }
        return structureBlockInfoWorld;
    }

    private void tickWaterFluid(LevelReader worldView, StructureTemplate.StructureBlockInfo structureBlockInfoWorld) {
        ((LevelAccessor)worldView).m_186469_(structureBlockInfoWorld.f_74675_, (Fluid)Fluids.f_76193_, 1);
    }

    protected StructureProcessorType<?> m_6953_() {
        return RSProcessors.FLOOD_WITH_WATER_PROCESSOR;
    }
}

