/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.structures;

import com.telepathicgrunt.repurposedstructures.utils.GeneralUtils;
import com.telepathicgrunt.repurposedstructures.utils.Mutable;
import com.telepathicgrunt.repurposedstructures.world.structures.AbstractBaseStructure;
import com.telepathicgrunt.repurposedstructures.world.structures.codeconfigs.BuriableStructureCodeConfig;
import com.telepathicgrunt.repurposedstructures.world.structures.pieces.PieceLimitedJigsawManager;
import java.util.Optional;
import java.util.Random;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.feature.configurations.JigsawConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.structures.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class BuriableStructure
extends AbstractBaseStructure<NoneFeatureConfiguration> {
    public BuriableStructure(Predicate<PieceGeneratorSupplier.Context<NoneFeatureConfiguration>> locationCheckPredicate, Function<PieceGeneratorSupplier.Context<NoneFeatureConfiguration>, Optional<PieceGenerator<NoneFeatureConfiguration>>> pieceCreationPredicate) {
        super(NoneFeatureConfiguration.f_67815_, locationCheckPredicate, pieceCreationPredicate);
    }

    public static BuriableStructure create(BuriableStructureCodeConfig buriableStructureCodeConfig) {
        Mutable<BuriableStructure> box = new Mutable<BuriableStructure>();
        BuriableStructure finalInstance = new BuriableStructure(context -> ((BuriableStructure)((Object)((Object)box.getValue()))).isFeatureChunk((PieceGeneratorSupplier.Context<NoneFeatureConfiguration>)context, buriableStructureCodeConfig), context -> ((BuriableStructure)((Object)((Object)box.getValue()))).generatePieces((PieceGeneratorSupplier.Context<NoneFeatureConfiguration>)context, buriableStructureCodeConfig));
        box.setValue(finalInstance);
        return finalInstance;
    }

    protected boolean isFeatureChunk(PieceGeneratorSupplier.Context<NoneFeatureConfiguration> context, BuriableStructureCodeConfig config) {
        if (config.cannotSpawnInWater) {
            BlockPos cornerOfSpawnChunk = context.f_197355_().m_45615_();
            int landHeight = context.f_197352_().m_156179_(cornerOfSpawnChunk.m_123341_(), cornerOfSpawnChunk.m_123343_(), Heightmap.Types.WORLD_SURFACE_WG, context.f_197357_());
            NoiseColumn columnOfBlocks = context.f_197352_().m_141914_(cornerOfSpawnChunk.m_123341_(), cornerOfSpawnChunk.m_123343_(), context.f_197357_());
            BlockState topBlock = columnOfBlocks.m_183556_(cornerOfSpawnChunk.m_123342_() + landHeight);
            return topBlock.m_60819_().m_76178_();
        }
        return true;
    }

    public Optional<PieceGenerator<NoneFeatureConfiguration>> generatePieces(PieceGeneratorSupplier.Context<NoneFeatureConfiguration> context, BuriableStructureCodeConfig config) {
        BlockPos blockpos = new BlockPos(context.f_197355_().m_45604_(), context.f_197352_().m_6337_(), context.f_197355_().m_45605_());
        ResourceLocation structureID = ForgeRegistries.STRUCTURE_FEATURES.getKey((IForgeRegistryEntry)this);
        return PieceLimitedJigsawManager.assembleJigsawStructure(context, new JigsawConfiguration(() -> (StructureTemplatePool)context.f_197360_().m_175515_(Registry.f_122884_).m_7745_(config.startPool), 11), structureID, blockpos, false, false, Integer.MAX_VALUE, Integer.MIN_VALUE, (structurePiecesBuilder, pieces) -> {
            GeneralUtils.centerAllPieces(blockpos, pieces);
            Heightmap.Types heightMapToUse = config.onLand ? Heightmap.Types.WORLD_SURFACE_WG : Heightmap.Types.OCEAN_FLOOR_WG;
            BoundingBox box = ((PoolElementStructurePiece)pieces.get(0)).m_73547_();
            int highestLandPos = context.f_197352_().m_142647_(box.m_162395_(), box.m_162398_(), heightMapToUse, context.f_197357_());
            highestLandPos = Math.min(highestLandPos, context.f_197352_().m_142647_(box.m_162395_(), box.m_162401_(), heightMapToUse, context.f_197357_()));
            highestLandPos = Math.min(highestLandPos, context.f_197352_().m_142647_(box.m_162399_(), box.m_162398_(), heightMapToUse, context.f_197357_()));
            highestLandPos = Math.min(highestLandPos, context.f_197352_().m_142647_(box.m_162399_(), box.m_162401_(), heightMapToUse, context.f_197357_()));
            if (!config.onLand) {
                int maxHeightForSubmerging = context.f_197352_().m_6337_() - box.m_71057_();
                highestLandPos = Math.min(highestLandPos, maxHeightForSubmerging);
            }
            WorldgenRandom random = new WorldgenRandom((RandomSource)new LegacyRandomSource(0L));
            random.m_190068_(context.f_197354_(), context.f_197355_().f_45578_, context.f_197355_().f_45579_);
            structurePiecesBuilder.m_192792_((Random)random, highestLandPos - (config.offsetAmount + 1), highestLandPos - config.offsetAmount);
        });
    }
}

