/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.structures;

import com.telepathicgrunt.repurposedstructures.utils.GeneralUtils;
import com.telepathicgrunt.repurposedstructures.utils.Mutable;
import com.telepathicgrunt.repurposedstructures.world.structures.GenericJigsawStructure;
import com.telepathicgrunt.repurposedstructures.world.structures.codeconfigs.GenericJigsawStructureCodeConfig;
import com.telepathicgrunt.repurposedstructures.world.structures.pieces.PieceLimitedJigsawManager;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.JigsawConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.structures.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class CityNetherStructure
extends GenericJigsawStructure {
    public CityNetherStructure(Predicate<PieceGeneratorSupplier.Context<NoneFeatureConfiguration>> locationCheckPredicate, Function<PieceGeneratorSupplier.Context<NoneFeatureConfiguration>, Optional<PieceGenerator<NoneFeatureConfiguration>>> pieceCreationPredicate) {
        super(locationCheckPredicate, pieceCreationPredicate);
    }

    public static CityNetherStructure create(GenericJigsawStructureCodeConfig genericJigsawStructureCodeConfig) {
        Mutable<CityNetherStructure> box = new Mutable<CityNetherStructure>();
        CityNetherStructure finalInstance = new CityNetherStructure(context -> ((CityNetherStructure)((Object)((Object)box.getValue()))).isFeatureChunk((PieceGeneratorSupplier.Context<NoneFeatureConfiguration>)context, genericJigsawStructureCodeConfig), context -> ((CityNetherStructure)((Object)((Object)box.getValue()))).generatePieces((PieceGeneratorSupplier.Context<NoneFeatureConfiguration>)context, genericJigsawStructureCodeConfig));
        box.setValue(finalInstance);
        return finalInstance;
    }

    @Override
    protected boolean isFeatureChunk(PieceGeneratorSupplier.Context<NoneFeatureConfiguration> context, GenericJigsawStructureCodeConfig config) {
        ChunkPos chunkPos = context.f_197355_();
        if (super.isFeatureChunk(context, config)) {
            BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
            for (int curChunkX = chunkPos.f_45578_ - 1; curChunkX <= chunkPos.f_45578_ + 1; ++curChunkX) {
                for (int curChunkZ = chunkPos.f_45579_ - 1; curChunkZ <= chunkPos.f_45579_ + 1; ++curChunkZ) {
                    mutable.m_122178_(curChunkX << 4, context.f_197352_().m_6337_() + 10, curChunkZ << 4);
                    NoiseColumn blockView = context.f_197352_().m_141914_(mutable.m_123341_(), mutable.m_123343_(), context.f_197357_());
                    int minValidSpace = 65;
                    int maxHeight = Math.min(GeneralUtils.getMaxTerrainLimit(context.f_197352_()), context.f_197352_().m_6337_() + minValidSpace);
                    while (mutable.m_123342_() < maxHeight) {
                        BlockState state = blockView.m_183556_(mutable.m_123342_());
                        if (!state.m_60795_()) {
                            return false;
                        }
                        mutable.m_122173_(Direction.UP);
                    }
                }
            }
        } else {
            return false;
        }
        return true;
    }

    @Override
    public Optional<PieceGenerator<NoneFeatureConfiguration>> generatePieces(PieceGeneratorSupplier.Context<NoneFeatureConfiguration> context, GenericJigsawStructureCodeConfig config) {
        BlockPos blockpos = new BlockPos(context.f_197355_().m_45604_(), context.f_197352_().m_6337_(), context.f_197355_().m_45605_());
        ResourceLocation structureID = ForgeRegistries.STRUCTURE_FEATURES.getKey((IForgeRegistryEntry)this);
        return PieceLimitedJigsawManager.assembleJigsawStructure(context, new JigsawConfiguration(() -> (StructureTemplatePool)context.f_197360_().m_175515_(Registry.f_122884_).m_7745_(config.startPool), ((Integer)config.structureSize.get()).intValue()), structureID, blockpos, false, false, Integer.MAX_VALUE, Integer.MIN_VALUE, (structurePiecesBuilder, pieces) -> ((PoolElementStructurePiece)pieces.get(0)).m_6324_(0, config.centerOffset, 0));
    }
}

