/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.structures;

import com.telepathicgrunt.repurposedstructures.modinit.RSStructureTagMap;
import com.telepathicgrunt.repurposedstructures.utils.GeneralUtils;
import com.telepathicgrunt.repurposedstructures.utils.Mutable;
import com.telepathicgrunt.repurposedstructures.world.structures.AbstractBaseStructure;
import com.telepathicgrunt.repurposedstructures.world.structures.codeconfigs.GenericJigsawStructureCodeConfig;
import com.telepathicgrunt.repurposedstructures.world.structures.pieces.PieceLimitedJigsawManager;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.CheckerboardColumnBiomeSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.JigsawConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.StructureFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.structures.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class GenericJigsawStructure
extends AbstractBaseStructure<NoneFeatureConfiguration> {
    public GenericJigsawStructure(Predicate<PieceGeneratorSupplier.Context<NoneFeatureConfiguration>> locationCheckPredicate, Function<PieceGeneratorSupplier.Context<NoneFeatureConfiguration>, Optional<PieceGenerator<NoneFeatureConfiguration>>> pieceCreationPredicate) {
        super(NoneFeatureConfiguration.f_67815_, locationCheckPredicate, pieceCreationPredicate);
    }

    public static GenericJigsawStructure create(GenericJigsawStructureCodeConfig genericJigsawStructureCodeConfig) {
        Mutable<GenericJigsawStructure> box = new Mutable<GenericJigsawStructure>();
        GenericJigsawStructure finalInstance = new GenericJigsawStructure(context -> ((GenericJigsawStructure)((Object)((Object)box.getValue()))).isFeatureChunk((PieceGeneratorSupplier.Context<NoneFeatureConfiguration>)context, genericJigsawStructureCodeConfig), context -> ((GenericJigsawStructure)((Object)((Object)box.getValue()))).generatePieces((PieceGeneratorSupplier.Context<NoneFeatureConfiguration>)context, genericJigsawStructureCodeConfig));
        box.setValue(finalInstance);
        return finalInstance;
    }

    protected boolean isFeatureChunk(PieceGeneratorSupplier.Context<NoneFeatureConfiguration> context, GenericJigsawStructureCodeConfig config) {
        int curChunkZ;
        int curChunkX;
        ChunkPos chunkPos = context.f_197355_();
        if (!(context.f_197353_() instanceof CheckerboardColumnBiomeSource)) {
            for (curChunkX = chunkPos.f_45578_ - config.biomeRange; curChunkX <= chunkPos.f_45578_ + config.biomeRange; ++curChunkX) {
                for (curChunkZ = chunkPos.f_45579_ - config.biomeRange; curChunkZ <= chunkPos.f_45579_ + config.biomeRange; ++curChunkZ) {
                    int yValue = config.useHeightmap ? config.fixedYSpawn + context.f_197352_().m_156174_(curChunkX << 4, curChunkZ << 4, Heightmap.Types.WORLD_SURFACE_WG, context.f_197357_()) : config.fixedYSpawn;
                    Biome biome = context.f_197353_().m_183546_(curChunkX << 2, yValue >> 2, curChunkZ << 2, context.f_197352_().m_183403_());
                    if (context.f_197358_().test(biome)) continue;
                    return false;
                }
            }
        }
        for (curChunkX = chunkPos.f_45578_ - config.structureBlacklistRange; curChunkX <= chunkPos.f_45578_ + config.structureBlacklistRange; ++curChunkX) {
            for (curChunkZ = chunkPos.f_45579_ - config.structureBlacklistRange; curChunkZ <= chunkPos.f_45579_ + config.structureBlacklistRange; ++curChunkZ) {
                for (RSStructureTagMap.STRUCTURE_TAGS tag : config.avoidStructuresSet) {
                    for (StructureFeature<?> structureFeature : RSStructureTagMap.REVERSED_TAGGED_STRUCTURES.get((Object)tag)) {
                        StructureFeatureConfiguration structureConfig;
                        if (structureFeature == this || (structureConfig = context.f_197352_().m_62205_().m_64593_(structureFeature)) == null || structureConfig.m_68171_() <= 8) continue;
                        ChunkPos chunkPos2 = structureFeature.m_191122_(structureConfig, context.f_197354_(), curChunkX, curChunkZ);
                        if (curChunkX != chunkPos2.f_45578_ || curChunkZ != chunkPos2.f_45579_) continue;
                        return false;
                    }
                }
            }
        }
        if (config.allowTerrainHeightRange != -1) {
            int maxTerrainHeight = Integer.MIN_VALUE;
            int minTerrainHeight = Integer.MAX_VALUE;
            for (int curChunkX2 = chunkPos.f_45578_ - config.terrainHeightRadius; curChunkX2 <= chunkPos.f_45578_ + config.terrainHeightRadius; ++curChunkX2) {
                for (int curChunkZ2 = chunkPos.f_45579_ - config.terrainHeightRadius; curChunkZ2 <= chunkPos.f_45579_ + config.terrainHeightRadius; ++curChunkZ2) {
                    int height = context.f_197352_().m_142647_((curChunkX2 << 4) + 7, (curChunkZ2 << 4) + 7, Heightmap.Types.WORLD_SURFACE_WG, context.f_197357_());
                    maxTerrainHeight = Math.max(maxTerrainHeight, height);
                    if ((minTerrainHeight = Math.min(minTerrainHeight, height)) >= config.minHeightLimit) continue;
                    return false;
                }
            }
            if (maxTerrainHeight - minTerrainHeight > config.allowTerrainHeightRange) {
                return false;
            }
        }
        if (config.cannotSpawnInWater) {
            BlockPos centerOfChunk = chunkPos.m_151394_(0);
            int landHeight = context.f_197352_().m_156179_(centerOfChunk.m_123341_(), centerOfChunk.m_123343_(), Heightmap.Types.WORLD_SURFACE_WG, context.f_197357_());
            NoiseColumn columnOfBlocks = context.f_197352_().m_141914_(centerOfChunk.m_123341_(), centerOfChunk.m_123343_(), context.f_197357_());
            BlockState topBlock = columnOfBlocks.m_183556_(centerOfChunk.m_123342_() + landHeight);
            if (!topBlock.m_60819_().m_76178_()) {
                return false;
            }
        }
        return true;
    }

    public Optional<PieceGenerator<NoneFeatureConfiguration>> generatePieces(PieceGeneratorSupplier.Context<NoneFeatureConfiguration> context, GenericJigsawStructureCodeConfig config) {
        BlockPos blockpos = new BlockPos(context.f_197355_().m_45604_(), config.fixedYSpawn, context.f_197355_().m_45605_());
        ResourceLocation structureID = ForgeRegistries.STRUCTURE_FEATURES.getKey((IForgeRegistryEntry)this);
        return PieceLimitedJigsawManager.assembleJigsawStructure(context, new JigsawConfiguration(() -> (StructureTemplatePool)context.f_197360_().m_175515_(Registry.f_122884_).m_7745_(config.startPool), ((Integer)config.structureSize.get()).intValue()), structureID, blockpos, config.useHeightmap, config.useHeightmap, Integer.MAX_VALUE, Integer.MIN_VALUE, config.poolsThatIgnoreBounds, (structurePiecesBuilder, pieces) -> {
            GeneralUtils.centerAllPieces(blockpos, pieces);
            ((PoolElementStructurePiece)pieces.get(0)).m_6324_(0, config.centerOffset, 0);
        });
    }
}

