/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.structures;

import com.telepathicgrunt.repurposedstructures.utils.GeneralUtils;
import com.telepathicgrunt.repurposedstructures.utils.Mutable;
import com.telepathicgrunt.repurposedstructures.world.structures.GenericJigsawStructure;
import com.telepathicgrunt.repurposedstructures.world.structures.codeconfigs.GenericNetherJigsawStructureCodeConfig;
import com.telepathicgrunt.repurposedstructures.world.structures.pieces.PieceLimitedJigsawManager;
import java.util.Optional;
import java.util.Random;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.feature.configurations.JigsawConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.structures.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class GenericNetherJigsawStructure
extends GenericJigsawStructure {
    public GenericNetherJigsawStructure(Predicate<PieceGeneratorSupplier.Context<NoneFeatureConfiguration>> locationCheckPredicate, Function<PieceGeneratorSupplier.Context<NoneFeatureConfiguration>, Optional<PieceGenerator<NoneFeatureConfiguration>>> pieceCreationPredicate) {
        super(locationCheckPredicate, pieceCreationPredicate);
    }

    public static GenericNetherJigsawStructure create(GenericNetherJigsawStructureCodeConfig genericNetherJigsawStructureCodeConfig) {
        Mutable<GenericNetherJigsawStructure> box = new Mutable<GenericNetherJigsawStructure>();
        GenericNetherJigsawStructure finalInstance = new GenericNetherJigsawStructure(context -> ((GenericNetherJigsawStructure)((Object)((Object)box.getValue()))).isFeatureChunk((PieceGeneratorSupplier.Context<NoneFeatureConfiguration>)context, genericNetherJigsawStructureCodeConfig), context -> ((GenericNetherJigsawStructure)((Object)((Object)box.getValue()))).generatePieces((PieceGeneratorSupplier.Context<NoneFeatureConfiguration>)context, genericNetherJigsawStructureCodeConfig));
        box.setValue(finalInstance);
        return finalInstance;
    }

    protected Optional<PieceGenerator<NoneFeatureConfiguration>> generatePieces(PieceGeneratorSupplier.Context<NoneFeatureConfiguration> context, GenericNetherJigsawStructureCodeConfig config) {
        BlockPos blockpos = new BlockPos(context.f_197355_().m_45604_(), config.fixedYSpawn, context.f_197355_().m_45605_());
        ResourceLocation structureID = ForgeRegistries.STRUCTURE_FEATURES.getKey((IForgeRegistryEntry)this);
        return PieceLimitedJigsawManager.assembleJigsawStructure(context, new JigsawConfiguration(() -> (StructureTemplatePool)context.f_197360_().m_175515_(Registry.f_122884_).m_7745_(config.startPool), ((Integer)config.structureSize.get()).intValue()), structureID, blockpos, config.useHeightmap, config.useHeightmap, Integer.MAX_VALUE, Integer.MIN_VALUE, (structurePiecesBuilder, pieces) -> {
            GeneralUtils.centerAllPieces(blockpos, pieces);
            ((PoolElementStructurePiece)pieces.get(0)).m_6324_(0, config.centerOffset, 0);
            WorldgenRandom random = new WorldgenRandom((RandomSource)new LegacyRandomSource(0L));
            random.m_190068_(context.f_197354_(), context.f_197355_().f_45578_, context.f_197355_().f_45579_);
            BlockPos placementPos = config.highestLandSearch ? GeneralUtils.getHighestLand(context.f_197352_(), structurePiecesBuilder.m_192798_(), context.f_197357_(), config.canPlaceOnLiquid) : GeneralUtils.getLowestLand(context.f_197352_(), structurePiecesBuilder.m_192798_(), context.f_197357_(), config.canPlaceOnLiquid);
            if (placementPos.m_123342_() >= GeneralUtils.getMaxTerrainLimit(context.f_197352_()) || placementPos.m_123342_() <= context.f_197352_().m_6337_() + 1) {
                structurePiecesBuilder.m_192792_((Random)random, context.f_197352_().m_6337_() + config.ledgeSpotOffset, context.f_197352_().m_6337_() + (config.ledgeSpotOffset + 1));
            } else {
                structurePiecesBuilder.m_192792_((Random)random, placementPos.m_123342_() + config.liquidSpotOffset, placementPos.m_123342_() + (config.liquidSpotOffset + 1));
            }
        });
    }
}

