/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.structures;

import com.telepathicgrunt.repurposedstructures.configs.RSMansionsConfig;
import com.telepathicgrunt.repurposedstructures.utils.GeneralUtils;
import com.telepathicgrunt.repurposedstructures.utils.Mutable;
import com.telepathicgrunt.repurposedstructures.world.structures.AbstractBaseStructure;
import com.telepathicgrunt.repurposedstructures.world.structures.codeconfigs.MansionCodeConfig;
import com.telepathicgrunt.repurposedstructures.world.structures.pieces.MansionPieces;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Random;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.CheckerboardColumnBiomeSource;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.PostPlacementProcessor;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import net.minecraft.world.level.levelgen.structure.pieces.PiecesContainer;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;

public class MansionStructure
extends AbstractBaseStructure<NoneFeatureConfiguration> {
    public MansionStructure(Predicate<PieceGeneratorSupplier.Context<NoneFeatureConfiguration>> locationCheckPredicate, Function<PieceGeneratorSupplier.Context<NoneFeatureConfiguration>, Optional<PieceGenerator<NoneFeatureConfiguration>>> pieceCreationPredicate, PostPlacementProcessor postPlacementProcessor) {
        super(NoneFeatureConfiguration.f_67815_, locationCheckPredicate, pieceCreationPredicate, postPlacementProcessor);
    }

    public static MansionStructure create(MansionCodeConfig mansionCodeConfig) {
        Mutable<MansionStructure> box = new Mutable<MansionStructure>();
        MansionStructure finalInstance = new MansionStructure(context -> ((MansionStructure)((Object)((Object)box.getValue()))).isFeatureChunk((PieceGeneratorSupplier.Context<NoneFeatureConfiguration>)context, mansionCodeConfig), context -> ((MansionStructure)((Object)((Object)box.getValue()))).generatePieces((PieceGeneratorSupplier.Context<NoneFeatureConfiguration>)context, mansionCodeConfig), (w, sfm, cg, r, bb, c, pc) -> ((MansionStructure)((Object)((Object)box.getValue()))).afterPlace(w, sfm, cg, r, bb, c, pc, mansionCodeConfig));
        box.setValue(finalInstance);
        return finalInstance;
    }

    protected boolean m_5910_() {
        return false;
    }

    protected boolean isFeatureChunk(PieceGeneratorSupplier.Context<NoneFeatureConfiguration> context, MansionCodeConfig config) {
        ChunkPos chunkPos = context.f_197355_();
        if (!(context.f_197353_() instanceof CheckerboardColumnBiomeSource)) {
            int biomeRange = 2;
            for (int curChunkX = chunkPos.f_45578_ - biomeRange; curChunkX <= chunkPos.f_45578_ + biomeRange; ++curChunkX) {
                for (int curChunkZ = chunkPos.f_45579_ - biomeRange; curChunkZ <= chunkPos.f_45579_ + biomeRange; ++curChunkZ) {
                    int yValue = context.f_197352_().m_156174_(curChunkX << 4, curChunkZ << 4, Heightmap.Types.WORLD_SURFACE_WG, context.f_197357_());
                    Biome biome = context.f_197353_().m_183546_(curChunkX << 2, yValue >> 2, curChunkZ << 2, context.f_197352_().m_183403_());
                    if (context.f_197358_().test(biome)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public Optional<PieceGenerator<NoneFeatureConfiguration>> generatePieces(PieceGeneratorSupplier.Context<NoneFeatureConfiguration> context, MansionCodeConfig config) {
        ChunkPos chunkPos = context.f_197355_();
        WorldgenRandom random = new WorldgenRandom((RandomSource)new LegacyRandomSource(0L));
        random.m_190068_(context.f_197354_(), context.f_197355_().f_45578_, context.f_197355_().f_45579_);
        Rotation blockRotation = Rotation.m_55956_((Random)random);
        int xOffset = 5;
        int zOffset = 5;
        if (blockRotation == Rotation.CLOCKWISE_90) {
            xOffset = -5;
        } else if (blockRotation == Rotation.CLOCKWISE_180) {
            xOffset = -5;
            zOffset = -5;
        } else if (blockRotation == Rotation.COUNTERCLOCKWISE_90) {
            zOffset = -5;
        }
        int centerX = chunkPos.m_151390_();
        int centerZ = chunkPos.m_151393_();
        int firstHeight = context.f_197352_().m_156179_(centerX, centerZ, Heightmap.Types.WORLD_SURFACE_WG, context.f_197357_());
        int secondHeight = context.f_197352_().m_156179_(centerX, centerZ + zOffset, Heightmap.Types.WORLD_SURFACE_WG, context.f_197357_());
        int thirdHeight = context.f_197352_().m_156179_(centerX + xOffset, centerZ, Heightmap.Types.WORLD_SURFACE_WG, context.f_197357_());
        int forthheight = context.f_197352_().m_156179_(centerX + xOffset, centerZ + zOffset, Heightmap.Types.WORLD_SURFACE_WG, context.f_197357_());
        int finalheight = Math.min(Math.min(firstHeight, secondHeight), Math.min(thirdHeight, forthheight));
        if (finalheight <= context.f_197352_().m_142062_()) {
            return Optional.empty();
        }
        return Optional.of((structurePiecesBuilder, contextx) -> {
            BlockPos blockPos = new BlockPos(chunkPos.m_151390_(), finalheight + 1, chunkPos.m_151393_());
            ArrayList<StructurePiece> list = new ArrayList<StructurePiece>();
            MansionPieces.createMansionLayout(context.f_197360_(), context.f_197359_(), blockPos, blockRotation, list, (Random)random, config.type);
            list.forEach(arg_0 -> ((StructurePiecesBuilder)structurePiecesBuilder).m_142679_(arg_0));
        });
    }

    private void afterPlace(WorldGenLevel world, StructureFeatureManager structureFeatureManager, ChunkGenerator chunkGenerator, Random random, BoundingBox boundingBox, ChunkPos chunkPos, PiecesContainer piecesContainer, MansionCodeConfig config) {
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        BoundingBox box = piecesContainer.m_192756_();
        int structureBottomY = box.m_162396_();
        int terrainY = Integer.MIN_VALUE;
        for (int x = box.m_162395_(); x <= box.m_162399_(); ++x) {
            for (int z = box.m_162398_(); z <= box.m_162401_(); ++z) {
                BlockPos blockPos2;
                mutableBlockPos.m_122178_(x, structureBottomY, z);
                if (((Boolean)RSMansionsConfig.pillarOnlyToLand.get()).booleanValue() && (terrainY = GeneralUtils.getFirstLandYFromPos((LevelReader)world, mutableBlockPos.m_7495_())) <= chunkGenerator.m_142062_() || world.m_46859_((BlockPos)mutableBlockPos) || !box.m_71051_((Vec3i)mutableBlockPos) || !piecesContainer.m_192751_((BlockPos)mutableBlockPos)) continue;
                for (int currentY = structureBottomY - 1; !(currentY <= chunkGenerator.m_142062_() || ((Boolean)RSMansionsConfig.pillarOnlyToLand.get()).booleanValue() && currentY <= terrainY || !world.m_46859_(blockPos2 = new BlockPos(x, currentY, z)) && !world.m_8055_(blockPos2).m_60767_().m_76332_()); --currentY) {
                    world.m_7731_(blockPos2, config.type.getFoundationBlock(), 2);
                }
            }
        }
    }
}

