/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.structures.pieces;

import com.google.common.collect.Lists;
import com.telepathicgrunt.repurposedstructures.RepurposedStructures;
import com.telepathicgrunt.repurposedstructures.world.structures.pieces.MirroringSingleJigsawPiece;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.WritableRegistry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.structures.SinglePoolElement;
import net.minecraft.world.level.levelgen.feature.structures.StructurePoolElement;
import net.minecraft.world.level.levelgen.feature.structures.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class MansionPieces {
    public static void createMansionLayout(RegistryAccess dynamicRegistryManager, StructureManager manager, BlockPos pos, Rotation rotation, List<StructurePiece> pieces, Random random, MANSIONTYPE type) {
        MansionParameters mansionParameters = new MansionParameters(random);
        LayoutGenerator layoutGenerator = new LayoutGenerator(manager, random);
        layoutGenerator.generate(dynamicRegistryManager, pos, rotation, pieces, mansionParameters, type);
    }

    static class MansionParameters {
        private final Random random;
        private final FlagMatrix field_15440;
        private final FlagMatrix field_15439;
        private final FlagMatrix[] field_15443;
        private final int field_15442;
        private final int field_15441;

        public MansionParameters(Random random) {
            this.random = random;
            this.field_15442 = 7;
            this.field_15441 = 4;
            this.field_15440 = new FlagMatrix(11, 11, 5);
            this.field_15440.fill(this.field_15442, this.field_15441, this.field_15442 + 1, this.field_15441 + 1, 3);
            this.field_15440.fill(this.field_15442 - 1, this.field_15441, this.field_15442 - 1, this.field_15441 + 1, 2);
            this.field_15440.fill(this.field_15442 + 2, this.field_15441 - 2, this.field_15442 + 3, this.field_15441 + 3, 5);
            this.field_15440.fill(this.field_15442 + 1, this.field_15441 - 2, this.field_15442 + 1, this.field_15441 - 1, 1);
            this.field_15440.fill(this.field_15442 + 1, this.field_15441 + 2, this.field_15442 + 1, this.field_15441 + 3, 1);
            this.field_15440.set(this.field_15442 - 1, this.field_15441 - 1, 1);
            this.field_15440.set(this.field_15442 - 1, this.field_15441 + 2, 1);
            this.field_15440.fill(0, 0, 11, 1, 5);
            this.field_15440.fill(0, 9, 11, 11, 5);
            this.method_15045(this.field_15440, this.field_15442, this.field_15441 - 2, Direction.WEST, 6);
            this.method_15045(this.field_15440, this.field_15442, this.field_15441 + 3, Direction.WEST, 6);
            this.method_15045(this.field_15440, this.field_15442 - 2, this.field_15441 - 1, Direction.WEST, 3);
            this.method_15045(this.field_15440, this.field_15442 - 2, this.field_15441 + 2, Direction.WEST, 3);
            while (this.method_15046(this.field_15440)) {
            }
            this.field_15443 = new FlagMatrix[3];
            this.field_15443[0] = new FlagMatrix(11, 11, 5);
            this.field_15443[1] = new FlagMatrix(11, 11, 5);
            this.field_15443[2] = new FlagMatrix(11, 11, 5);
            this.method_15042(this.field_15440, this.field_15443[0]);
            this.method_15042(this.field_15440, this.field_15443[1]);
            this.field_15443[0].fill(this.field_15442 + 1, this.field_15441, this.field_15442 + 1, this.field_15441 + 1, 0x800000);
            this.field_15443[1].fill(this.field_15442 + 1, this.field_15441, this.field_15442 + 1, this.field_15441 + 1, 0x800000);
            this.field_15439 = new FlagMatrix(this.field_15440.n, this.field_15440.m, 5);
            this.method_15048();
            this.method_15042(this.field_15439, this.field_15443[2]);
        }

        public static boolean method_15047(FlagMatrix flagMatrix, int i, int j) {
            int k = flagMatrix.get(i, j);
            return k == 1 || k == 2 || k == 3 || k == 4;
        }

        public boolean method_15039(FlagMatrix flagMatrix, int i, int j, int k, int l) {
            return (this.field_15443[k].get(i, j) & 0xFFFF) == l;
        }

        public Direction method_15040(FlagMatrix flagMatrix, int i, int j, int k, int l) {
            Direction direction;
            Iterator var6 = Direction.Plane.HORIZONTAL.iterator();
            do {
                if (var6.hasNext()) continue;
                return null;
            } while (!this.method_15039(flagMatrix, i + (direction = (Direction)var6.next()).m_122429_(), j + direction.m_122431_(), k, l));
            return direction;
        }

        private void method_15045(FlagMatrix flagMatrix, int i, int j, Direction direction, int k) {
            if (k > 0) {
                Direction direction2;
                flagMatrix.set(i, j, 1);
                flagMatrix.update(i + direction.m_122429_(), j + direction.m_122431_(), 0, 1);
                for (int l = 0; l < 8; ++l) {
                    direction2 = Direction.m_122407_((int)this.random.nextInt(4));
                    if (direction2 == direction.m_122424_() || direction2 == Direction.EAST && this.random.nextBoolean()) continue;
                    int m = i + direction.m_122429_();
                    int n = j + direction.m_122431_();
                    if (flagMatrix.get(m + direction2.m_122429_(), n + direction2.m_122431_()) != 0 || flagMatrix.get(m + direction2.m_122429_() * 2, n + direction2.m_122431_() * 2) != 0) continue;
                    this.method_15045(flagMatrix, i + direction.m_122429_() + direction2.m_122429_(), j + direction.m_122431_() + direction2.m_122431_(), direction2, k - 1);
                    break;
                }
                Direction direction3 = direction.m_122427_();
                direction2 = direction.m_122428_();
                flagMatrix.update(i + direction3.m_122429_(), j + direction3.m_122431_(), 0, 2);
                flagMatrix.update(i + direction2.m_122429_(), j + direction2.m_122431_(), 0, 2);
                flagMatrix.update(i + direction.m_122429_() + direction3.m_122429_(), j + direction.m_122431_() + direction3.m_122431_(), 0, 2);
                flagMatrix.update(i + direction.m_122429_() + direction2.m_122429_(), j + direction.m_122431_() + direction2.m_122431_(), 0, 2);
                flagMatrix.update(i + direction.m_122429_() * 2, j + direction.m_122431_() * 2, 0, 2);
                flagMatrix.update(i + direction3.m_122429_() * 2, j + direction3.m_122431_() * 2, 0, 2);
                flagMatrix.update(i + direction2.m_122429_() * 2, j + direction2.m_122431_() * 2, 0, 2);
            }
        }

        private boolean method_15046(FlagMatrix flagMatrix) {
            boolean bl = false;
            for (int i = 0; i < flagMatrix.m; ++i) {
                for (int j = 0; j < flagMatrix.n; ++j) {
                    if (flagMatrix.get(j, i) != 0) continue;
                    int k = MansionParameters.method_15047(flagMatrix, j + 1, i) ? 1 : 0;
                    k += MansionParameters.method_15047(flagMatrix, j - 1, i) ? 1 : 0;
                    k += MansionParameters.method_15047(flagMatrix, j, i + 1) ? 1 : 0;
                    if ((k += MansionParameters.method_15047(flagMatrix, j, i - 1) ? 1 : 0) >= 3) {
                        flagMatrix.set(j, i, 2);
                        bl = true;
                        continue;
                    }
                    if (k != 2) continue;
                    int l = MansionParameters.method_15047(flagMatrix, j + 1, i + 1) ? 1 : 0;
                    l += MansionParameters.method_15047(flagMatrix, j - 1, i + 1) ? 1 : 0;
                    l += MansionParameters.method_15047(flagMatrix, j + 1, i - 1) ? 1 : 0;
                    if ((l += MansionParameters.method_15047(flagMatrix, j - 1, i - 1) ? 1 : 0) > 1) continue;
                    flagMatrix.set(j, i, 2);
                    bl = true;
                }
            }
            return bl;
        }

        private void method_15048() {
            int n;
            int m;
            ArrayList list = Lists.newArrayList();
            FlagMatrix flagMatrix = this.field_15443[1];
            for (int i = 0; i < this.field_15439.m; ++i) {
                for (m = 0; m < this.field_15439.n; ++m) {
                    int k = flagMatrix.get(m, i);
                    n = k & 0xF0000;
                    if (n != 131072 || (k & 0x200000) != 0x200000) continue;
                    list.add(new Tuple((Object)m, (Object)i));
                }
            }
            if (list.isEmpty()) {
                this.field_15439.fill(0, 0, this.field_15439.n, this.field_15439.m, 5);
            } else {
                Tuple pair = (Tuple)list.get(this.random.nextInt(list.size()));
                m = flagMatrix.get((Integer)pair.m_14418_(), (Integer)pair.m_14419_());
                flagMatrix.set((Integer)pair.m_14418_(), (Integer)pair.m_14419_(), m | 0x400000);
                Direction direction = this.method_15040(this.field_15440, (Integer)pair.m_14418_(), (Integer)pair.m_14419_(), 1, m & 0xFFFF);
                n = (Integer)pair.m_14418_() + direction.m_122429_();
                int o = (Integer)pair.m_14419_() + direction.m_122431_();
                for (int p = 0; p < this.field_15439.m; ++p) {
                    for (int q = 0; q < this.field_15439.n; ++q) {
                        if (!MansionParameters.method_15047(this.field_15440, q, p)) {
                            this.field_15439.set(q, p, 5);
                            continue;
                        }
                        if (q == (Integer)pair.m_14418_() && p == (Integer)pair.m_14419_()) {
                            this.field_15439.set(q, p, 3);
                            continue;
                        }
                        if (q != n || p != o) continue;
                        this.field_15439.set(q, p, 3);
                        this.field_15443[2].set(q, p, 0x800000);
                    }
                }
                ArrayList list2 = Lists.newArrayList();
                for (Direction direction2 : Direction.Plane.HORIZONTAL) {
                    if (this.field_15439.get(n + direction2.m_122429_(), o + direction2.m_122431_()) != 0) continue;
                    list2.add(direction2);
                }
                if (list2.isEmpty()) {
                    this.field_15439.fill(0, 0, this.field_15439.n, this.field_15439.m, 5);
                    flagMatrix.set((Integer)pair.m_14418_(), (Integer)pair.m_14419_(), m);
                } else {
                    Direction direction3 = (Direction)list2.get(this.random.nextInt(list2.size()));
                    this.method_15045(this.field_15439, n + direction3.m_122429_(), o + direction3.m_122431_(), direction3, 4);
                    while (this.method_15046(this.field_15439)) {
                    }
                }
            }
        }

        private void method_15042(FlagMatrix flagMatrix, FlagMatrix flagMatrix2) {
            int k;
            ArrayList list = Lists.newArrayList();
            for (k = 0; k < flagMatrix.m; ++k) {
                for (int j = 0; j < flagMatrix.n; ++j) {
                    if (flagMatrix.get(j, k) != 2) continue;
                    list.add(new Tuple((Object)j, (Object)k));
                }
            }
            Collections.shuffle(list, this.random);
            k = 10;
            Iterator var19 = list.iterator();
            while (var19.hasNext()) {
                int m;
                Tuple pair = (Tuple)var19.next();
                int l = (Integer)pair.m_14418_();
                if (flagMatrix2.get(l, m = ((Integer)pair.m_14419_()).intValue()) != 0) continue;
                int n = l;
                int o = l;
                int p = m;
                int q = m;
                int r = 65536;
                if (flagMatrix2.get(l + 1, m) == 0 && flagMatrix2.get(l, m + 1) == 0 && flagMatrix2.get(l + 1, m + 1) == 0 && flagMatrix.get(l + 1, m) == 2 && flagMatrix.get(l, m + 1) == 2 && flagMatrix.get(l + 1, m + 1) == 2) {
                    o = l + 1;
                    q = m + 1;
                    r = 262144;
                } else if (flagMatrix2.get(l - 1, m) == 0 && flagMatrix2.get(l, m + 1) == 0 && flagMatrix2.get(l - 1, m + 1) == 0 && flagMatrix.get(l - 1, m) == 2 && flagMatrix.get(l, m + 1) == 2 && flagMatrix.get(l - 1, m + 1) == 2) {
                    n = l - 1;
                    q = m + 1;
                    r = 262144;
                } else if (flagMatrix2.get(l - 1, m) == 0 && flagMatrix2.get(l, m - 1) == 0 && flagMatrix2.get(l - 1, m - 1) == 0 && flagMatrix.get(l - 1, m) == 2 && flagMatrix.get(l, m - 1) == 2 && flagMatrix.get(l - 1, m - 1) == 2) {
                    n = l - 1;
                    p = m - 1;
                    r = 262144;
                } else if (flagMatrix2.get(l + 1, m) == 0 && flagMatrix.get(l + 1, m) == 2) {
                    o = l + 1;
                    r = 131072;
                } else if (flagMatrix2.get(l, m + 1) == 0 && flagMatrix.get(l, m + 1) == 2) {
                    q = m + 1;
                    r = 131072;
                } else if (flagMatrix2.get(l - 1, m) == 0 && flagMatrix.get(l - 1, m) == 2) {
                    n = l - 1;
                    r = 131072;
                } else if (flagMatrix2.get(l, m - 1) == 0 && flagMatrix.get(l, m - 1) == 2) {
                    p = m - 1;
                    r = 131072;
                }
                int s = this.random.nextBoolean() ? n : o;
                int t = this.random.nextBoolean() ? p : q;
                int u = 0x200000;
                if (!flagMatrix.anyMatchAround(s, t, 1)) {
                    s = s == n ? o : n;
                    int n2 = t = t == p ? q : p;
                    if (!flagMatrix.anyMatchAround(s, t, 1)) {
                        int n3 = t = t == p ? q : p;
                        if (!flagMatrix.anyMatchAround(s, t, 1)) {
                            s = s == n ? o : n;
                            int n4 = t = t == p ? q : p;
                            if (!flagMatrix.anyMatchAround(s, t, 1)) {
                                u = 0;
                                s = n;
                                t = p;
                            }
                        }
                    }
                }
                for (int v = p; v <= q; ++v) {
                    for (int w = n; w <= o; ++w) {
                        if (w == s && v == t) {
                            flagMatrix2.set(w, v, 0x100000 | u | r | k);
                            continue;
                        }
                        flagMatrix2.set(w, v, r | k);
                    }
                }
                ++k;
            }
            return;
        }
    }

    static class LayoutGenerator {
        private final StructureManager manager;
        private final Random random;
        private int field_15446;
        private int field_15445;

        public LayoutGenerator(StructureManager manager, Random random) {
            this.manager = manager;
            this.random = random;
        }

        public void generate(RegistryAccess dynamicRegistryManager, BlockPos pos, Rotation rotation, List<StructurePiece> structurePieces, MansionParameters mansionParameters, MANSIONTYPE type) {
            int floor;
            WritableRegistry poolRegistry = dynamicRegistryManager.m_175512_(Registry.f_122884_);
            GenerationPiece generationPiece = new GenerationPiece();
            generationPiece.position = pos;
            generationPiece.rotation = rotation;
            generationPiece.template = "wall_flat";
            GenerationPiece generationPiece2 = new GenerationPiece();
            this.addEntrance((WritableRegistry<StructureTemplatePool>)poolRegistry, structurePieces, generationPiece, type);
            generationPiece2.position = generationPiece.position.m_6630_(8);
            generationPiece2.rotation = generationPiece.rotation;
            generationPiece2.template = "wall_window";
            FlagMatrix flagMatrix = mansionParameters.field_15440;
            FlagMatrix flagMatrix2 = mansionParameters.field_15439;
            this.field_15446 = mansionParameters.field_15442 + 1;
            this.field_15445 = mansionParameters.field_15441 + 1;
            int i = mansionParameters.field_15442 + 1;
            int j = mansionParameters.field_15441;
            this.addRoof((WritableRegistry<StructureTemplatePool>)poolRegistry, structurePieces, generationPiece, flagMatrix, Direction.SOUTH, this.field_15446, this.field_15445, i, j, type);
            this.addRoof((WritableRegistry<StructureTemplatePool>)poolRegistry, structurePieces, generationPiece2, flagMatrix, Direction.SOUTH, this.field_15446, this.field_15445, i, j, type);
            GenerationPiece generationPiece3 = new GenerationPiece();
            generationPiece3.position = generationPiece.position.m_6630_(19);
            generationPiece3.rotation = generationPiece.rotation;
            generationPiece3.template = "wall_window";
            boolean bl = false;
            for (int k = 0; k < flagMatrix2.m && !bl; ++k) {
                for (floor = flagMatrix2.n - 1; floor >= 0 && !bl; --floor) {
                    if (!MansionParameters.method_15047(flagMatrix2, floor, k)) continue;
                    generationPiece3.position = generationPiece3.position.m_5484_(rotation.m_55954_(Direction.SOUTH), 8 + (k - this.field_15445) * 8);
                    generationPiece3.position = generationPiece3.position.m_5484_(rotation.m_55954_(Direction.EAST), (floor - this.field_15446) * 8);
                    this.method_15052((WritableRegistry<StructureTemplatePool>)poolRegistry, structurePieces, generationPiece3, type);
                    this.addRoof((WritableRegistry<StructureTemplatePool>)poolRegistry, structurePieces, generationPiece3, flagMatrix2, Direction.SOUTH, floor, k, floor, k, type);
                    bl = true;
                }
            }
            this.method_15055((WritableRegistry<StructureTemplatePool>)poolRegistry, structurePieces, pos.m_6630_(16), rotation, flagMatrix, flagMatrix2, type);
            this.method_15055((WritableRegistry<StructureTemplatePool>)poolRegistry, structurePieces, pos.m_6630_(27), rotation, flagMatrix2, null, type);
            RoomCollection[] roomCollections = new RoomCollection[]{new FirstFloor(type), new SecondFloor(type), new ThirdFloor(type)};
            for (floor = 0; floor < 3; ++floor) {
                BlockPos blockPos = pos.m_6630_(8 * floor + (floor == 2 ? 3 : 0));
                FlagMatrix flagMatrix3 = mansionParameters.field_15443[floor];
                FlagMatrix flagMatrix4 = floor == 2 ? flagMatrix2 : flagMatrix;
                String string = floor == 0 ? "carpet_south_1" : "carpet_south_2";
                String string2 = floor == 0 ? "carpet_west_1" : "carpet_west_2";
                for (int n = 0; n < flagMatrix4.m; ++n) {
                    for (int o = 0; o < flagMatrix4.n; ++o) {
                        if (flagMatrix4.get(o, n) != 1) continue;
                        BlockPos blockPos2 = blockPos.m_5484_(rotation.m_55954_(Direction.SOUTH), 8 + (n - this.field_15445) * 8);
                        blockPos2 = blockPos2.m_5484_(rotation.m_55954_(Direction.EAST), (o - this.field_15446) * 8);
                        structurePieces.add(this.getJigsawPiece((WritableRegistry<StructureTemplatePool>)poolRegistry, "repurposed_structures:mansions/" + type + (floor == 0 ? "/corridor_floor" : "/corridor_floor_high"), blockPos2, rotation, Mirror.NONE, type));
                        if (flagMatrix4.get(o, n - 1) == 1 || (flagMatrix3.get(o, n - 1) & 0x800000) == 0x800000) {
                            structurePieces.add(this.getJigsawPiece((WritableRegistry<StructureTemplatePool>)poolRegistry, "repurposed_structures:mansions/" + type + "/carpet_north", blockPos2.m_5484_(rotation.m_55954_(Direction.EAST), 1).m_7494_(), rotation, Mirror.NONE, type));
                        }
                        if (flagMatrix4.get(o + 1, n) == 1 || (flagMatrix3.get(o + 1, n) & 0x800000) == 0x800000) {
                            structurePieces.add(this.getJigsawPiece((WritableRegistry<StructureTemplatePool>)poolRegistry, "repurposed_structures:mansions/" + type + "/carpet_east", blockPos2.m_5484_(rotation.m_55954_(Direction.SOUTH), 1).m_5484_(rotation.m_55954_(Direction.EAST), 5).m_7494_(), rotation, Mirror.NONE, type));
                        }
                        if (flagMatrix4.get(o, n + 1) == 1 || (flagMatrix3.get(o, n + 1) & 0x800000) == 0x800000) {
                            structurePieces.add(this.getJigsawPiece((WritableRegistry<StructureTemplatePool>)poolRegistry, "repurposed_structures:mansions/" + type + "/" + string, blockPos2.m_5484_(rotation.m_55954_(Direction.SOUTH), 5).m_5484_(rotation.m_55954_(Direction.WEST), 1), rotation, Mirror.NONE, type));
                        }
                        if (flagMatrix4.get(o - 1, n) != 1 && (flagMatrix3.get(o - 1, n) & 0x800000) != 0x800000) continue;
                        structurePieces.add(this.getJigsawPiece((WritableRegistry<StructureTemplatePool>)poolRegistry, "repurposed_structures:mansions/" + type + "/" + string2, blockPos2.m_5484_(rotation.m_55954_(Direction.WEST), 1).m_5484_(rotation.m_55954_(Direction.NORTH), 1), rotation, Mirror.NONE, type));
                    }
                }
                String string3 = floor == 0 ? "indoors_wall_1" : "indoors_wall_2";
                String string4 = floor == 0 ? "indoors_door_1" : "indoors_door_2";
                ArrayList list = Lists.newArrayList();
                for (int p = 0; p < flagMatrix4.m; ++p) {
                    for (int q = 0; q < flagMatrix4.n; ++q) {
                        Direction direction4;
                        BlockPos blockPos6;
                        boolean bl2;
                        boolean bl3 = bl2 = floor == 2 && flagMatrix4.get(q, p) == 3;
                        if (flagMatrix4.get(q, p) != 2 && !bl2) continue;
                        int r = flagMatrix3.get(q, p);
                        int s = r & 0xF0000;
                        int t = r & 0xFFFF;
                        bl2 = bl2 && (r & 0x800000) == 0x800000;
                        list.clear();
                        if ((r & 0x200000) == 0x200000) {
                            for (Direction direction : Direction.Plane.HORIZONTAL) {
                                if (flagMatrix4.get(q + direction.m_122429_(), p + direction.m_122431_()) != 1) continue;
                                list.add(direction);
                            }
                        }
                        Direction direction2 = null;
                        if (!list.isEmpty()) {
                            direction2 = (Direction)list.get(this.random.nextInt(list.size()));
                        } else if ((r & 0x100000) == 0x100000) {
                            direction2 = Direction.UP;
                        }
                        BlockPos blockPos3 = blockPos.m_5484_(rotation.m_55954_(Direction.SOUTH), 8 + (p - this.field_15445) * 8);
                        blockPos3 = blockPos3.m_5484_(rotation.m_55954_(Direction.EAST), -1 + (q - this.field_15446) * 8);
                        if (MansionParameters.method_15047(flagMatrix4, q - 1, p) && !mansionParameters.method_15039(flagMatrix4, q - 1, p, floor, t)) {
                            structurePieces.add(this.getJigsawPiece((WritableRegistry<StructureTemplatePool>)poolRegistry, "repurposed_structures:mansions/" + type + "/" + (direction2 == Direction.WEST ? string4 : string3), blockPos3, rotation, Mirror.NONE, type));
                        }
                        if (flagMatrix4.get(q + 1, p) == 1 && !bl2) {
                            blockPos6 = blockPos3.m_5484_(rotation.m_55954_(Direction.EAST), 8);
                            structurePieces.add(this.getJigsawPiece((WritableRegistry<StructureTemplatePool>)poolRegistry, "repurposed_structures:mansions/" + type + "/" + (direction2 == Direction.EAST ? string4 : string3), blockPos6, rotation, Mirror.NONE, type));
                        }
                        if (MansionParameters.method_15047(flagMatrix4, q, p + 1) && !mansionParameters.method_15039(flagMatrix4, q, p + 1, floor, t)) {
                            blockPos6 = blockPos3.m_5484_(rotation.m_55954_(Direction.SOUTH), 7);
                            blockPos6 = blockPos6.m_5484_(rotation.m_55954_(Direction.EAST), 7);
                            structurePieces.add(this.getJigsawPiece((WritableRegistry<StructureTemplatePool>)poolRegistry, "repurposed_structures:mansions/" + type + "/" + (direction2 == Direction.SOUTH ? string4 : string3), blockPos6, rotation.m_55952_(Rotation.CLOCKWISE_90), Mirror.NONE, type));
                        }
                        if (flagMatrix4.get(q, p - 1) == 1 && !bl2) {
                            blockPos6 = blockPos3.m_5484_(rotation.m_55954_(Direction.NORTH), 1);
                            blockPos6 = blockPos6.m_5484_(rotation.m_55954_(Direction.EAST), 7);
                            structurePieces.add(this.getJigsawPiece((WritableRegistry<StructureTemplatePool>)poolRegistry, "repurposed_structures:mansions/" + type + "/" + (direction2 == Direction.NORTH ? string4 : string3), blockPos6, rotation.m_55952_(Rotation.CLOCKWISE_90), Mirror.NONE, type));
                        }
                        if (s == 65536) {
                            this.addSmallRoom((WritableRegistry<StructureTemplatePool>)poolRegistry, structurePieces, blockPos3, rotation, direction2, roomCollections[floor], type);
                            continue;
                        }
                        if (s == 131072 && direction2 != null) {
                            direction4 = mansionParameters.method_15040(flagMatrix4, q, p, floor, t);
                            boolean bl32 = (r & 0x400000) == 0x400000;
                            this.addMediumRoom((WritableRegistry<StructureTemplatePool>)poolRegistry, structurePieces, blockPos3, rotation, direction4, direction2, roomCollections[floor], bl32, type);
                            continue;
                        }
                        if (s == 262144 && direction2 != null && direction2 != Direction.UP) {
                            direction4 = direction2.m_122427_();
                            if (!mansionParameters.method_15039(flagMatrix4, q + direction4.m_122429_(), p + direction4.m_122431_(), floor, t)) {
                                direction4 = direction4.m_122424_();
                            }
                            this.addBigRoom((WritableRegistry<StructureTemplatePool>)poolRegistry, structurePieces, blockPos3, rotation, direction4, direction2, roomCollections[floor], type);
                            continue;
                        }
                        if (s != 262144 || direction2 != Direction.UP) continue;
                        this.addBigSecretRoom((WritableRegistry<StructureTemplatePool>)poolRegistry, structurePieces, blockPos3, rotation, roomCollections[floor], type);
                    }
                }
            }
        }

        private void addRoof(WritableRegistry<StructureTemplatePool> poolRegistry, List<StructurePiece> list, GenerationPiece generationPiece, FlagMatrix flagMatrix, Direction direction, int i, int j, int k, int l, MANSIONTYPE type) {
            int m = i;
            int n = j;
            Direction direction2 = direction;
            do {
                if (!MansionParameters.method_15047(flagMatrix, m + direction.m_122429_(), n + direction.m_122431_())) {
                    this.method_15058(poolRegistry, list, generationPiece, type);
                    direction = direction.m_122427_();
                    if (m == k && n == l && direction2 == direction) continue;
                    this.method_15052(poolRegistry, list, generationPiece, type);
                    continue;
                }
                if (MansionParameters.method_15047(flagMatrix, m + direction.m_122429_(), n + direction.m_122431_()) && MansionParameters.method_15047(flagMatrix, m + direction.m_122429_() + direction.m_122428_().m_122429_(), n + direction.m_122431_() + direction.m_122428_().m_122431_())) {
                    this.method_15060(generationPiece);
                    m += direction.m_122429_();
                    n += direction.m_122431_();
                    direction = direction.m_122428_();
                    continue;
                }
                if ((m += direction.m_122429_()) == k && (n += direction.m_122431_()) == l && direction2 == direction) continue;
                this.method_15052(poolRegistry, list, generationPiece, type);
            } while (m != k || n != l || direction2 != direction);
        }

        private void method_15055(WritableRegistry<StructureTemplatePool> poolRegistry, List<StructurePiece> structurePieces, BlockPos blockPos, Rotation rotation, FlagMatrix flagMatrix, FlagMatrix flagMatrix2, MANSIONTYPE type) {
            BlockPos blockPos15;
            boolean bl3;
            BlockPos blockPos7;
            int l;
            int k;
            for (k = 0; k < flagMatrix.m; ++k) {
                for (l = 0; l < flagMatrix.n; ++l) {
                    blockPos7 = blockPos.m_5484_(rotation.m_55954_(Direction.SOUTH), 8 + (k - this.field_15445) * 8);
                    blockPos7 = blockPos7.m_5484_(rotation.m_55954_(Direction.EAST), (l - this.field_15446) * 8);
                    boolean bl = bl3 = flagMatrix2 != null && MansionParameters.method_15047(flagMatrix2, l, k);
                    if (!MansionParameters.method_15047(flagMatrix, l, k) || bl3) continue;
                    structurePieces.add(this.getJigsawPiece(poolRegistry, "repurposed_structures:mansions/" + type + "/roof", blockPos7.m_6630_(3), rotation, Mirror.NONE, type));
                    if (!MansionParameters.method_15047(flagMatrix, l + 1, k)) {
                        blockPos15 = blockPos7.m_5484_(rotation.m_55954_(Direction.EAST), 6);
                        structurePieces.add(this.getJigsawPiece(poolRegistry, "repurposed_structures:mansions/" + type + "/roof_front", blockPos15, rotation, Mirror.NONE, type));
                    }
                    if (!MansionParameters.method_15047(flagMatrix, l - 1, k)) {
                        blockPos15 = blockPos7.m_5484_(rotation.m_55954_(Direction.EAST), 0);
                        blockPos15 = blockPos15.m_5484_(rotation.m_55954_(Direction.SOUTH), 7);
                        structurePieces.add(this.getJigsawPiece(poolRegistry, "repurposed_structures:mansions/" + type + "/roof_front", blockPos15, rotation.m_55952_(Rotation.CLOCKWISE_180), Mirror.NONE, type));
                    }
                    if (!MansionParameters.method_15047(flagMatrix, l, k - 1)) {
                        blockPos15 = blockPos7.m_5484_(rotation.m_55954_(Direction.WEST), 1);
                        structurePieces.add(this.getJigsawPiece(poolRegistry, "repurposed_structures:mansions/" + type + "/roof_front", blockPos15, rotation.m_55952_(Rotation.COUNTERCLOCKWISE_90), Mirror.NONE, type));
                    }
                    if (MansionParameters.method_15047(flagMatrix, l, k + 1)) continue;
                    blockPos15 = blockPos7.m_5484_(rotation.m_55954_(Direction.EAST), 6);
                    blockPos15 = blockPos15.m_5484_(rotation.m_55954_(Direction.SOUTH), 6);
                    structurePieces.add(this.getJigsawPiece(poolRegistry, "repurposed_structures:mansions/" + type + "/roof_front", blockPos15, rotation.m_55952_(Rotation.CLOCKWISE_90), Mirror.NONE, type));
                }
            }
            if (flagMatrix2 != null) {
                for (k = 0; k < flagMatrix.m; ++k) {
                    for (l = 0; l < flagMatrix.n; ++l) {
                        blockPos7 = blockPos.m_5484_(rotation.m_55954_(Direction.SOUTH), 8 + (k - this.field_15445) * 8);
                        blockPos7 = blockPos7.m_5484_(rotation.m_55954_(Direction.EAST), (l - this.field_15446) * 8);
                        bl3 = MansionParameters.method_15047(flagMatrix2, l, k);
                        if (!MansionParameters.method_15047(flagMatrix, l, k) || !bl3) continue;
                        if (!MansionParameters.method_15047(flagMatrix, l + 1, k)) {
                            blockPos15 = blockPos7.m_5484_(rotation.m_55954_(Direction.EAST), 7);
                            blockPos15 = blockPos15.m_5484_(rotation.m_55954_(Direction.NORTH), 1);
                            structurePieces.add(this.getJigsawPiece(poolRegistry, "repurposed_structures:mansions/" + type + "/small_wall", blockPos15, rotation, Mirror.NONE, type));
                        }
                        if (!MansionParameters.method_15047(flagMatrix, l - 1, k)) {
                            blockPos15 = blockPos7.m_5484_(rotation.m_55954_(Direction.WEST), 1);
                            blockPos15 = blockPos15.m_5484_(rotation.m_55954_(Direction.SOUTH), 7);
                            structurePieces.add(this.getJigsawPiece(poolRegistry, "repurposed_structures:mansions/" + type + "/small_wall", blockPos15, rotation.m_55952_(Rotation.CLOCKWISE_180), Mirror.NONE, type));
                        }
                        if (!MansionParameters.method_15047(flagMatrix, l, k - 1)) {
                            blockPos15 = blockPos7.m_5484_(rotation.m_55954_(Direction.WEST), 1);
                            blockPos15 = blockPos15.m_5484_(rotation.m_55954_(Direction.NORTH), 1);
                            structurePieces.add(this.getJigsawPiece(poolRegistry, "repurposed_structures:mansions/" + type + "/small_wall", blockPos15, rotation.m_55952_(Rotation.COUNTERCLOCKWISE_90), Mirror.NONE, type));
                        }
                        if (!MansionParameters.method_15047(flagMatrix, l, k + 1)) {
                            blockPos15 = blockPos7.m_5484_(rotation.m_55954_(Direction.EAST), 7);
                            blockPos15 = blockPos15.m_5484_(rotation.m_55954_(Direction.SOUTH), 7);
                            structurePieces.add(this.getJigsawPiece(poolRegistry, "repurposed_structures:mansions/" + type + "/small_wall", blockPos15, rotation.m_55952_(Rotation.CLOCKWISE_90), Mirror.NONE, type));
                        }
                        if (!MansionParameters.method_15047(flagMatrix, l + 1, k)) {
                            if (!MansionParameters.method_15047(flagMatrix, l, k - 1)) {
                                blockPos15 = blockPos7.m_5484_(rotation.m_55954_(Direction.EAST), 7);
                                blockPos15 = blockPos15.m_5484_(rotation.m_55954_(Direction.NORTH), 2);
                                structurePieces.add(this.getJigsawPiece(poolRegistry, "repurposed_structures:mansions/" + type + "/small_wall_corner", blockPos15, rotation, Mirror.NONE, type));
                            }
                            if (!MansionParameters.method_15047(flagMatrix, l, k + 1)) {
                                blockPos15 = blockPos7.m_5484_(rotation.m_55954_(Direction.EAST), 8);
                                blockPos15 = blockPos15.m_5484_(rotation.m_55954_(Direction.SOUTH), 7);
                                structurePieces.add(this.getJigsawPiece(poolRegistry, "repurposed_structures:mansions/" + type + "/small_wall_corner", blockPos15, rotation.m_55952_(Rotation.CLOCKWISE_90), Mirror.NONE, type));
                            }
                        }
                        if (MansionParameters.method_15047(flagMatrix, l - 1, k)) continue;
                        if (!MansionParameters.method_15047(flagMatrix, l, k - 1)) {
                            blockPos15 = blockPos7.m_5484_(rotation.m_55954_(Direction.WEST), 2);
                            blockPos15 = blockPos15.m_5484_(rotation.m_55954_(Direction.NORTH), 1);
                            structurePieces.add(this.getJigsawPiece(poolRegistry, "repurposed_structures:mansions/" + type + "/small_wall_corner", blockPos15, rotation.m_55952_(Rotation.COUNTERCLOCKWISE_90), Mirror.NONE, type));
                        }
                        if (MansionParameters.method_15047(flagMatrix, l, k + 1)) continue;
                        blockPos15 = blockPos7.m_5484_(rotation.m_55954_(Direction.WEST), 1);
                        blockPos15 = blockPos15.m_5484_(rotation.m_55954_(Direction.SOUTH), 8);
                        structurePieces.add(this.getJigsawPiece(poolRegistry, "repurposed_structures:mansions/" + type + "/small_wall_corner", blockPos15, rotation.m_55952_(Rotation.CLOCKWISE_180), Mirror.NONE, type));
                    }
                }
            }
            for (k = 0; k < flagMatrix.m; ++k) {
                for (l = 0; l < flagMatrix.n; ++l) {
                    BlockPos blockPos24;
                    blockPos7 = blockPos.m_5484_(rotation.m_55954_(Direction.SOUTH), 8 + (k - this.field_15445) * 8);
                    blockPos7 = blockPos7.m_5484_(rotation.m_55954_(Direction.EAST), (l - this.field_15446) * 8);
                    boolean bl = bl3 = flagMatrix2 != null && MansionParameters.method_15047(flagMatrix2, l, k);
                    if (!MansionParameters.method_15047(flagMatrix, l, k) || bl3) continue;
                    if (!MansionParameters.method_15047(flagMatrix, l + 1, k)) {
                        blockPos15 = blockPos7.m_5484_(rotation.m_55954_(Direction.EAST), 6);
                        if (!MansionParameters.method_15047(flagMatrix, l, k + 1)) {
                            blockPos24 = blockPos15.m_5484_(rotation.m_55954_(Direction.SOUTH), 6);
                            structurePieces.add(this.getJigsawPiece(poolRegistry, "repurposed_structures:mansions/" + type + "/roof_corner", blockPos24, rotation, Mirror.NONE, type));
                        } else if (MansionParameters.method_15047(flagMatrix, l + 1, k + 1)) {
                            blockPos24 = blockPos15.m_5484_(rotation.m_55954_(Direction.SOUTH), 5);
                            structurePieces.add(this.getJigsawPiece(poolRegistry, "repurposed_structures:mansions/" + type + "/roof_inner_corner", blockPos24, rotation, Mirror.NONE, type));
                        }
                        if (!MansionParameters.method_15047(flagMatrix, l, k - 1)) {
                            structurePieces.add(this.getJigsawPiece(poolRegistry, "repurposed_structures:mansions/" + type + "/roof_corner", blockPos15, rotation.m_55952_(Rotation.COUNTERCLOCKWISE_90), Mirror.NONE, type));
                        } else if (MansionParameters.method_15047(flagMatrix, l + 1, k - 1)) {
                            blockPos24 = blockPos7.m_5484_(rotation.m_55954_(Direction.EAST), 9);
                            blockPos24 = blockPos24.m_5484_(rotation.m_55954_(Direction.NORTH), 2);
                            structurePieces.add(this.getJigsawPiece(poolRegistry, "repurposed_structures:mansions/" + type + "/roof_inner_corner", blockPos24, rotation.m_55952_(Rotation.CLOCKWISE_90), Mirror.NONE, type));
                        }
                    }
                    if (MansionParameters.method_15047(flagMatrix, l - 1, k)) continue;
                    blockPos15 = blockPos7.m_5484_(rotation.m_55954_(Direction.EAST), 0);
                    blockPos15 = blockPos15.m_5484_(rotation.m_55954_(Direction.SOUTH), 0);
                    if (!MansionParameters.method_15047(flagMatrix, l, k + 1)) {
                        blockPos24 = blockPos15.m_5484_(rotation.m_55954_(Direction.SOUTH), 6);
                        structurePieces.add(this.getJigsawPiece(poolRegistry, "repurposed_structures:mansions/" + type + "/roof_corner", blockPos24, rotation.m_55952_(Rotation.CLOCKWISE_90), Mirror.NONE, type));
                    } else if (MansionParameters.method_15047(flagMatrix, l - 1, k + 1)) {
                        blockPos24 = blockPos15.m_5484_(rotation.m_55954_(Direction.SOUTH), 8);
                        blockPos24 = blockPos24.m_5484_(rotation.m_55954_(Direction.WEST), 3);
                        structurePieces.add(this.getJigsawPiece(poolRegistry, "repurposed_structures:mansions/" + type + "/roof_inner_corner", blockPos24, rotation.m_55952_(Rotation.COUNTERCLOCKWISE_90), Mirror.NONE, type));
                    }
                    if (!MansionParameters.method_15047(flagMatrix, l, k - 1)) {
                        structurePieces.add(this.getJigsawPiece(poolRegistry, "repurposed_structures:mansions/" + type + "/roof_corner", blockPos15, rotation.m_55952_(Rotation.CLOCKWISE_180), Mirror.NONE, type));
                        continue;
                    }
                    if (!MansionParameters.method_15047(flagMatrix, l - 1, k - 1)) continue;
                    blockPos24 = blockPos15.m_5484_(rotation.m_55954_(Direction.SOUTH), 1);
                    structurePieces.add(this.getJigsawPiece(poolRegistry, "repurposed_structures:mansions/" + type + "/roof_inner_corner", blockPos24, rotation.m_55952_(Rotation.CLOCKWISE_180), Mirror.NONE, type));
                }
            }
        }

        private void addEntrance(WritableRegistry<StructureTemplatePool> poolRegistry, List<StructurePiece> structurePieces, GenerationPiece generationPiece, MANSIONTYPE type) {
            Direction direction = generationPiece.rotation.m_55954_(Direction.WEST);
            structurePieces.add(this.getJigsawPiece(poolRegistry, "repurposed_structures:mansions/" + type + "/entrance", generationPiece.position.m_5484_(direction, 9), generationPiece.rotation, Mirror.NONE, type));
            generationPiece.position = generationPiece.position.m_5484_(generationPiece.rotation.m_55954_(Direction.SOUTH), 16);
        }

        private void method_15052(WritableRegistry<StructureTemplatePool> poolRegistry, List<StructurePiece> structurePieces, GenerationPiece generationPiece, MANSIONTYPE type) {
            structurePieces.add(this.getJigsawPiece(poolRegistry, "repurposed_structures:mansions/" + type + "/" + generationPiece.template, generationPiece.position.m_5484_(generationPiece.rotation.m_55954_(Direction.EAST), 7), generationPiece.rotation, Mirror.NONE, type));
            generationPiece.position = generationPiece.position.m_5484_(generationPiece.rotation.m_55954_(Direction.SOUTH), 8);
        }

        private void method_15058(WritableRegistry<StructureTemplatePool> poolRegistry, List<StructurePiece> structurePieces, GenerationPiece generationPiece, MANSIONTYPE type) {
            generationPiece.position = generationPiece.position.m_5484_(generationPiece.rotation.m_55954_(Direction.SOUTH), -1);
            structurePieces.add(this.getJigsawPiece(poolRegistry, "repurposed_structures:mansions/" + type + "/wall_corner", generationPiece.position, generationPiece.rotation, Mirror.NONE, type));
            generationPiece.position = generationPiece.position.m_5484_(generationPiece.rotation.m_55954_(Direction.SOUTH), -7);
            generationPiece.position = generationPiece.position.m_5484_(generationPiece.rotation.m_55954_(Direction.WEST), -6);
            generationPiece.rotation = generationPiece.rotation.m_55952_(Rotation.CLOCKWISE_90);
        }

        private void method_15060(GenerationPiece generationPiece) {
            generationPiece.position = generationPiece.position.m_5484_(generationPiece.rotation.m_55954_(Direction.SOUTH), 6);
            generationPiece.position = generationPiece.position.m_5484_(generationPiece.rotation.m_55954_(Direction.EAST), 8);
            generationPiece.rotation = generationPiece.rotation.m_55952_(Rotation.COUNTERCLOCKWISE_90);
        }

        private void addSmallRoom(WritableRegistry<StructureTemplatePool> poolRegistry, List<StructurePiece> structurePieces, BlockPos blockPos, Rotation blockRotation, Direction direction, RoomCollection roomCollection, MANSIONTYPE type) {
            Rotation blockRotation2 = Rotation.NONE;
            String string = roomCollection.get1x1(this.random);
            if (direction != Direction.EAST) {
                if (direction == Direction.NORTH) {
                    blockRotation2 = blockRotation2.m_55952_(Rotation.COUNTERCLOCKWISE_90);
                } else if (direction == Direction.WEST) {
                    blockRotation2 = blockRotation2.m_55952_(Rotation.CLOCKWISE_180);
                } else if (direction == Direction.SOUTH) {
                    blockRotation2 = blockRotation2.m_55952_(Rotation.CLOCKWISE_90);
                } else {
                    string = roomCollection.get1x1Secret(this.random);
                }
            }
            BlockPos blockPos2 = StructureTemplate.m_74587_((BlockPos)new BlockPos(1, 0, 0), (Mirror)Mirror.NONE, (Rotation)blockRotation2, (int)7, (int)7);
            blockRotation2 = blockRotation2.m_55952_(blockRotation);
            blockPos2 = blockPos2.m_7954_(blockRotation);
            BlockPos blockPos3 = blockPos.m_142082_(blockPos2.m_123341_(), 0, blockPos2.m_123343_());
            structurePieces.add(this.getJigsawPiece(poolRegistry, string, blockPos3, blockRotation2, Mirror.NONE, type));
        }

        private void addMediumRoom(WritableRegistry<StructureTemplatePool> poolRegistry, List<StructurePiece> structurePieces, BlockPos blockPos, Rotation blockRotation, Direction direction, Direction direction2, RoomCollection roomCollection, boolean staircase, MANSIONTYPE type) {
            if (direction2 == Direction.EAST && direction == Direction.SOUTH) {
                BlockPos blockPos15 = blockPos.m_5484_(blockRotation.m_55954_(Direction.EAST), 1);
                structurePieces.add(this.getJigsawPiece(poolRegistry, roomCollection.get1x2SideEntrance(this.random, staircase), blockPos15, blockRotation, Mirror.NONE, type));
            } else if (direction2 == Direction.EAST && direction == Direction.NORTH) {
                BlockPos blockPos15 = blockPos.m_5484_(blockRotation.m_55954_(Direction.EAST), 1);
                blockPos15 = blockPos15.m_5484_(blockRotation.m_55954_(Direction.SOUTH), 6);
                structurePieces.add(this.getJigsawPiece(poolRegistry, roomCollection.get1x2SideEntrance(this.random, staircase), blockPos15, blockRotation, Mirror.LEFT_RIGHT, type));
            } else if (direction2 == Direction.WEST && direction == Direction.NORTH) {
                BlockPos blockPos15 = blockPos.m_5484_(blockRotation.m_55954_(Direction.EAST), 7);
                blockPos15 = blockPos15.m_5484_(blockRotation.m_55954_(Direction.SOUTH), 6);
                structurePieces.add(this.getJigsawPiece(poolRegistry, roomCollection.get1x2SideEntrance(this.random, staircase), blockPos15, blockRotation.m_55952_(Rotation.CLOCKWISE_180), Mirror.NONE, type));
            } else if (direction2 == Direction.WEST && direction == Direction.SOUTH) {
                BlockPos blockPos15 = blockPos.m_5484_(blockRotation.m_55954_(Direction.EAST), 7);
                structurePieces.add(this.getJigsawPiece(poolRegistry, roomCollection.get1x2SideEntrance(this.random, staircase), blockPos15, blockRotation, Mirror.FRONT_BACK, type));
            } else if (direction2 == Direction.SOUTH && direction == Direction.EAST) {
                BlockPos blockPos15 = blockPos.m_5484_(blockRotation.m_55954_(Direction.EAST), 1);
                structurePieces.add(this.getJigsawPiece(poolRegistry, roomCollection.get1x2SideEntrance(this.random, staircase), blockPos15, blockRotation.m_55952_(Rotation.CLOCKWISE_90), Mirror.LEFT_RIGHT, type));
            } else if (direction2 == Direction.SOUTH && direction == Direction.WEST) {
                BlockPos blockPos15 = blockPos.m_5484_(blockRotation.m_55954_(Direction.EAST), 7);
                structurePieces.add(this.getJigsawPiece(poolRegistry, roomCollection.get1x2SideEntrance(this.random, staircase), blockPos15, blockRotation.m_55952_(Rotation.CLOCKWISE_90), Mirror.NONE, type));
            } else if (direction2 == Direction.NORTH && direction == Direction.WEST) {
                BlockPos blockPos15 = blockPos.m_5484_(blockRotation.m_55954_(Direction.EAST), 7);
                blockPos15 = blockPos15.m_5484_(blockRotation.m_55954_(Direction.SOUTH), 6);
                structurePieces.add(this.getJigsawPiece(poolRegistry, roomCollection.get1x2SideEntrance(this.random, staircase), blockPos15, blockRotation.m_55952_(Rotation.CLOCKWISE_90), Mirror.FRONT_BACK, type));
            } else if (direction2 == Direction.NORTH && direction == Direction.EAST) {
                BlockPos blockPos15 = blockPos.m_5484_(blockRotation.m_55954_(Direction.EAST), 1);
                blockPos15 = blockPos15.m_5484_(blockRotation.m_55954_(Direction.SOUTH), 6);
                structurePieces.add(this.getJigsawPiece(poolRegistry, roomCollection.get1x2SideEntrance(this.random, staircase), blockPos15, blockRotation.m_55952_(Rotation.COUNTERCLOCKWISE_90), Mirror.NONE, type));
            } else if (direction2 == Direction.SOUTH && direction == Direction.NORTH) {
                BlockPos blockPos15 = blockPos.m_5484_(blockRotation.m_55954_(Direction.EAST), 1);
                blockPos15 = blockPos15.m_5484_(blockRotation.m_55954_(Direction.NORTH), 8);
                structurePieces.add(this.getJigsawPiece(poolRegistry, roomCollection.get1x2FrontEntrance(this.random, staircase), blockPos15, blockRotation, Mirror.NONE, type));
            } else if (direction2 == Direction.NORTH && direction == Direction.SOUTH) {
                BlockPos blockPos15 = blockPos.m_5484_(blockRotation.m_55954_(Direction.EAST), 7);
                blockPos15 = blockPos15.m_5484_(blockRotation.m_55954_(Direction.SOUTH), 14);
                structurePieces.add(this.getJigsawPiece(poolRegistry, roomCollection.get1x2FrontEntrance(this.random, staircase), blockPos15, blockRotation.m_55952_(Rotation.CLOCKWISE_180), Mirror.NONE, type));
            } else if (direction2 == Direction.WEST && direction == Direction.EAST) {
                BlockPos blockPos15 = blockPos.m_5484_(blockRotation.m_55954_(Direction.EAST), 15);
                structurePieces.add(this.getJigsawPiece(poolRegistry, roomCollection.get1x2FrontEntrance(this.random, staircase), blockPos15, blockRotation.m_55952_(Rotation.CLOCKWISE_90), Mirror.NONE, type));
            } else if (direction2 == Direction.EAST && direction == Direction.WEST) {
                BlockPos blockPos15 = blockPos.m_5484_(blockRotation.m_55954_(Direction.WEST), 7);
                blockPos15 = blockPos15.m_5484_(blockRotation.m_55954_(Direction.SOUTH), 6);
                structurePieces.add(this.getJigsawPiece(poolRegistry, roomCollection.get1x2FrontEntrance(this.random, staircase), blockPos15, blockRotation.m_55952_(Rotation.COUNTERCLOCKWISE_90), Mirror.NONE, type));
            } else if (direction2 == Direction.UP && direction == Direction.EAST) {
                BlockPos blockPos15 = blockPos.m_5484_(blockRotation.m_55954_(Direction.EAST), 15);
                structurePieces.add(this.getJigsawPiece(poolRegistry, roomCollection.get1x2Secret(this.random), blockPos15, blockRotation.m_55952_(Rotation.CLOCKWISE_90), Mirror.NONE, type));
            } else if (direction2 == Direction.UP && direction == Direction.SOUTH) {
                BlockPos blockPos15 = blockPos.m_5484_(blockRotation.m_55954_(Direction.EAST), 1);
                blockPos15 = blockPos15.m_5484_(blockRotation.m_55954_(Direction.NORTH), 0);
                structurePieces.add(this.getJigsawPiece(poolRegistry, roomCollection.get1x2Secret(this.random), blockPos15, blockRotation, Mirror.NONE, type));
            }
        }

        private void addBigRoom(WritableRegistry<StructureTemplatePool> poolRegistry, List<StructurePiece> structurePieces, BlockPos blockPos, Rotation blockRotation, Direction direction, Direction direction2, RoomCollection roomCollection, MANSIONTYPE type) {
            int i = 0;
            int j = 0;
            Rotation blockRotation2 = blockRotation;
            Mirror blockMirror = Mirror.NONE;
            if (direction2 == Direction.EAST && direction == Direction.SOUTH) {
                i = -7;
            } else if (direction2 == Direction.EAST && direction == Direction.NORTH) {
                i = -7;
                j = 6;
                blockMirror = Mirror.LEFT_RIGHT;
            } else if (direction2 == Direction.NORTH && direction == Direction.EAST) {
                i = 1;
                j = 14;
                blockRotation2 = blockRotation.m_55952_(Rotation.COUNTERCLOCKWISE_90);
            } else if (direction2 == Direction.NORTH && direction == Direction.WEST) {
                i = 7;
                j = 14;
                blockRotation2 = blockRotation.m_55952_(Rotation.COUNTERCLOCKWISE_90);
                blockMirror = Mirror.LEFT_RIGHT;
            } else if (direction2 == Direction.SOUTH && direction == Direction.WEST) {
                i = 7;
                j = -8;
                blockRotation2 = blockRotation.m_55952_(Rotation.CLOCKWISE_90);
            } else if (direction2 == Direction.SOUTH && direction == Direction.EAST) {
                i = 1;
                j = -8;
                blockRotation2 = blockRotation.m_55952_(Rotation.CLOCKWISE_90);
                blockMirror = Mirror.LEFT_RIGHT;
            } else if (direction2 == Direction.WEST && direction == Direction.NORTH) {
                i = 15;
                j = 6;
                blockRotation2 = blockRotation.m_55952_(Rotation.CLOCKWISE_180);
            } else if (direction2 == Direction.WEST && direction == Direction.SOUTH) {
                i = 15;
                blockMirror = Mirror.FRONT_BACK;
            }
            BlockPos blockPos2 = blockPos.m_5484_(blockRotation.m_55954_(Direction.EAST), i);
            blockPos2 = blockPos2.m_5484_(blockRotation.m_55954_(Direction.SOUTH), j);
            structurePieces.add(this.getJigsawPiece(poolRegistry, roomCollection.get2x2(this.random), blockPos2, blockRotation2, blockMirror, type));
        }

        private void addBigSecretRoom(WritableRegistry<StructureTemplatePool> poolRegistry, List<StructurePiece> structurePieces, BlockPos blockPos, Rotation blockRotation, RoomCollection roomCollection, MANSIONTYPE type) {
            BlockPos blockPos2 = blockPos.m_5484_(blockRotation.m_55954_(Direction.EAST), 1);
            structurePieces.add(this.getJigsawPiece(poolRegistry, roomCollection.get2x2Secret(this.random), blockPos2, blockRotation, Mirror.NONE, type));
        }

        private StructurePiece getJigsawPiece(WritableRegistry<StructureTemplatePool> poolRegistry, String poolPath, BlockPos blockPos, Rotation rotation, Mirror mirror, MANSIONTYPE type) {
            Object poolEntry;
            ResourceLocation resourceLocation = new ResourceLocation(poolPath.toLowerCase(Locale.ROOT));
            StructureTemplatePool pool = (StructureTemplatePool)poolRegistry.m_7745_(resourceLocation);
            if (pool == null || pool.m_69278_() == 0) {
                RepurposedStructures.LOGGER.warn("Repurposed Structures: Empty or nonexistent pool: {}  Will not generate mansion piece at spot.", (Object)(resourceLocation + " - Mansion type: " + type));
                poolEntry = (StructurePoolElement)StructurePoolElement.m_69232_().apply(StructureTemplatePool.Projection.RIGID);
            } else {
                poolEntry = pool.m_69273_(this.random);
                if (poolEntry instanceof SinglePoolElement) {
                    poolEntry = new MirroringSingleJigsawPiece((SinglePoolElement)poolEntry, mirror);
                }
            }
            return new PoolElementStructurePiece(this.manager, poolEntry, blockPos, poolEntry.m_69231_(), rotation, poolEntry.m_6867_(this.manager, blockPos, rotation));
        }
    }

    public static enum MANSIONTYPE {
        BIRCH(Blocks.f_50043_.m_49966_()),
        OAK(Blocks.f_50043_.m_49966_()),
        TAIGA(Blocks.f_50652_.m_49966_()),
        JUNGLE(Blocks.f_50079_.m_49966_()),
        SAVANNA(Blocks.f_50043_.m_49966_()),
        SNOWY(Blocks.f_50127_.m_49966_()),
        DESERT(Blocks.f_50062_.m_49966_());

        private final BlockState foundationBlock;

        private MANSIONTYPE(BlockState foundationBlock) {
            this.foundationBlock = foundationBlock;
        }

        public BlockState getFoundationBlock() {
            return this.foundationBlock;
        }
    }

    static class GenerationPiece {
        public Rotation rotation;
        public BlockPos position;
        public String template;

        private GenerationPiece() {
        }
    }

    static class FlagMatrix {
        private final int[][] array;
        private final int n;
        private final int m;
        private final int fallback;

        public FlagMatrix(int n, int m, int fallback) {
            this.n = n;
            this.m = m;
            this.fallback = fallback;
            this.array = new int[n][m];
        }

        public void set(int i, int j, int value) {
            if (i >= 0 && i < this.n && j >= 0 && j < this.m) {
                this.array[i][j] = value;
            }
        }

        public void fill(int i0, int j0, int i1, int j1, int value) {
            for (int i = j0; i <= j1; ++i) {
                for (int j = i0; j <= i1; ++j) {
                    this.set(j, i, value);
                }
            }
        }

        public int get(int i, int j) {
            return i >= 0 && i < this.n && j >= 0 && j < this.m ? this.array[i][j] : this.fallback;
        }

        public void update(int i, int j, int expected, int newValue) {
            if (this.get(i, j) == expected) {
                this.set(i, j, newValue);
            }
        }

        public boolean anyMatchAround(int i, int j, int value) {
            return this.get(i - 1, j) == value || this.get(i + 1, j) == value || this.get(i, j + 1) == value || this.get(i, j - 1) == value;
        }
    }

    static class ThirdFloor
    extends RoomCollection {
        private ThirdFloor(MANSIONTYPE type) {
            super("third_floor", type);
        }

        @Override
        public String get1x1(Random random) {
            return "repurposed_structures:mansions/" + this.type + "/" + this.floor + "_1x1_rooms";
        }

        @Override
        public String get1x1Secret(Random random) {
            return "repurposed_structures:mansions/" + this.type + "/" + this.floor + "_1x1_secret_rooms";
        }

        @Override
        public String get1x2SideEntrance(Random random, boolean isStairs) {
            return "repurposed_structures:mansions/" + this.type + "/" + this.floor + (isStairs ? "_1x2_c_stairs" : "_1x2_rooms");
        }

        @Override
        public String get1x2FrontEntrance(Random random, boolean isStairs) {
            return "repurposed_structures:mansions/" + this.type + "/" + this.floor + (isStairs ? "_1x2_d_stairs" : "_1x2_alternative_rooms");
        }

        @Override
        public String get1x2Secret(Random random) {
            return "repurposed_structures:mansions/" + this.type + "/" + this.floor + "_1x2_secret_rooms";
        }

        @Override
        public String get2x2(Random random) {
            return "repurposed_structures:mansions/" + this.type + "/" + this.floor + "_2x2_rooms";
        }

        @Override
        public String get2x2Secret(Random random) {
            return "repurposed_structures:mansions/" + this.type + "/" + this.floor + "_2x2_secret_rooms";
        }
    }

    static class SecondFloor
    extends RoomCollection {
        private SecondFloor(MANSIONTYPE type) {
            super("second_floor", type);
        }

        @Override
        public String get1x1(Random random) {
            return "repurposed_structures:mansions/" + this.type + "/" + this.floor + "_1x1_rooms";
        }

        @Override
        public String get1x1Secret(Random random) {
            return "repurposed_structures:mansions/" + this.type + "/" + this.floor + "_1x1_secret_rooms";
        }

        @Override
        public String get1x2SideEntrance(Random random, boolean isStairs) {
            return "repurposed_structures:mansions/" + this.type + "/" + this.floor + (isStairs ? "_1x2_c_stairs" : "_1x2_rooms");
        }

        @Override
        public String get1x2FrontEntrance(Random random, boolean isStairs) {
            return "repurposed_structures:mansions/" + this.type + "/" + this.floor + (isStairs ? "_1x2_d_stairs" : "_1x2_alternative_rooms");
        }

        @Override
        public String get1x2Secret(Random random) {
            return "repurposed_structures:mansions/" + this.type + "/" + this.floor + "_1x2_secret_rooms";
        }

        @Override
        public String get2x2(Random random) {
            return "repurposed_structures:mansions/" + this.type + "/" + this.floor + "_2x2_rooms";
        }

        @Override
        public String get2x2Secret(Random random) {
            return "repurposed_structures:mansions/" + this.type + "/" + this.floor + "_2x2_secret_rooms";
        }
    }

    static class FirstFloor
    extends RoomCollection {
        private FirstFloor(MANSIONTYPE type) {
            super("first_floor", type);
        }

        @Override
        public String get1x1(Random random) {
            return "repurposed_structures:mansions/" + this.type + "/" + this.floor + "_1x1_rooms";
        }

        @Override
        public String get1x1Secret(Random random) {
            return "repurposed_structures:mansions/" + this.type + "/" + this.floor + "_1x1_secret_rooms";
        }

        @Override
        public String get1x2SideEntrance(Random random, boolean isStairs) {
            return "repurposed_structures:mansions/" + this.type + "/" + this.floor + "_1x2_rooms";
        }

        @Override
        public String get1x2FrontEntrance(Random random, boolean isStairs) {
            return "repurposed_structures:mansions/" + this.type + "/" + this.floor + "_1x2_alternative_rooms";
        }

        @Override
        public String get1x2Secret(Random random) {
            return "repurposed_structures:mansions/" + this.type + "/" + this.floor + "_1x2_secret_rooms";
        }

        @Override
        public String get2x2(Random random) {
            return "repurposed_structures:mansions/" + this.type + "/" + this.floor + "_2x2_rooms";
        }

        @Override
        public String get2x2Secret(Random random) {
            return "repurposed_structures:mansions/" + this.type + "/" + this.floor + "_2x2_secret_rooms";
        }
    }

    static abstract class RoomCollection {
        protected final String floor;
        protected final MANSIONTYPE type;

        private RoomCollection(String floor, MANSIONTYPE type) {
            this.floor = floor;
            this.type = type;
        }

        public abstract String get1x1(Random var1);

        public abstract String get1x1Secret(Random var1);

        public abstract String get1x2SideEntrance(Random var1, boolean var2);

        public abstract String get1x2FrontEntrance(Random var1, boolean var2);

        public abstract String get1x2Secret(Random var1);

        public abstract String get2x2(Random var1);

        public abstract String get2x2Secret(Random var1);
    }
}

