/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.backtools.client.core;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.WeakHashMap;
import javax.annotation.Nonnull;
import me.ichun.mods.backtools.client.render.BackToolLayer;
import me.ichun.mods.backtools.common.BackTools;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.FishingRodItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ShearsItem;
import net.minecraft.item.ShieldItem;
import net.minecraft.item.ShootableItem;
import net.minecraft.item.TieredItem;
import net.minecraft.item.TridentItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.common.capabilities.CapabilityProvider;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(modid="backtools", value={Dist.CLIENT})
public class EventHandler {
    public static WeakHashMap<AbstractClientPlayerEntity, HeldInfo> heldTools = new WeakHashMap();
    public static HashSet<ResourceLocation> enabledTools = new HashSet();
    public static HashSet<ResourceLocation> disabledTools = new HashSet();
    public static HashMap<Class<? extends Item>, Integer> toolOrientations = new HashMap();

    public static void addLayers() {
        Minecraft.func_71410_x().func_175598_ae().field_178636_l.forEach((k, v) -> v.func_177094_a((LayerRenderer)new BackToolLayer((IEntityRenderer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>>)v)));
    }

    public static void setupConfig() {
        enabledTools.clear();
        BackTools.config.enabledTools.forEach(s -> enabledTools.add(new ResourceLocation(s)));
        if (enabledTools.isEmpty()) {
            disabledTools.clear();
            BackTools.config.disabledTools.forEach(s -> disabledTools.add(new ResourceLocation(s)));
            disabledTools.addAll(BackTools.imcDisabledTools);
        }
        toolOrientations.clear();
        for (String s2 : BackTools.config.toolOrientation) {
            String[] split = new String[2];
            int index = s2.indexOf(58);
            if (index > 0) {
                split[0] = s2.substring(0, index);
                split[1] = s2.substring(index + 1);
            } else {
                BackTools.LOGGER.warn("Could not parse orientation: {}", (Object)s2);
            }
            try {
                Class<?> clz = Class.forName(split[0]);
                if (Item.class.isAssignableFrom(clz)) {
                    toolOrientations.put(clz, Integer.parseInt(split[1]));
                    continue;
                }
                BackTools.LOGGER.warn("Class does not extend Item class: {}", (Object)split[0]);
            }
            catch (ClassNotFoundException e) {
                BackTools.LOGGER.warn("Could not find class to add orientation: {}", (Object)split[0]);
            }
            catch (NumberFormatException e) {
                BackTools.LOGGER.warn("Could not parse integer: {}", (Object)s2);
            }
        }
        toolOrientations.putAll(BackTools.imcOrientation);
    }

    public static Integer getToolOrientation(Item item) {
        return EventHandler.getToolOrientation(item.getClass());
    }

    public static Integer getToolOrientation(Class clz) {
        if (Item.class.equals((Object)clz)) {
            return 0;
        }
        if (!toolOrientations.containsKey(clz)) {
            toolOrientations.put(clz, EventHandler.getToolOrientation(clz.getSuperclass()));
        }
        return toolOrientations.get(clz);
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START && event.player.field_70170_p.field_72995_K) {
            AbstractClientPlayerEntity player = (AbstractClientPlayerEntity)event.player;
            if (!player.func_70089_S()) {
                heldTools.remove(player);
            } else {
                HeldInfo info = heldTools.computeIfAbsent(player, v -> new HeldInfo());
                info.tick(player.func_184614_ca().func_77946_l(), player.func_184592_cb().func_77946_l());
            }
        }
    }

    @SubscribeEvent
    public static void onItemSpawnEvent(EntityJoinWorldEvent event) {
        if (event.getWorld().field_72995_K && event.getEntity() instanceof ItemEntity) {
            ItemEntity item = (ItemEntity)event.getEntity();
            List ents = event.getWorld().func_217394_a(EntityType.field_200729_aH, item.func_174813_aQ().func_72321_a(1.0, 1.0, 1.0), k -> true);
            ents.forEach(e -> {
                if (e instanceof AbstractClientPlayerEntity) {
                    heldTools.computeIfPresent((AbstractClientPlayerEntity)e, (k, v) -> {
                        v.itemEntity = item;
                        return v;
                    });
                }
            });
        }
    }

    @SubscribeEvent
    public static void onWorldLoad(WorldEvent.Load event) {
        Minecraft.func_71410_x().execute(EventHandler::clean);
    }

    @SubscribeEvent
    public static void onLoggedOutEvent(ClientPlayerNetworkEvent.LoggedOutEvent event) {
        Minecraft.func_71410_x().execute(EventHandler::clean);
    }

    public static void clean() {
        heldTools.clear();
    }

    public static boolean isItemTool(Item item) {
        if (!enabledTools.isEmpty()) {
            return enabledTools.contains(item.getRegistryName());
        }
        if (disabledTools.contains(item.getRegistryName())) {
            return false;
        }
        return item instanceof TieredItem || item instanceof ShootableItem || item instanceof ShearsItem || item instanceof FishingRodItem || item instanceof ShieldItem || item instanceof TridentItem;
    }

    public static boolean areItemStacksEqualToolsIgnoreDamage(@Nonnull ItemStack stackA, @Nonnull ItemStack stackB) {
        if (stackA.func_190926_b() || stackB.func_190926_b() || stackA.func_77942_o() && !stackB.func_77942_o() || !stackA.func_77942_o() && stackB.func_77942_o() || stackA.func_77973_b() != stackB.func_77973_b()) {
            return false;
        }
        if (stackA.func_77942_o() && stackB.func_77942_o()) {
            CompoundNBT tagA = stackA.func_77978_p().func_74737_b();
            CompoundNBT tagB = stackB.func_77978_p().func_74737_b();
            for (String s : BackTools.config.nbtCleaner) {
                tagA.func_82580_o(s);
                tagB.func_82580_o(s);
            }
            return tagA.equals((Object)tagB) && stackA.areCapsCompatible((CapabilityProvider)stackB);
        }
        return stackA.areCapsCompatible((CapabilityProvider)stackB);
    }

    public static class HeldInfo {
        public ItemEntity itemEntity = null;
        public ItemStack lastMain = ItemStack.field_190927_a;
        public ItemStack lastOff = ItemStack.field_190927_a;
        public ItemStack toolMain = ItemStack.field_190927_a;
        public ItemStack toolOff = ItemStack.field_190927_a;

        public void tick(ItemStack main, ItemStack off) {
            if (this.itemEntity != null && !this.itemEntity.func_92059_d().func_190926_b()) {
                this.checkItem(this.itemEntity);
                this.itemEntity = null;
                return;
            }
            if (EventHandler.areItemStacksEqualToolsIgnoreDamage(main, this.lastMain) || EventHandler.areItemStacksEqualToolsIgnoreDamage(off, this.lastMain)) {
                this.lastMain = ItemStack.field_190927_a;
            }
            if (EventHandler.areItemStacksEqualToolsIgnoreDamage(main, this.lastOff) || EventHandler.areItemStacksEqualToolsIgnoreDamage(off, this.lastOff)) {
                this.lastOff = ItemStack.field_190927_a;
            }
            if (!(this.toolMain.func_190926_b() || EventHandler.areItemStacksEqualToolsIgnoreDamage(main, this.toolMain) || EventHandler.areItemStacksEqualToolsIgnoreDamage(off, this.toolMain))) {
                this.lastMain = this.toolMain;
                this.toolMain = ItemStack.field_190927_a;
            }
            if (!(this.toolOff.func_190926_b() || EventHandler.areItemStacksEqualToolsIgnoreDamage(main, this.toolOff) || EventHandler.areItemStacksEqualToolsIgnoreDamage(off, this.toolOff))) {
                this.lastOff = this.toolOff;
                this.toolOff = ItemStack.field_190927_a;
            }
            if (EventHandler.isItemTool(main.func_77973_b())) {
                this.toolMain = main;
                if (EventHandler.areItemStacksEqualToolsIgnoreDamage(this.toolMain, this.toolOff)) {
                    this.toolOff = ItemStack.field_190927_a;
                }
            }
            if (EventHandler.isItemTool(off.func_77973_b())) {
                this.toolOff = off;
                if (EventHandler.areItemStacksEqualToolsIgnoreDamage(this.toolOff, this.toolMain)) {
                    this.toolMain = ItemStack.field_190927_a;
                }
            }
        }

        public void checkItem(ItemEntity item) {
            if (EventHandler.areItemStacksEqualToolsIgnoreDamage(item.func_92059_d(), this.lastMain)) {
                this.lastMain = ItemStack.field_190927_a;
            }
            if (EventHandler.areItemStacksEqualToolsIgnoreDamage(item.func_92059_d(), this.toolMain)) {
                this.toolMain = ItemStack.field_190927_a;
            }
            if (EventHandler.areItemStacksEqualToolsIgnoreDamage(item.func_92059_d(), this.lastOff)) {
                this.lastOff = ItemStack.field_190927_a;
            }
            if (EventHandler.areItemStacksEqualToolsIgnoreDamage(item.func_92059_d(), this.toolOff)) {
                this.toolOff = ItemStack.field_190927_a;
            }
        }
    }
}

