/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.tips.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Optional;
import net.darkhax.bookshelf.util.RenderUtils;
import net.darkhax.tips.Tips;
import net.darkhax.tips.data.tip.ITip;
import net.darkhax.tips.gui.ListEntry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.client.gui.GuiUtils;

@OnlyIn(value=Dist.CLIENT)
public class ListEntryTip
extends ListEntry {
    final ITip tip;

    ListEntryTip(Minecraft mc, ITip tip) {
        super(mc);
        this.tip = tip;
    }

    public void func_230432_a_(MatrixStack matrix, int index, int yStart, int xStart, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTicks) {
        if (!Tips.CFG.canLoadTip(this.tip.getId())) {
            ListEntryTip.drawGradient(matrix, xStart - 2, yStart + 2, width + 2, height - 6, 0x40FF0000, -9437184, -10485760);
        }
        this.mc.field_71466_p.func_243248_b(matrix, this.tip.getTitle(), (float)xStart, (float)(yStart + 2), 0xFFFFFF);
        FontRenderer font = this.mc.field_71466_p;
        this.mc.field_71466_p.getClass();
        font.getClass();
        RenderUtils.renderLinesWrapped((MatrixStack)matrix, (FontRenderer)font, (int)xStart, (int)(yStart + 7 + 9), (int)9, (int)0xFFFFFF, (ITextComponent)this.tip.getText(), (int)width);
    }

    @Override
    public void renderMouseOver(MatrixStack matrix, int mouseX, int mouseY) {
        ArrayList<Object> tooltip = new ArrayList<Object>();
        tooltip.add(new TranslationTextComponent("gui.tips.list.entry.tip_id", new Object[]{this.tip.getId().toString()}));
        tooltip.add(new TranslationTextComponent("gui.tips.list.entry.added_by", new Object[]{ListEntryTip.getModName(this.tip.getId().func_110624_b())}).func_240699_a_(TextFormatting.BLUE));
        if (!Tips.CFG.canLoadTip(this.tip.getId())) {
            tooltip.add(new TranslationTextComponent("gui.tips.list.entry.disabled").func_240699_a_(TextFormatting.RED));
        }
        tooltip.add(new TranslationTextComponent("gui.tips.list.entry.cycle_time", new Object[]{ListEntryTip.ticksToTime(this.tip.getCycleTime() / 50, false, false)}));
        if (this.isSelected) {
            tooltip.add(new TranslationTextComponent("gui.tips.list.entry.copied").func_240699_a_(TextFormatting.GREEN));
        } else {
            tooltip.add(new TranslationTextComponent("gui.tips.list.entry.click_to_copy").func_240699_a_(TextFormatting.GRAY));
        }
        this.mc.field_71462_r.func_243308_b(matrix, tooltip, mouseX, mouseY);
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        if (this.isSelected && this.func_231047_b_(mouseX, mouseY)) {
            this.mc.field_195559_v.func_197960_a(this.tip.getId().toString());
        }
        return super.func_231044_a_(mouseX, mouseY, button);
    }

    private static String getModName(String modId) {
        Optional modInfo;
        if (ModList.get().isLoaded(modId) && (modInfo = ModList.get().getModContainerById(modId)).isPresent()) {
            return ((ModContainer)modInfo.get()).getModInfo().getDisplayName();
        }
        return modId;
    }

    public static void drawGradient(MatrixStack mStack, int x, int y, int width, int height, int backgroundColor, int borderColorStart, int borderColorEnd) {
        RenderSystem.disableRescaleNormal();
        RenderSystem.disableDepthTest();
        boolean zLevel = false;
        mStack.func_227860_a_();
        Matrix4f mat = mStack.func_227866_c_().func_227870_a_();
        GuiUtils.drawGradientRect((Matrix4f)mat, (int)0, (int)(x - 3), (int)(y - 4), (int)(x + width + 3), (int)(y - 3), (int)backgroundColor, (int)backgroundColor);
        GuiUtils.drawGradientRect((Matrix4f)mat, (int)0, (int)(x - 3), (int)(y + height + 3), (int)(x + width + 3), (int)(y + height + 4), (int)backgroundColor, (int)backgroundColor);
        GuiUtils.drawGradientRect((Matrix4f)mat, (int)0, (int)(x - 3), (int)(y - 3), (int)(x + width + 3), (int)(y + height + 3), (int)backgroundColor, (int)backgroundColor);
        GuiUtils.drawGradientRect((Matrix4f)mat, (int)0, (int)(x - 4), (int)(y - 3), (int)(x - 3), (int)(y + height + 3), (int)backgroundColor, (int)backgroundColor);
        GuiUtils.drawGradientRect((Matrix4f)mat, (int)0, (int)(x + width + 3), (int)(y - 3), (int)(x + width + 4), (int)(y + height + 3), (int)backgroundColor, (int)backgroundColor);
        GuiUtils.drawGradientRect((Matrix4f)mat, (int)0, (int)(x - 3), (int)(y - 3 + 1), (int)(x - 3 + 1), (int)(y + height + 3 - 1), (int)borderColorStart, (int)borderColorEnd);
        GuiUtils.drawGradientRect((Matrix4f)mat, (int)0, (int)(x + width + 2), (int)(y - 3 + 1), (int)(x + width + 3), (int)(y + height + 3 - 1), (int)borderColorStart, (int)borderColorEnd);
        GuiUtils.drawGradientRect((Matrix4f)mat, (int)0, (int)(x - 3), (int)(y - 3), (int)(x + width + 3), (int)(y - 3 + 1), (int)borderColorStart, (int)borderColorStart);
        GuiUtils.drawGradientRect((Matrix4f)mat, (int)0, (int)(x - 3), (int)(y + height + 2), (int)(x + width + 3), (int)(y + height + 3), (int)borderColorEnd, (int)borderColorEnd);
        mStack.func_227865_b_();
        RenderSystem.enableDepthTest();
        RenderSystem.enableRescaleNormal();
    }

    private static ITextComponent ticksToTime(int ticks, boolean prefix, boolean color) {
        String result;
        boolean isPositive = ticks > 0;
        ticks = Math.abs(ticks);
        int seconds = ticks / 20;
        int minutes = seconds / 60;
        String string = result = (seconds %= 60) < 10 ? minutes + ":0" + seconds : minutes + ":" + seconds;
        StringTextComponent component = new StringTextComponent(prefix ? (isPositive ? "+" : "-") + result : result);
        return color ? (isPositive ? component.func_240699_a_(TextFormatting.GREEN) : component.func_240699_a_(TextFormatting.RED)) : component;
    }
}

