/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.tips.gui;

import com.google.common.base.Objects;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.io.File;
import net.darkhax.tips.gui.ButtonCheckbox;
import net.darkhax.tips.gui.ButtonTextField;
import net.darkhax.tips.gui.TipsList;
import net.minecraft.client.GameSettings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.SettingsScreen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.button.CheckboxButton;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.loading.FMLPaths;

@OnlyIn(value=Dist.CLIENT)
public class TipsListScreen
extends SettingsScreen {
    private TipsList list;
    private CheckboxButton showDisabled;
    private TextFieldWidget searchBar;
    private Button openConfigFile;
    private String lastSearch;

    public static Screen factory(Minecraft mc, Screen parent) {
        return new TipsListScreen(parent, mc.field_71474_y);
    }

    public TipsListScreen(Screen screen, GameSettings settings) {
        super(screen, settings, (ITextComponent)new TranslationTextComponent("gui.tips.list.title"));
    }

    protected void func_231160_c_() {
        this.list = new TipsList(this, this.field_230706_i_);
        this.field_230705_e_.add(this.list);
        this.searchBar = new ButtonTextField(this.field_230712_o_, this.field_230708_k_ / 2 - 75 - 50, this.field_230709_l_ - 26, 150, 20, (ITextComponent)new TranslationTextComponent("gui.tips.list.search"));
        this.field_230705_e_.add(this.searchBar);
        this.showDisabled = new ButtonCheckbox(this.field_230708_k_ / 2 - 10 + 50, this.field_230709_l_ - 26, 20, 20, (ITextComponent)new TranslationTextComponent("gui.tips.list.show_disabled"), false, p -> this.list.refreshEntries((boolean)p, this.searchBar.func_146179_b()));
        this.func_230480_a_((Widget)this.showDisabled);
        this.openConfigFile = new Button(this.field_230708_k_ - 70, this.field_230709_l_ - 26, 60, 20, (ITextComponent)new TranslationTextComponent("gui.tips.list.config"), this::openConfigFile);
        this.func_230480_a_((Widget)this.openConfigFile);
        this.searchBar.func_212954_a(s -> {
            if (!Objects.equal((Object)this.lastSearch, (Object)s)) {
                this.list.refreshEntries(this.showDisabled.func_212942_a(), (String)s);
                this.lastSearch = s;
            }
        });
        super.func_231160_c_();
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.list.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.searchBar.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        TipsListScreen.func_238472_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (ITextComponent)this.field_230704_d_, (int)(this.field_230708_k_ / 2), (int)16, (int)0xFFFFFF);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
    }

    private void openConfigFile(Button button) {
        File cfgFile = FMLPaths.CONFIGDIR.get().resolve("tips-client.toml").toFile();
        Util.func_110647_a().func_195642_a(cfgFile.toURI());
    }
}

