/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.itemborders;

import com.anthonyhilyard.itemborders.ItemBordersConfig;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.gui.GuiUtils;

public class ItemBorders {
    public static void renderBorder(MatrixStack matrixStack, Slot slot) {
        ItemBorders.render(matrixStack, slot.func_75211_c(), slot.field_75223_e, slot.field_75221_f);
    }

    public static void renderBorder(ItemStack item, int x, int y) {
        if (((Boolean)ItemBordersConfig.INSTANCE.hotBar.get()).booleanValue()) {
            ItemBorders.render(new MatrixStack(), item, x, y);
        }
    }

    private static void render(MatrixStack matrixStack, ItemStack item, int x, int y) {
        if (item.func_190926_b()) {
            return;
        }
        Color color = ItemBordersConfig.INSTANCE.getBorderColorForItem(item);
        if (color == null) {
            color = Color.func_240744_a_((TextFormatting)TextFormatting.WHITE);
        }
        if (color.func_240742_a_() == TextFormatting.WHITE.func_211163_e().intValue() && !((Boolean)ItemBordersConfig.INSTANCE.showForCommon.get()).booleanValue()) {
            return;
        }
        RenderSystem.disableDepthTest();
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.0, 0.0, (Boolean)ItemBordersConfig.INSTANCE.overItems.get() != false ? 290.0 : 100.0);
        Matrix4f matrix = matrixStack.func_227866_c_().func_227870_a_();
        int startColor = color.func_240742_a_() | 0xEE000000;
        int endColor = color.func_240742_a_() & 0xFFFFFF;
        int topColor = (Boolean)ItemBordersConfig.INSTANCE.fullBorder.get() != false ? startColor : endColor;
        int bottomColor = startColor;
        int xOffset = (Boolean)ItemBordersConfig.INSTANCE.squareCorners.get() != false ? 0 : 1;
        IRenderTypeBuffer.Impl bufferSource = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
        GuiUtils.drawGradientRect((Matrix4f)matrix, (int)-1, (int)x, (int)(y + 1), (int)(x + 1), (int)(y + 15), (int)topColor, (int)bottomColor);
        GuiUtils.drawGradientRect((Matrix4f)matrix, (int)-1, (int)(x + 15), (int)(y + 1), (int)(x + 16), (int)(y + 15), (int)topColor, (int)bottomColor);
        GuiUtils.drawGradientRect((Matrix4f)matrix, (int)-1, (int)(x + xOffset), (int)y, (int)(x + 16 - xOffset), (int)(y + 1), (int)topColor, (int)topColor);
        GuiUtils.drawGradientRect((Matrix4f)matrix, (int)-1, (int)(x + xOffset), (int)(y + 15), (int)(x + 16 - xOffset), (int)(y + 16), (int)bottomColor, (int)bottomColor);
        if (((Boolean)ItemBordersConfig.INSTANCE.extraGlow.get()).booleanValue()) {
            int topAlpha = (topColor >> 24 & 0xFF) / 3;
            int bottomAlpha = (bottomColor >> 24 & 0xFF) / 3;
            int topGlowColor = topAlpha << 24 | topColor & 0xFFFFFF;
            int bottomGlowColor = bottomAlpha << 24 | bottomColor & 0xFFFFFF;
            GuiUtils.drawGradientRect((Matrix4f)matrix, (int)-1, (int)(x + 1), (int)(y + 1), (int)(x + 2), (int)(y + 15), (int)topGlowColor, (int)bottomGlowColor);
            GuiUtils.drawGradientRect((Matrix4f)matrix, (int)-1, (int)(x + 14), (int)(y + 1), (int)(x + 15), (int)(y + 15), (int)topGlowColor, (int)bottomGlowColor);
            GuiUtils.drawGradientRect((Matrix4f)matrix, (int)-1, (int)(x + 1), (int)(y + 1), (int)(x + 15), (int)(y + 2), (int)topGlowColor, (int)topGlowColor);
            GuiUtils.drawGradientRect((Matrix4f)matrix, (int)-1, (int)(x + 1), (int)(y + 14), (int)(x + 15), (int)(y + 15), (int)bottomGlowColor, (int)bottomGlowColor);
        }
        bufferSource.func_228461_a_();
        matrixStack.func_227865_b_();
    }
}

