/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.itemborders;

import com.anthonyhilyard.iceberg.util.ItemColor;
import com.anthonyhilyard.iceberg.util.Selectors;
import com.anthonyhilyard.itemborders.Loader;
import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.ConfigFormat;
import com.electronwill.nightconfig.toml.TomlFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.Color;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="itemborders", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ItemBordersConfig {
    public static final ForgeConfigSpec SPEC;
    public static final ItemBordersConfig INSTANCE;
    public final ForgeConfigSpec.BooleanValue hotBar;
    public final ForgeConfigSpec.BooleanValue showForCommon;
    public final ForgeConfigSpec.BooleanValue squareCorners;
    public final ForgeConfigSpec.BooleanValue fullBorder;
    public final ForgeConfigSpec.BooleanValue overItems;
    public final ForgeConfigSpec.BooleanValue extraGlow;
    public final ForgeConfigSpec.BooleanValue automaticBorders;
    private final ForgeConfigSpec.ConfigValue<Config> manualBorders;
    public final ForgeConfigSpec.BooleanValue lootBeamSync;
    private Map<ItemKey, Color> cachedCustomBorders = new HashMap<ItemKey, Color>();
    private Map<String, Color> lootBeamsSelectors = new HashMap<String, Color>();
    private boolean emptyCache = true;

    public ItemBordersConfig(ForgeConfigSpec.Builder build) {
        build.comment("Client Configuration").push("client").push("options");
        this.hotBar = build.comment(" If the hotbar should display item borders.").define("hotbar", true);
        this.showForCommon = build.comment(" If item borders should show for common items.").define("show_for_common", false);
        this.squareCorners = build.comment(" If the borders should have square corners.").define("square_corners", true);
        this.fullBorder = build.comment(" If the borders should fully envelop item slots (otherwise they will only show on the bottom portion of the slot).").define("full_border", false);
        this.overItems = build.comment(" If the borders draw over items instead of under.").define("over_items", false);
        this.extraGlow = build.comment(" If the borders should have a more prominent glow.").define("extra_glow", false);
        this.automaticBorders = build.comment(" If automatic borders (based on item rarity) should be enabled.").define("auto_borders", true);
        this.lootBeamSync = build.comment(" If border colors should sync with loot beam colors. (From Loot Beams mod--any custom beams colors specified in Loot Beams configuration will be displayed as borders.)").define("loot_beam_sync", true);
        StringBuilder bordersComment = new StringBuilder(" Custom border colors for specific items. Format: { <color> = [\"list of selectors\"] }. Selectors supported:\n");
        for (Selectors.SelectorDocumentation doc : Selectors.selectorDocumentation()) {
            bordersComment.append("    ").append(doc.name).append(" - ").append(doc.description);
            if (!doc.examples.isEmpty()) {
                bordersComment.append("  Examples: ");
                for (int i = 0; i < doc.examples.size(); ++i) {
                    if (i > 0) {
                        bordersComment.append(", ");
                    }
                    bordersComment.append("\"").append((String)doc.examples.get(i)).append("\"");
                }
            }
            bordersComment.append("\n");
        }
        bordersComment.setLength(bordersComment.length() - 1);
        this.manualBorders = build.comment(bordersComment.toString()).define("manual_borders", (Object)Config.of((ConfigFormat)TomlFormat.instance()), v -> true);
        build.pop().pop();
    }

    @SubscribeEvent
    public static void onLoad(ModConfig.Reloading e) {
        if (e.getConfig().getModId().equals("itemborders") || e.getConfig().getModId().equals("lootbeams")) {
            ItemBordersConfig.INSTANCE.emptyCache = true;
        }
    }

    /*
     * WARNING - void declaration
     */
    public Color getBorderColorForItem(ItemStack item) {
        void var4_9;
        ItemKey itemKey = new ItemKey(item.func_77973_b(), item.func_77978_p());
        if (this.emptyCache) {
            this.emptyCache = false;
            this.cachedCustomBorders.clear();
            if (((Boolean)this.lootBeamSync.get()).booleanValue() && ModList.get().isLoaded("lootbeams")) {
                try {
                    this.lootBeamsSelectors = (Map)Class.forName("com.anthonyhilyard.itemborders.LootBeamsHandler").getMethod("getCustomBeams", new Class[0]).invoke(null, new Object[0]);
                }
                catch (Exception e) {
                    Loader.LOGGER.warn(ExceptionUtils.getStackTrace((Throwable)e));
                }
            }
        }
        if (this.cachedCustomBorders.containsKey(itemKey)) {
            return this.cachedCustomBorders.get(itemKey);
        }
        if (this.lootBeamsSelectors != null) {
            for (String string : this.lootBeamsSelectors.keySet()) {
                Color color = this.lootBeamsSelectors.get(string);
                if (color == null || !Selectors.itemMatches((ItemStack)item, (String)string)) continue;
                this.cachedCustomBorders.put(itemKey, color);
                return color;
            }
        }
        Map manualBorderMap = ((Config)this.manualBorders.get()).valueMap();
        for (String key : manualBorderMap.keySet()) {
            Object value;
            Color color = Color.func_240745_a_((String)key);
            if (color == null) {
                if (key.replace("0x", "").length() == 6) {
                    color = Color.func_240745_a_((String)("#" + key.replace("0x", "")));
                } else if (key.replace("0x", "").length() == 8) {
                    color = Color.func_240745_a_((String)("#" + key.toLowerCase().replace("0xff", "")));
                }
                if (color == null) continue;
            }
            if ((value = manualBorderMap.get(key)) instanceof String) {
                if (!Selectors.itemMatches((ItemStack)item, (String)((String)value))) continue;
                this.cachedCustomBorders.put(itemKey, color);
                return color;
            }
            if (!(value instanceof List)) continue;
            List valueList = (List)value;
            for (Object stringVal : valueList) {
                if (!(stringVal instanceof String) || !Selectors.itemMatches((ItemStack)item, (String)((String)stringVal))) continue;
                this.cachedCustomBorders.put(itemKey, color);
                return color;
            }
        }
        Object var4_7 = null;
        if (((Boolean)ItemBordersConfig.INSTANCE.automaticBorders.get()).booleanValue()) {
            Color color = ItemColor.getColorForItem((ItemStack)item, null);
        }
        this.cachedCustomBorders.put(itemKey, (Color)var4_9);
        return var4_9;
    }

    static {
        Config.setInsertionOrderPreserved((boolean)true);
        Pair specPair = new ForgeConfigSpec.Builder().configure(ItemBordersConfig::new);
        SPEC = (ForgeConfigSpec)specPair.getRight();
        INSTANCE = (ItemBordersConfig)specPair.getLeft();
    }

    private static class ItemKey {
        public final Item item;
        public final CompoundNBT tag;

        public ItemKey(Item item, CompoundNBT tag) {
            this.item = item;
            this.tag = tag;
        }

        public int hashCode() {
            return Objects.hash(this.item, this.tag);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ItemKey)) {
                return false;
            }
            ItemKey other = (ItemKey)obj;
            return Objects.equals(this.item, other.item) && Objects.equals(this.tag, other.tag);
        }
    }
}

