/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.api.client.util;

import com.google.common.base.Suppliers;
import dev.architectury.injectables.annotations.ExpectPlatform;
import gg.moonflower.pollen.api.client.util.forge.CreativeModeTabBuilderImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import org.jetbrains.annotations.ApiStatus;

public final class CreativeModeTabBuilder {
    private final ResourceLocation name;
    private Supplier<ItemStack> icon;
    private BiConsumer<List<ItemStack>, ItemGroup> stacksForDisplay;

    private CreativeModeTabBuilder(ResourceLocation name) {
        this.name = name;
        this.icon = () -> ItemStack.field_190927_a;
        this.stacksForDisplay = null;
    }

    /*
     * WARNING - void declaration
     */
    @ApiStatus.Internal
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static ItemGroup buildImpl(ResourceLocation name, Supplier<ItemStack> icon, BiConsumer<List<ItemStack>, ItemGroup> stacksForDisplay) {
        void var2_2;
        void var1_1;
        return CreativeModeTabBuilderImpl.buildImpl(name, (Supplier<ItemStack>)var1_1, (BiConsumer<List<ItemStack>, ItemGroup>)var2_2);
    }

    public static CreativeModeTabBuilder builder(ResourceLocation name) {
        return new CreativeModeTabBuilder(name);
    }

    public static SortedCreativeModeTab sorted(ItemGroup tab) {
        if (SortedCreativeModeTab.class.isAssignableFrom(tab.getClass())) {
            throw new IllegalStateException("Tab is already sorted!");
        }
        return new SortedCreativeModeTab(tab, tab.func_78021_a(), tab.func_200300_c());
    }

    public CreativeModeTabBuilder setIcon(Supplier<ItemStack> icon) {
        this.icon = icon;
        return this;
    }

    public CreativeModeTabBuilder setItems(Consumer<List<ItemStack>> stacksForDisplay) {
        this.stacksForDisplay = (itemStacks, creativeModeTab) -> stacksForDisplay.accept((List<ItemStack>)itemStacks);
        return this;
    }

    public CreativeModeTabBuilder setItems(BiConsumer<List<ItemStack>, ItemGroup> stacksForDisplay) {
        this.stacksForDisplay = stacksForDisplay;
        return this;
    }

    public ItemGroup build() {
        return CreativeModeTabBuilder.buildImpl(this.name, this.icon, this.stacksForDisplay);
    }

    public static class SortedCreativeModeTab
    extends ItemGroup {
        private final ItemGroup parent;
        private final List<Supplier<? extends Item>> orderedItems;
        private final Supplier<Map<Item, Integer>> indexedItems;

        private SortedCreativeModeTab(ItemGroup parent, int index, String label) {
            super(index, label);
            this.parent = parent;
            this.orderedItems = new ArrayList<Supplier<? extends Item>>();
            this.indexedItems = Suppliers.memoize(this::indexItems);
        }

        private Map<Item, Integer> indexItems() {
            HashMap<Item, Integer> indexMap = new HashMap<Item, Integer>();
            for (int i = 0; i < this.orderedItems.size(); ++i) {
                indexMap.put(this.orderedItems.get(i).get(), i);
            }
            return indexMap;
        }

        private int getIndex(Item item) {
            Map<Item, Integer> indexes = this.indexedItems.get();
            return indexes.containsKey(item) ? indexes.get(item).intValue() : indexes.size();
        }

        public ItemStack func_78016_d() {
            return this.parent.func_78016_d();
        }

        public void func_78018_a(NonNullList<ItemStack> items) {
            super.func_78018_a(items);
            items.sort((stack1, stack2) -> {
                int index1 = this.getIndex(stack1.func_77973_b());
                int index2 = this.getIndex(stack2.func_77973_b());
                if (this.indexedItems.get().containsKey(stack1.func_77973_b()) || this.indexedItems.get().containsKey(stack2.func_77973_b())) {
                    return Integer.compare(index1, index2);
                }
                return 1 + Registry.field_212630_s.func_177774_c((Object)stack1.func_77973_b()).compareTo(Registry.field_212630_s.func_177774_c((Object)stack2.func_77973_b()));
            });
        }

        public List<Supplier<? extends Item>> getOrderedItems() {
            return this.orderedItems;
        }
    }
}

