/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.api.client.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.ReloadListener;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;

public class PollinatedSpriteUploader
extends ReloadListener<AtlasTexture.SheetData>
implements AutoCloseable {
    private final AtlasTexture textureAtlas;
    private final String prefix;
    private final Set<ResourceLocation> registeredSprites;
    private final Set<Supplier<Collection<ResourceLocation>>> registeredSpriteSuppliers;
    private int mipmapLevels;

    public PollinatedSpriteUploader(TextureManager textureManager, ResourceLocation textureLocation, String prefix) {
        this.prefix = prefix;
        this.textureAtlas = new AtlasTexture(textureLocation);
        this.registeredSprites = new HashSet<ResourceLocation>();
        this.registeredSpriteSuppliers = new HashSet<Supplier<Collection<ResourceLocation>>>();
        this.mipmapLevels = 0;
        textureManager.func_229263_a_(this.textureAtlas.func_229223_g_(), (Texture)this.textureAtlas);
    }

    public void registerSprite(ResourceLocation location) {
        this.registeredSprites.add(location);
    }

    public void registerSpriteSupplier(Supplier<Collection<ResourceLocation>> supplier) {
        this.registeredSpriteSuppliers.add(supplier);
    }

    private Stream<ResourceLocation> getResourceLocations() {
        HashSet<ResourceLocation> locations = new HashSet<ResourceLocation>(this.registeredSprites);
        this.registeredSpriteSuppliers.stream().map(Supplier::get).forEach(locations::addAll);
        return Collections.unmodifiableSet(locations).stream();
    }

    public TextureAtlasSprite getSprite(ResourceLocation location) {
        return this.textureAtlas.func_195424_a(this.resolveLocation(location));
    }

    private ResourceLocation resolveLocation(ResourceLocation location) {
        return new ResourceLocation(location.func_110624_b(), this.prefix + "/" + location.func_110623_a());
    }

    protected AtlasTexture.SheetData prepare(IResourceManager resourceManager, IProfiler profiler) {
        profiler.func_219894_a();
        profiler.func_76320_a("stitching");
        AtlasTexture.SheetData atlastexture$sheetdata = this.textureAtlas.func_229220_a_(resourceManager, this.getResourceLocations().map(this::resolveLocation), profiler, this.mipmapLevels);
        profiler.func_76319_b();
        profiler.func_219897_b();
        return atlastexture$sheetdata;
    }

    protected void apply(AtlasTexture.SheetData object, IResourceManager resourceManager, IProfiler profiler) {
        profiler.func_219894_a();
        profiler.func_76320_a("upload");
        this.textureAtlas.func_215260_a(object);
        profiler.func_76319_b();
        profiler.func_219897_b();
    }

    @Override
    public void close() {
        this.textureAtlas.func_195419_g();
    }

    public int getMipmapLevels() {
        return this.mipmapLevels;
    }

    public void setMipmapLevels(int mipmapLevels) {
        this.mipmapLevels = Math.max(0, mipmapLevels);
    }
}

