/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.api.crafting.forge;

import com.google.gson.JsonObject;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class PollenRecipeTypesImpl {
    public static <T extends IRecipe<?>> IRecipeSerializer<T> createSerializer(BiFunction<ResourceLocation, JsonObject, T> fromJson, BiFunction<ResourceLocation, PacketBuffer, T> fromNetwork, BiConsumer<PacketBuffer, T> toNetwork) {
        return new ForgeRecipeSerializer(fromJson, fromNetwork, toNetwork);
    }

    private static class ForgeRecipeSerializer<T extends IRecipe<?>>
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<T> {
        private final BiFunction<ResourceLocation, JsonObject, T> fromJson;
        private final BiFunction<ResourceLocation, PacketBuffer, T> fromNetwork;
        private final BiConsumer<PacketBuffer, T> toNetwork;

        private ForgeRecipeSerializer(BiFunction<ResourceLocation, JsonObject, T> fromJson, BiFunction<ResourceLocation, PacketBuffer, T> fromNetwork, BiConsumer<PacketBuffer, T> toNetwork) {
            this.fromJson = fromJson;
            this.fromNetwork = fromNetwork;
            this.toNetwork = toNetwork;
        }

        public T func_199425_a_(ResourceLocation resourceLocation, JsonObject jsonObject) {
            return (T)((IRecipe)this.fromJson.apply(resourceLocation, jsonObject));
        }

        public T func_199426_a_(ResourceLocation id, PacketBuffer buf) {
            return (T)((IRecipe)this.fromNetwork.apply(id, buf));
        }

        public void func_199427_a_(PacketBuffer buf, T recipe) {
            this.toNetwork.accept(buf, (PacketBuffer)recipe);
        }
    }
}

