/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.api.datagen;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import gg.moonflower.pollen.api.crafting.PollenRecipeTypes;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.IRequirementsStrategy;
import net.minecraft.advancements.criterion.RecipeUnlockedTrigger;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import org.jetbrains.annotations.Nullable;

public class GrindstoneRecipeBuilder {
    private final Item result;
    private final int count;
    private final List<Ingredient> ingredients = new ArrayList<Ingredient>();
    private final Advancement.Builder advancement = Advancement.Builder.func_200278_a();
    private String group;
    private int experience;

    public GrindstoneRecipeBuilder(IItemProvider result, int count) {
        this.result = result.func_199767_j();
        this.count = count;
    }

    public static GrindstoneRecipeBuilder grindstone(IItemProvider result) {
        return new GrindstoneRecipeBuilder(result, 1);
    }

    public static GrindstoneRecipeBuilder grindstone(IItemProvider result, int count) {
        return new GrindstoneRecipeBuilder(result, count);
    }

    public GrindstoneRecipeBuilder requires(ITag<Item> tag) {
        return this.requires(Ingredient.func_199805_a(tag));
    }

    public GrindstoneRecipeBuilder requires(IItemProvider item) {
        return this.requires(item, 1);
    }

    public GrindstoneRecipeBuilder requires(IItemProvider item, int quantity) {
        for (int i = 0; i < quantity; ++i) {
            this.requires(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{item}));
        }
        return this;
    }

    public GrindstoneRecipeBuilder requires(Ingredient ingredient) {
        return this.requires(ingredient, 1);
    }

    public GrindstoneRecipeBuilder requires(Ingredient ingredient, int quantity) {
        for (int i = 0; i < quantity; ++i) {
            this.ingredients.add(ingredient);
        }
        return this;
    }

    public GrindstoneRecipeBuilder unlockedBy(String string, ICriterionInstance criterionTriggerInstance) {
        this.advancement.func_200275_a(string, criterionTriggerInstance);
        return this;
    }

    public GrindstoneRecipeBuilder group(String string) {
        this.group = string;
        return this;
    }

    public GrindstoneRecipeBuilder experience(int experience) {
        this.experience = experience;
        return this;
    }

    public void save(Consumer<IFinishedRecipe> consumer) {
        this.save(consumer, Registry.field_212630_s.func_177774_c((Object)this.result));
    }

    public void save(Consumer<IFinishedRecipe> consumer, String string) {
        ResourceLocation resourceLocation = Registry.field_212630_s.func_177774_c((Object)this.result);
        if (new ResourceLocation(string).equals((Object)resourceLocation)) {
            throw new IllegalStateException("Grindstone Recipe " + string + " should remove its 'save' argument");
        }
        this.save(consumer, new ResourceLocation(string));
    }

    public void save(Consumer<IFinishedRecipe> consumer, ResourceLocation resourceLocation) {
        this.ensureValid(resourceLocation);
        this.advancement.func_200272_a(new ResourceLocation("recipes/root")).func_200275_a("has_the_recipe", (ICriterionInstance)RecipeUnlockedTrigger.func_235675_a_((ResourceLocation)resourceLocation)).func_200271_a(AdvancementRewards.Builder.func_200280_c((ResourceLocation)resourceLocation)).func_200270_a(IRequirementsStrategy.field_223215_b_);
        consumer.accept(new Result(resourceLocation, this.result, this.count, this.group == null ? "" : this.group, this.experience, this.ingredients, this.advancement, new ResourceLocation(resourceLocation.func_110624_b(), "recipes/" + this.result.func_77640_w().func_200300_c() + "/" + resourceLocation.func_110623_a())));
    }

    private void ensureValid(ResourceLocation id) {
        if (this.advancement.func_200277_c().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + id);
        }
    }

    public static class Result
    implements IFinishedRecipe {
        private final ResourceLocation id;
        private final Item result;
        private final int count;
        private final String group;
        private final int experience;
        private final List<Ingredient> ingredients;
        private final Advancement.Builder advancement;
        private final ResourceLocation advancementId;

        public Result(ResourceLocation id, Item result, int count, String group, int experience, List<Ingredient> ingredients, Advancement.Builder advancement, ResourceLocation advancementId) {
            this.id = id;
            this.result = result;
            this.count = count;
            this.group = group;
            this.experience = experience;
            this.ingredients = ingredients;
            this.advancement = advancement;
            this.advancementId = advancementId;
        }

        public void func_218610_a(JsonObject json) {
            if (!this.group.isEmpty()) {
                json.addProperty("group", this.group);
            }
            if (this.experience != 0) {
                json.addProperty("experience", (Number)this.experience);
            }
            JsonArray jsonArray = new JsonArray();
            for (Ingredient ingredient : this.ingredients) {
                jsonArray.add(ingredient.func_200304_c());
            }
            json.add("ingredients", (JsonElement)jsonArray);
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("item", Registry.field_212630_s.func_177774_c((Object)this.result).toString());
            if (this.count > 1) {
                jsonObject.addProperty("count", (Number)this.count);
            }
            json.add("result", (JsonElement)jsonObject);
        }

        public IRecipeSerializer<?> func_218609_c() {
            return PollenRecipeTypes.GRINDSTONE.get();
        }

        public ResourceLocation func_200442_b() {
            return this.id;
        }

        @Nullable
        public JsonObject func_200440_c() {
            return this.advancement.func_200273_b();
        }

        @Nullable
        public ResourceLocation func_200443_d() {
            return this.advancementId;
        }
    }
}

