/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.api.datagen.provider;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import gg.moonflower.pollen.api.datagen.SoundDefinitionBuilder;
import gg.moonflower.pollen.api.util.PollinatedModContainer;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.HashSet;
import java.util.function.Consumer;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class PollinatedSoundProvider
implements IDataProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final DataGenerator generator;
    private final String domain;

    public PollinatedSoundProvider(DataGenerator generator, PollinatedModContainer container) {
        this.generator = generator;
        this.domain = container.getId();
    }

    protected abstract void registerSounds(Consumer<SoundDefinitionBuilder> var1);

    public void func_200398_a(DirectoryCache cache) {
        Path path = this.generator.func_200391_b().resolve("assets/" + this.domain + "/sounds.json");
        HashSet sounds = new HashSet();
        Consumer<SoundDefinitionBuilder> registry = sound -> {
            if (!sounds.add(sound)) {
                throw new IllegalStateException("Duplicate sound " + sound.getSoundId());
            }
        };
        this.registerSounds(registry);
        JsonObject json = new JsonObject();
        sounds.stream().sorted(Comparator.comparing(SoundDefinitionBuilder::getSoundId)).forEachOrdered(definition -> json.add(definition.getSoundId(), (JsonElement)definition.toJson()));
        try {
            IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)json, (Path)path);
        }
        catch (IOException e) {
            LOGGER.error("Couldn't save {}", (Object)path, (Object)e);
        }
    }

    public String func_200397_b() {
        return "Sounds";
    }
}

