/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.api.datagen.provider.model;

import com.google.gson.JsonElement;
import gg.moonflower.pollen.api.datagen.provider.model.PollinatedModelGenerator;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.WallHeight;
import net.minecraft.data.BlockModelDefinition;
import net.minecraft.data.BlockModelFields;
import net.minecraft.data.BlockModelProvider;
import net.minecraft.data.BlockModelWriter;
import net.minecraft.data.BlockStateVariantBuilder;
import net.minecraft.data.FinishedMultiPartBlockState;
import net.minecraft.data.FinishedVariantBlockState;
import net.minecraft.data.IFinishedBlockState;
import net.minecraft.data.IMultiPartPredicateBuilder;
import net.minecraft.data.ModelTextures;
import net.minecraft.data.ModelsResourceUtil;
import net.minecraft.data.ModelsUtil;
import net.minecraft.data.StockModelShapes;
import net.minecraft.data.StockTextureAliases;
import net.minecraft.data.TexturedModel;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.properties.AttachFace;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.DoorHingeSide;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.state.properties.Half;
import net.minecraft.state.properties.SlabType;
import net.minecraft.state.properties.StairsShape;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public abstract class PollinatedBlockModelGenerator
implements PollinatedModelGenerator {
    private final Consumer<IFinishedBlockState> blockStateOutput;
    private final BiConsumer<ResourceLocation, Supplier<JsonElement>> modelOutput;
    private final Consumer<Item> skippedAutoModelsOutput;

    public PollinatedBlockModelGenerator(Consumer<IFinishedBlockState> blockStateOutput, BiConsumer<ResourceLocation, Supplier<JsonElement>> modelOutput, Consumer<Item> skippedAutoModelsOutput) {
        this.blockStateOutput = blockStateOutput;
        this.modelOutput = modelOutput;
        this.skippedAutoModelsOutput = skippedAutoModelsOutput;
    }

    public Consumer<IFinishedBlockState> getBlockStateOutput() {
        return this.blockStateOutput;
    }

    public BiConsumer<ResourceLocation, Supplier<JsonElement>> getModelOutput() {
        return this.modelOutput;
    }

    public Consumer<Item> getSkippedAutoModelsOutput() {
        return this.skippedAutoModelsOutput;
    }

    protected void skipAutoItemBlock(Block block) {
        this.skippedAutoModelsOutput.accept(block.func_199767_j());
    }

    protected void delegateItemModel(Block block, ResourceLocation delegateModelLocation) {
        this.modelOutput.accept(ModelsResourceUtil.func_240219_a_((Item)block.func_199767_j()), (Supplier<JsonElement>)new BlockModelWriter(delegateModelLocation));
    }

    protected void delegateItemModel(Item item, ResourceLocation delegateModelLocation) {
        this.modelOutput.accept(ModelsResourceUtil.func_240219_a_((Item)item), (Supplier<JsonElement>)new BlockModelWriter(delegateModelLocation));
    }

    protected void createSimpleFlatItemModel(Item flatItem) {
        StockModelShapes.field_240273_aK_.func_240234_a_(ModelsResourceUtil.func_240219_a_((Item)flatItem), ModelTextures.func_240352_b_((Item)flatItem), this.modelOutput);
    }

    protected void createSimpleFlatItemModel(Block flatBlock) {
        Item item = flatBlock.func_199767_j();
        if (item != Items.field_190931_a) {
            StockModelShapes.field_240273_aK_.func_240234_a_(ModelsResourceUtil.func_240219_a_((Item)item), ModelTextures.func_240340_B_((Block)flatBlock), this.modelOutput);
        }
    }

    protected void createSimpleFlatItemModel(Block flatBlock, String layerZeroTextureSuffix) {
        StockModelShapes.field_240273_aK_.func_240234_a_(ModelsResourceUtil.func_240219_a_((Item)flatBlock.func_199767_j()), ModelTextures.func_240376_j_((ResourceLocation)ModelTextures.func_240347_a_((Block)flatBlock, (String)layerZeroTextureSuffix)), this.modelOutput);
    }

    protected static BlockStateVariantBuilder createHorizontalFacingDispatch() {
        return BlockStateVariantBuilder.func_240133_a_((Property)BlockStateProperties.field_208157_J).func_240143_a_((Comparable)Direction.EAST, BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240201_b_, (Object)BlockModelFields.Rotation.R90)).func_240143_a_((Comparable)Direction.SOUTH, BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240201_b_, (Object)BlockModelFields.Rotation.R180)).func_240143_a_((Comparable)Direction.WEST, BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240201_b_, (Object)BlockModelFields.Rotation.R270)).func_240143_a_((Comparable)Direction.NORTH, BlockModelDefinition.func_240194_a_());
    }

    protected static BlockStateVariantBuilder createHorizontalFacingDispatchAlt() {
        return BlockStateVariantBuilder.func_240133_a_((Property)BlockStateProperties.field_208157_J).func_240143_a_((Comparable)Direction.SOUTH, BlockModelDefinition.func_240194_a_()).func_240143_a_((Comparable)Direction.WEST, BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240201_b_, (Object)BlockModelFields.Rotation.R90)).func_240143_a_((Comparable)Direction.NORTH, BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240201_b_, (Object)BlockModelFields.Rotation.R180)).func_240143_a_((Comparable)Direction.EAST, BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240201_b_, (Object)BlockModelFields.Rotation.R270));
    }

    protected static BlockStateVariantBuilder createTorchHorizontalDispatch() {
        return BlockStateVariantBuilder.func_240133_a_((Property)BlockStateProperties.field_208157_J).func_240143_a_((Comparable)Direction.EAST, BlockModelDefinition.func_240194_a_()).func_240143_a_((Comparable)Direction.SOUTH, BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240201_b_, (Object)BlockModelFields.Rotation.R90)).func_240143_a_((Comparable)Direction.WEST, BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240201_b_, (Object)BlockModelFields.Rotation.R180)).func_240143_a_((Comparable)Direction.NORTH, BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240201_b_, (Object)BlockModelFields.Rotation.R270));
    }

    protected static BlockStateVariantBuilder createFacingDispatch() {
        return BlockStateVariantBuilder.func_240133_a_((Property)BlockStateProperties.field_208155_H).func_240143_a_((Comparable)Direction.DOWN, BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240200_a_, (Object)BlockModelFields.Rotation.R90)).func_240143_a_((Comparable)Direction.UP, BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240200_a_, (Object)BlockModelFields.Rotation.R270)).func_240143_a_((Comparable)Direction.NORTH, BlockModelDefinition.func_240194_a_()).func_240143_a_((Comparable)Direction.SOUTH, BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240201_b_, (Object)BlockModelFields.Rotation.R180)).func_240143_a_((Comparable)Direction.WEST, BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240201_b_, (Object)BlockModelFields.Rotation.R270)).func_240143_a_((Comparable)Direction.EAST, BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240201_b_, (Object)BlockModelFields.Rotation.R90));
    }

    protected static FinishedVariantBlockState createRotatedVariant(Block block, ResourceLocation modelLocation) {
        return FinishedVariantBlockState.func_240121_a_((Block)block, (BlockModelDefinition[])PollinatedBlockModelGenerator.createRotatedVariants(modelLocation));
    }

    protected static BlockModelDefinition[] createRotatedVariants(ResourceLocation modelLocation) {
        return new BlockModelDefinition[]{BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)modelLocation), BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)modelLocation).func_240198_a_(BlockModelFields.field_240201_b_, (Object)BlockModelFields.Rotation.R90), BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)modelLocation).func_240198_a_(BlockModelFields.field_240201_b_, (Object)BlockModelFields.Rotation.R180), BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)modelLocation).func_240198_a_(BlockModelFields.field_240201_b_, (Object)BlockModelFields.Rotation.R270)};
    }

    protected static FinishedVariantBlockState createRotatedVariant(Block block, ResourceLocation normalModelLocation, ResourceLocation mirroredModelLocation) {
        return FinishedVariantBlockState.func_240121_a_((Block)block, (BlockModelDefinition[])new BlockModelDefinition[]{BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)normalModelLocation), BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)mirroredModelLocation), BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)normalModelLocation).func_240198_a_(BlockModelFields.field_240201_b_, (Object)BlockModelFields.Rotation.R180), BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)mirroredModelLocation).func_240198_a_(BlockModelFields.field_240201_b_, (Object)BlockModelFields.Rotation.R180)});
    }

    protected static BlockStateVariantBuilder createBooleanModelDispatch(BooleanProperty property, ResourceLocation trueModelLocation, ResourceLocation falseModelLocation) {
        return BlockStateVariantBuilder.func_240133_a_((Property)property).func_240143_a_((Comparable)Boolean.valueOf(true), BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)trueModelLocation)).func_240143_a_((Comparable)Boolean.valueOf(false), BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)falseModelLocation));
    }

    protected void createRotatedMirroredVariantBlock(Block block) {
        ResourceLocation resourceLocation = TexturedModel.field_240434_a_.func_240466_a_(block, this.modelOutput);
        ResourceLocation resourceLocation2 = TexturedModel.field_240435_b_.func_240466_a_(block, this.modelOutput);
        this.blockStateOutput.accept((IFinishedBlockState)PollinatedBlockModelGenerator.createRotatedVariant(block, resourceLocation, resourceLocation2));
    }

    protected void createRotatedVariantBlock(Block block) {
        ResourceLocation resourceLocation = TexturedModel.field_240434_a_.func_240466_a_(block, this.modelOutput);
        this.blockStateOutput.accept((IFinishedBlockState)PollinatedBlockModelGenerator.createRotatedVariant(block, resourceLocation));
    }

    protected static IFinishedBlockState createButton(Block buttonBlock, ResourceLocation unpoweredModelLocation, ResourceLocation poweredModelLocation) {
        return FinishedVariantBlockState.func_240119_a_((Block)buttonBlock).func_240125_a_((BlockStateVariantBuilder)BlockStateVariantBuilder.func_240133_a_((Property)BlockStateProperties.field_208194_u).func_240143_a_((Comparable)Boolean.valueOf(false), BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)unpoweredModelLocation)).func_240143_a_((Comparable)Boolean.valueOf(true), BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)poweredModelLocation))).func_240125_a_((BlockStateVariantBuilder)BlockStateVariantBuilder.func_240134_a_((Property)BlockStateProperties.field_208158_K, (Property)BlockStateProperties.field_208157_J).func_240149_a_((Comparable)AttachFace.FLOOR, (Comparable)Direction.EAST, BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240201_b_, (Object)BlockModelFields.Rotation.R90)).func_240149_a_((Comparable)AttachFace.FLOOR, (Comparable)Direction.WEST, BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240201_b_, (Object)BlockModelFields.Rotation.R270)).func_240149_a_((Comparable)AttachFace.FLOOR, (Comparable)Direction.SOUTH, BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240201_b_, (Object)BlockModelFields.Rotation.R180)).func_240149_a_((Comparable)AttachFace.FLOOR, (Comparable)Direction.NORTH, BlockModelDefinition.func_240194_a_()).func_240149_a_((Comparable)AttachFace.WALL, (Comparable)Direction.EAST, BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240201_b_, (Object)BlockModelFields.Rotation.R90).func_240198_a_(BlockModelFields.field_240200_a_, (Object)BlockModelFields.Rotation.R90).func_240198_a_(BlockModelFields.field_240203_d_, (Object)true)).func_240149_a_((Comparable)AttachFace.WALL, (Comparable)Direction.WEST, BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240201_b_, (Object)BlockModelFields.Rotation.R270).func_240198_a_(BlockModelFields.field_240200_a_, (Object)BlockModelFields.Rotation.R90).func_240198_a_(BlockModelFields.field_240203_d_, (Object)true)).func_240149_a_((Comparable)AttachFace.WALL, (Comparable)Direction.SOUTH, BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240201_b_, (Object)BlockModelFields.Rotation.R180).func_240198_a_(BlockModelFields.field_240200_a_, (Object)BlockModelFields.Rotation.R90).func_240198_a_(BlockModelFields.field_240203_d_, (Object)true)).func_240149_a_((Comparable)AttachFace.WALL, (Comparable)Direction.NORTH, BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240200_a_, (Object)BlockModelFields.Rotation.R90).func_240198_a_(BlockModelFields.field_240203_d_, (Object)true)).func_240149_a_((Comparable)AttachFace.CEILING, (Comparable)Direction.EAST, BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240201_b_, (Object)BlockModelFields.Rotation.R270).func_240198_a_(BlockModelFields.field_240200_a_, (Object)BlockModelFields.Rotation.R180)).func_240149_a_((Comparable)AttachFace.CEILING, (Comparable)Direction.WEST, BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240201_b_, (Object)BlockModelFields.Rotation.R90).func_240198_a_(BlockModelFields.field_240200_a_, (Object)BlockModelFields.Rotation.R180)).func_240149_a_((Comparable)AttachFace.CEILING, (Comparable)Direction.SOUTH, BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240200_a_, (Object)BlockModelFields.Rotation.R180)).func_240149_a_((Comparable)AttachFace.CEILING, (Comparable)Direction.NORTH, BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240201_b_, (Object)BlockModelFields.Rotation.R180).func_240198_a_(BlockModelFields.field_240200_a_, (Object)BlockModelFields.Rotation.R180)));
    }

    protected static BlockStateVariantBuilder.Four<Direction, DoubleBlockHalf, DoorHingeSide, Boolean> configureDoorHalf(BlockStateVariantBuilder.Four<Direction, DoubleBlockHalf, DoorHingeSide, Boolean> doorProperties, DoubleBlockHalf doorHalf, ResourceLocation doorModelLocation, ResourceLocation doorRightHingeModelLocation) {
        return doorProperties.func_240170_a_((Comparable)Direction.EAST, (Comparable)doorHalf, (Comparable)DoorHingeSide.LEFT, (Comparable)Boolean.valueOf(false), BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)doorModelLocation)).func_240170_a_((Comparable)Direction.SOUTH, (Comparable)doorHalf, (Comparable)DoorHingeSide.LEFT, (Comparable)Boolean.valueOf(false), BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)doorModelLocation).func_240198_a_(BlockModelFields.field_240201_b_, (Object)BlockModelFields.Rotation.R90)).func_240170_a_((Comparable)Direction.WEST, (Comparable)doorHalf, (Comparable)DoorHingeSide.LEFT, (Comparable)Boolean.valueOf(false), BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)doorModelLocation).func_240198_a_(BlockModelFields.field_240201_b_, (Object)BlockModelFields.Rotation.R180)).func_240170_a_((Comparable)Direction.NORTH, (Comparable)doorHalf, (Comparable)DoorHingeSide.LEFT, (Comparable)Boolean.valueOf(false), BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)doorModelLocation).func_240198_a_(BlockModelFields.field_240201_b_, (Object)BlockModelFields.Rotation.R270)).func_240170_a_((Comparable)Direction.EAST, (Comparable)doorHalf, (Comparable)DoorHingeSide.RIGHT, (Comparable)Boolean.valueOf(false), BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)doorRightHingeModelLocation)).func_240170_a_((Comparable)Direction.SOUTH, (Comparable)doorHalf, (Comparable)DoorHingeSide.RIGHT, (Comparable)Boolean.valueOf(false), BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)doorRightHingeModelLocation).func_240198_a_(BlockModelFields.field_240201_b_, (Object)BlockModelFields.Rotation.R90)).func_240170_a_((Comparable)Direction.WEST, (Comparable)doorHalf, (Comparable)DoorHingeSide.RIGHT, (Comparable)Boolean.valueOf(false), BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)doorRightHingeModelLocation).func_240198_a_(BlockModelFields.field_240201_b_, (Object)BlockModelFields.Rotation.R180)).func_240170_a_((Comparable)Direction.NORTH, (Comparable)doorHalf, (Comparable)DoorHingeSide.RIGHT, (Comparable)Boolean.valueOf(false), BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)doorRightHingeModelLocation).func_240198_a_(BlockModelFields.field_240201_b_, (Object)BlockModelFields.Rotation.R270)).func_240170_a_((Comparable)Direction.EAST, (Comparable)doorHalf, (Comparable)DoorHingeSide.LEFT, (Comparable)Boolean.valueOf(true), BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)doorRightHingeModelLocation).func_240198_a_(BlockModelFields.field_240201_b_, (Object)BlockModelFields.Rotation.R90)).func_240170_a_((Comparable)Direction.SOUTH, (Comparable)doorHalf, (Comparable)DoorHingeSide.LEFT, (Comparable)Boolean.valueOf(true), BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)doorRightHingeModelLocation).func_240198_a_(BlockModelFields.field_240201_b_, (Object)BlockModelFields.Rotation.R180)).func_240170_a_((Comparable)Direction.WEST, (Comparable)doorHalf, (Comparable)DoorHingeSide.LEFT, (Comparable)Boolean.valueOf(true), BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)doorRightHingeModelLocation).func_240198_a_(BlockModelFields.field_240201_b_, (Object)BlockModelFields.Rotation.R270)).func_240170_a_((Comparable)Direction.NORTH, (Comparable)doorHalf, (Comparable)DoorHingeSide.LEFT, (Comparable)Boolean.valueOf(true), BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)doorRightHingeModelLocation)).func_240170_a_((Comparable)Direction.EAST, (Comparable)doorHalf, (Comparable)DoorHingeSide.RIGHT, (Comparable)Boolean.valueOf(true), BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)doorModelLocation).func_240198_a_(BlockModelFields.field_240201_b_, (Object)BlockModelFields.Rotation.R270)).func_240170_a_((Comparable)Direction.SOUTH, (Comparable)doorHalf, (Comparable)DoorHingeSide.RIGHT, (Comparable)Boolean.valueOf(true), BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)doorModelLocation)).func_240170_a_((Comparable)Direction.WEST, (Comparable)doorHalf, (Comparable)DoorHingeSide.RIGHT, (Comparable)Boolean.valueOf(true), BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)doorModelLocation).func_240198_a_(BlockModelFields.field_240201_b_, (Object)BlockModelFields.Rotation.R90)).func_240170_a_((Comparable)Direction.NORTH, (Comparable)doorHalf, (Comparable)DoorHingeSide.RIGHT, (Comparable)Boolean.valueOf(true), BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)doorModelLocation).func_240198_a_(BlockModelFields.field_240201_b_, (Object)BlockModelFields.Rotation.R180));
    }

    protected static IFinishedBlockState createDoor(Block doorBlock, ResourceLocation bottomHalfModelLocation, ResourceLocation bottomHalfRightHingeModelLocation, ResourceLocation topHalfModelLocation, ResourceLocation topHalfRightHingeModelLocation) {
        return FinishedVariantBlockState.func_240119_a_((Block)doorBlock).func_240125_a_(PollinatedBlockModelGenerator.configureDoorHalf(PollinatedBlockModelGenerator.configureDoorHalf((BlockStateVariantBuilder.Four<Direction, DoubleBlockHalf, DoorHingeSide, Boolean>)BlockStateVariantBuilder.func_240136_a_((Property)BlockStateProperties.field_208157_J, (Property)BlockStateProperties.field_208163_P, (Property)BlockStateProperties.field_208142_aq, (Property)BlockStateProperties.field_208193_t), DoubleBlockHalf.LOWER, bottomHalfModelLocation, bottomHalfRightHingeModelLocation), DoubleBlockHalf.UPPER, topHalfModelLocation, topHalfRightHingeModelLocation));
    }

    protected static IFinishedBlockState createFence(Block fenceBlock, ResourceLocation fencePostModelLocation, ResourceLocation fenceSideModelLocation) {
        return FinishedMultiPartBlockState.func_240106_a_((Block)fenceBlock).func_240111_a_(BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)fencePostModelLocation)).func_240108_a_((IMultiPartPredicateBuilder)IMultiPartPredicateBuilder.func_240089_a_().func_240098_a_((Property)BlockStateProperties.field_208151_D, (Comparable)Boolean.valueOf(true)), BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)fenceSideModelLocation).func_240198_a_(BlockModelFields.field_240203_d_, (Object)true)).func_240108_a_((IMultiPartPredicateBuilder)IMultiPartPredicateBuilder.func_240089_a_().func_240098_a_((Property)BlockStateProperties.field_208152_E, (Comparable)Boolean.valueOf(true)), BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)fenceSideModelLocation).func_240198_a_(BlockModelFields.field_240201_b_, (Object)BlockModelFields.Rotation.R90).func_240198_a_(BlockModelFields.field_240203_d_, (Object)true)).func_240108_a_((IMultiPartPredicateBuilder)IMultiPartPredicateBuilder.func_240089_a_().func_240098_a_((Property)BlockStateProperties.field_208153_F, (Comparable)Boolean.valueOf(true)), BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)fenceSideModelLocation).func_240198_a_(BlockModelFields.field_240201_b_, (Object)BlockModelFields.Rotation.R180).func_240198_a_(BlockModelFields.field_240203_d_, (Object)true)).func_240108_a_((IMultiPartPredicateBuilder)IMultiPartPredicateBuilder.func_240089_a_().func_240098_a_((Property)BlockStateProperties.field_208154_G, (Comparable)Boolean.valueOf(true)), BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)fenceSideModelLocation).func_240198_a_(BlockModelFields.field_240201_b_, (Object)BlockModelFields.Rotation.R270).func_240198_a_(BlockModelFields.field_240203_d_, (Object)true));
    }

    protected static IFinishedBlockState createWall(Block wallBlock, ResourceLocation postModelLocation, ResourceLocation lowSideModelLocation, ResourceLocation tallSideModelLocation) {
        return FinishedMultiPartBlockState.func_240106_a_((Block)wallBlock).func_240108_a_((IMultiPartPredicateBuilder)IMultiPartPredicateBuilder.func_240089_a_().func_240098_a_((Property)BlockStateProperties.field_208149_B, (Comparable)Boolean.valueOf(true)), BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)postModelLocation)).func_240108_a_((IMultiPartPredicateBuilder)IMultiPartPredicateBuilder.func_240089_a_().func_240098_a_((Property)BlockStateProperties.field_235909_T_, (Comparable)WallHeight.LOW), BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)lowSideModelLocation).func_240198_a_(BlockModelFields.field_240203_d_, (Object)true)).func_240108_a_((IMultiPartPredicateBuilder)IMultiPartPredicateBuilder.func_240089_a_().func_240098_a_((Property)BlockStateProperties.field_235908_S_, (Comparable)WallHeight.LOW), BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)lowSideModelLocation).func_240198_a_(BlockModelFields.field_240201_b_, (Object)BlockModelFields.Rotation.R90).func_240198_a_(BlockModelFields.field_240203_d_, (Object)true)).func_240108_a_((IMultiPartPredicateBuilder)IMultiPartPredicateBuilder.func_240089_a_().func_240098_a_((Property)BlockStateProperties.field_235910_U_, (Comparable)WallHeight.LOW), BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)lowSideModelLocation).func_240198_a_(BlockModelFields.field_240201_b_, (Object)BlockModelFields.Rotation.R180).func_240198_a_(BlockModelFields.field_240203_d_, (Object)true)).func_240108_a_((IMultiPartPredicateBuilder)IMultiPartPredicateBuilder.func_240089_a_().func_240098_a_((Property)BlockStateProperties.field_235911_V_, (Comparable)WallHeight.LOW), BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)lowSideModelLocation).func_240198_a_(BlockModelFields.field_240201_b_, (Object)BlockModelFields.Rotation.R270).func_240198_a_(BlockModelFields.field_240203_d_, (Object)true)).func_240108_a_((IMultiPartPredicateBuilder)IMultiPartPredicateBuilder.func_240089_a_().func_240098_a_((Property)BlockStateProperties.field_235909_T_, (Comparable)WallHeight.TALL), BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)tallSideModelLocation).func_240198_a_(BlockModelFields.field_240203_d_, (Object)true)).func_240108_a_((IMultiPartPredicateBuilder)IMultiPartPredicateBuilder.func_240089_a_().func_240098_a_((Property)BlockStateProperties.field_235908_S_, (Comparable)WallHeight.TALL), BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)tallSideModelLocation).func_240198_a_(BlockModelFields.field_240201_b_, (Object)BlockModelFields.Rotation.R90).func_240198_a_(BlockModelFields.field_240203_d_, (Object)true)).func_240108_a_((IMultiPartPredicateBuilder)IMultiPartPredicateBuilder.func_240089_a_().func_240098_a_((Property)BlockStateProperties.field_235910_U_, (Comparable)WallHeight.TALL), BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)tallSideModelLocation).func_240198_a_(BlockModelFields.field_240201_b_, (Object)BlockModelFields.Rotation.R180).func_240198_a_(BlockModelFields.field_240203_d_, (Object)true)).func_240108_a_((IMultiPartPredicateBuilder)IMultiPartPredicateBuilder.func_240089_a_().func_240098_a_((Property)BlockStateProperties.field_235911_V_, (Comparable)WallHeight.TALL), BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)tallSideModelLocation).func_240198_a_(BlockModelFields.field_240201_b_, (Object)BlockModelFields.Rotation.R270).func_240198_a_(BlockModelFields.field_240203_d_, (Object)true));
    }

    protected static IFinishedBlockState createFenceGate(Block fenceGateBlock, ResourceLocation openModelLocation, ResourceLocation closedModelLocation, ResourceLocation wallOpenModelLocation, ResourceLocation wallClosedModelLocation) {
        return FinishedVariantBlockState.func_240120_a_((Block)fenceGateBlock, (BlockModelDefinition)BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240203_d_, (Object)true)).func_240125_a_(PollinatedBlockModelGenerator.createHorizontalFacingDispatchAlt()).func_240125_a_((BlockStateVariantBuilder)BlockStateVariantBuilder.func_240134_a_((Property)BlockStateProperties.field_208189_p, (Property)BlockStateProperties.field_208193_t).func_240149_a_((Comparable)Boolean.valueOf(false), (Comparable)Boolean.valueOf(false), BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)closedModelLocation)).func_240149_a_((Comparable)Boolean.valueOf(true), (Comparable)Boolean.valueOf(false), BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)wallClosedModelLocation)).func_240149_a_((Comparable)Boolean.valueOf(false), (Comparable)Boolean.valueOf(true), BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)openModelLocation)).func_240149_a_((Comparable)Boolean.valueOf(true), (Comparable)Boolean.valueOf(true), BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)wallOpenModelLocation)));
    }

    protected static IFinishedBlockState createStairs(Block stairsBlock, ResourceLocation innerModelLocation, ResourceLocation straightModelLocation, ResourceLocation outerModelLocation) {
        return FinishedVariantBlockState.func_240119_a_((Block)stairsBlock).func_240125_a_((BlockStateVariantBuilder)BlockStateVariantBuilder.func_240135_a_((Property)BlockStateProperties.field_208157_J, (Property)BlockStateProperties.field_208164_Q, (Property)BlockStateProperties.field_208146_au).func_240161_a_((Comparable)Direction.EAST, (Comparable)Half.BOTTOM, (Comparable)StairsShape.STRAIGHT, BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)straightModelLocation)).func_240161_a_((Comparable)Direction.WEST, (Comparable)Half.BOTTOM, (Comparable)StairsShape.STRAIGHT, BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)straightModelLocation).func_240198_a_(BlockModelFields.field_240201_b_, (Object)BlockModelFields.Rotation.R180).func_240198_a_(BlockModelFields.field_240203_d_, (Object)true)).func_240161_a_((Comparable)Direction.SOUTH, (Comparable)Half.BOTTOM, (Comparable)StairsShape.STRAIGHT, BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)straightModelLocation).func_240198_a_(BlockModelFields.field_240201_b_, (Object)BlockModelFields.Rotation.R90).func_240198_a_(BlockModelFields.field_240203_d_, (Object)true)).func_240161_a_((Comparable)Direction.NORTH, (Comparable)Half.BOTTOM, (Comparable)StairsShape.STRAIGHT, BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)straightModelLocation).func_240198_a_(BlockModelFields.field_240201_b_, (Object)BlockModelFields.Rotation.R270).func_240198_a_(BlockModelFields.field_240203_d_, (Object)true)).func_240161_a_((Comparable)Direction.EAST, (Comparable)Half.BOTTOM, (Comparable)StairsShape.OUTER_RIGHT, BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)outerModelLocation)).func_240161_a_((Comparable)Direction.WEST, (Comparable)Half.BOTTOM, (Comparable)StairsShape.OUTER_RIGHT, BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)outerModelLocation).func_240198_a_(BlockModelFields.field_240201_b_, (Object)BlockModelFields.Rotation.R180).func_240198_a_(BlockModelFields.field_240203_d_, (Object)true)).func_240161_a_((Comparable)Direction.SOUTH, (Comparable)Half.BOTTOM, (Comparable)StairsShape.OUTER_RIGHT, BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)outerModelLocation).func_240198_a_(BlockModelFields.field_240201_b_, (Object)BlockModelFields.Rotation.R90).func_240198_a_(BlockModelFields.field_240203_d_, (Object)true)).func_240161_a_((Comparable)Direction.NORTH, (Comparable)Half.BOTTOM, (Comparable)StairsShape.OUTER_RIGHT, BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)outerModelLocation).func_240198_a_(BlockModelFields.field_240201_b_, (Object)BlockModelFields.Rotation.R270).func_240198_a_(BlockModelFields.field_240203_d_, (Object)true)).func_240161_a_((Comparable)Direction.EAST, (Comparable)Half.BOTTOM, (Comparable)StairsShape.OUTER_LEFT, BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)outerModelLocation).func_240198_a_(BlockModelFields.field_240201_b_, (Object)BlockModelFields.Rotation.R270).func_240198_a_(BlockModelFields.field_240203_d_, (Object)true)).func_240161_a_((Comparable)Direction.WEST, (Comparable)Half.BOTTOM, (Comparable)StairsShape.OUTER_LEFT, BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)outerModelLocation).func_240198_a_(BlockModelFields.field_240201_b_, (Object)BlockModelFields.Rotation.R90).func_240198_a_(BlockModelFields.field_240203_d_, (Object)true)).func_240161_a_((Comparable)Direction.SOUTH, (Comparable)Half.BOTTOM, (Comparable)StairsShape.OUTER_LEFT, BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)outerModelLocation)).func_240161_a_((Comparable)Direction.NORTH, (Comparable)Half.BOTTOM, (Comparable)StairsShape.OUTER_LEFT, BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)outerModelLocation).func_240198_a_(BlockModelFields.field_240201_b_, (Object)BlockModelFields.Rotation.R180).func_240198_a_(BlockModelFields.field_240203_d_, (Object)true)).func_240161_a_((Comparable)Direction.EAST, (Comparable)Half.BOTTOM, (Comparable)StairsShape.INNER_RIGHT, BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)innerModelLocation)).func_240161_a_((Comparable)Direction.WEST, (Comparable)Half.BOTTOM, (Comparable)StairsShape.INNER_RIGHT, BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)innerModelLocation).func_240198_a_(BlockModelFields.field_240201_b_, (Object)BlockModelFields.Rotation.R180).func_240198_a_(BlockModelFields.field_240203_d_, (Object)true)).func_240161_a_((Comparable)Direction.SOUTH, (Comparable)Half.BOTTOM, (Comparable)StairsShape.INNER_RIGHT, BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)innerModelLocation).func_240198_a_(BlockModelFields.field_240201_b_, (Object)BlockModelFields.Rotation.R90).func_240198_a_(BlockModelFields.field_240203_d_, (Object)true)).func_240161_a_((Comparable)Direction.NORTH, (Comparable)Half.BOTTOM, (Comparable)StairsShape.INNER_RIGHT, BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)innerModelLocation).func_240198_a_(BlockModelFields.field_240201_b_, (Object)BlockModelFields.Rotation.R270).func_240198_a_(BlockModelFields.field_240203_d_, (Object)true)).func_240161_a_((Comparable)Direction.EAST, (Comparable)Half.BOTTOM, (Comparable)StairsShape.INNER_LEFT, BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)innerModelLocation).func_240198_a_(BlockModelFields.field_240201_b_, (Object)BlockModelFields.Rotation.R270).func_240198_a_(BlockModelFields.field_240203_d_, (Object)true)).func_240161_a_((Comparable)Direction.WEST, (Comparable)Half.BOTTOM, (Comparable)StairsShape.INNER_LEFT, BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)innerModelLocation).func_240198_a_(BlockModelFields.field_240201_b_, (Object)BlockModelFields.Rotation.R90).func_240198_a_(BlockModelFields.field_240203_d_, (Object)true)).func_240161_a_((Comparable)Direction.SOUTH, (Comparable)Half.BOTTOM, (Comparable)StairsShape.INNER_LEFT, BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)innerModelLocation)).func_240161_a_((Comparable)Direction.NORTH, (Comparable)Half.BOTTOM, (Comparable)StairsShape.INNER_LEFT, BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)innerModelLocation).func_240198_a_(BlockModelFields.field_240201_b_, (Object)BlockModelFields.Rotation.R180).func_240198_a_(BlockModelFields.field_240203_d_, (Object)true)).func_240161_a_((Comparable)Direction.EAST, (Comparable)Half.TOP, (Comparable)StairsShape.STRAIGHT, BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)straightModelLocation).func_240198_a_(BlockModelFields.field_240200_a_, (Object)BlockModelFields.Rotation.R180).func_240198_a_(BlockModelFields.field_240203_d_, (Object)true)).func_240161_a_((Comparable)Direction.WEST, (Comparable)Half.TOP, (Comparable)StairsShape.STRAIGHT, BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)straightModelLocation).func_240198_a_(BlockModelFields.field_240200_a_, (Object)BlockModelFields.Rotation.R180).func_240198_a_(BlockModelFields.field_240201_b_, (Object)BlockModelFields.Rotation.R180).func_240198_a_(BlockModelFields.field_240203_d_, (Object)true)).func_240161_a_((Comparable)Direction.SOUTH, (Comparable)Half.TOP, (Comparable)StairsShape.STRAIGHT, BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)straightModelLocation).func_240198_a_(BlockModelFields.field_240200_a_, (Object)BlockModelFields.Rotation.R180).func_240198_a_(BlockModelFields.field_240201_b_, (Object)BlockModelFields.Rotation.R90).func_240198_a_(BlockModelFields.field_240203_d_, (Object)true)).func_240161_a_((Comparable)Direction.NORTH, (Comparable)Half.TOP, (Comparable)StairsShape.STRAIGHT, BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)straightModelLocation).func_240198_a_(BlockModelFields.field_240200_a_, (Object)BlockModelFields.Rotation.R180).func_240198_a_(BlockModelFields.field_240201_b_, (Object)BlockModelFields.Rotation.R270).func_240198_a_(BlockModelFields.field_240203_d_, (Object)true)).func_240161_a_((Comparable)Direction.EAST, (Comparable)Half.TOP, (Comparable)StairsShape.OUTER_RIGHT, BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)outerModelLocation).func_240198_a_(BlockModelFields.field_240200_a_, (Object)BlockModelFields.Rotation.R180).func_240198_a_(BlockModelFields.field_240201_b_, (Object)BlockModelFields.Rotation.R90).func_240198_a_(BlockModelFields.field_240203_d_, (Object)true)).func_240161_a_((Comparable)Direction.WEST, (Comparable)Half.TOP, (Comparable)StairsShape.OUTER_RIGHT, BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)outerModelLocation).func_240198_a_(BlockModelFields.field_240200_a_, (Object)BlockModelFields.Rotation.R180).func_240198_a_(BlockModelFields.field_240201_b_, (Object)BlockModelFields.Rotation.R270).func_240198_a_(BlockModelFields.field_240203_d_, (Object)true)).func_240161_a_((Comparable)Direction.SOUTH, (Comparable)Half.TOP, (Comparable)StairsShape.OUTER_RIGHT, BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)outerModelLocation).func_240198_a_(BlockModelFields.field_240200_a_, (Object)BlockModelFields.Rotation.R180).func_240198_a_(BlockModelFields.field_240201_b_, (Object)BlockModelFields.Rotation.R180).func_240198_a_(BlockModelFields.field_240203_d_, (Object)true)).func_240161_a_((Comparable)Direction.NORTH, (Comparable)Half.TOP, (Comparable)StairsShape.OUTER_RIGHT, BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)outerModelLocation).func_240198_a_(BlockModelFields.field_240200_a_, (Object)BlockModelFields.Rotation.R180).func_240198_a_(BlockModelFields.field_240203_d_, (Object)true)).func_240161_a_((Comparable)Direction.EAST, (Comparable)Half.TOP, (Comparable)StairsShape.OUTER_LEFT, BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)outerModelLocation).func_240198_a_(BlockModelFields.field_240200_a_, (Object)BlockModelFields.Rotation.R180).func_240198_a_(BlockModelFields.field_240203_d_, (Object)true)).func_240161_a_((Comparable)Direction.WEST, (Comparable)Half.TOP, (Comparable)StairsShape.OUTER_LEFT, BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)outerModelLocation).func_240198_a_(BlockModelFields.field_240200_a_, (Object)BlockModelFields.Rotation.R180).func_240198_a_(BlockModelFields.field_240201_b_, (Object)BlockModelFields.Rotation.R180).func_240198_a_(BlockModelFields.field_240203_d_, (Object)true)).func_240161_a_((Comparable)Direction.SOUTH, (Comparable)Half.TOP, (Comparable)StairsShape.OUTER_LEFT, BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)outerModelLocation).func_240198_a_(BlockModelFields.field_240200_a_, (Object)BlockModelFields.Rotation.R180).func_240198_a_(BlockModelFields.field_240201_b_, (Object)BlockModelFields.Rotation.R90).func_240198_a_(BlockModelFields.field_240203_d_, (Object)true)).func_240161_a_((Comparable)Direction.NORTH, (Comparable)Half.TOP, (Comparable)StairsShape.OUTER_LEFT, BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)outerModelLocation).func_240198_a_(BlockModelFields.field_240200_a_, (Object)BlockModelFields.Rotation.R180).func_240198_a_(BlockModelFields.field_240201_b_, (Object)BlockModelFields.Rotation.R270).func_240198_a_(BlockModelFields.field_240203_d_, (Object)true)).func_240161_a_((Comparable)Direction.EAST, (Comparable)Half.TOP, (Comparable)StairsShape.INNER_RIGHT, BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)innerModelLocation).func_240198_a_(BlockModelFields.field_240200_a_, (Object)BlockModelFields.Rotation.R180).func_240198_a_(BlockModelFields.field_240201_b_, (Object)BlockModelFields.Rotation.R90).func_240198_a_(BlockModelFields.field_240203_d_, (Object)true)).func_240161_a_((Comparable)Direction.WEST, (Comparable)Half.TOP, (Comparable)StairsShape.INNER_RIGHT, BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)innerModelLocation).func_240198_a_(BlockModelFields.field_240200_a_, (Object)BlockModelFields.Rotation.R180).func_240198_a_(BlockModelFields.field_240201_b_, (Object)BlockModelFields.Rotation.R270).func_240198_a_(BlockModelFields.field_240203_d_, (Object)true)).func_240161_a_((Comparable)Direction.SOUTH, (Comparable)Half.TOP, (Comparable)StairsShape.INNER_RIGHT, BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)innerModelLocation).func_240198_a_(BlockModelFields.field_240200_a_, (Object)BlockModelFields.Rotation.R180).func_240198_a_(BlockModelFields.field_240201_b_, (Object)BlockModelFields.Rotation.R180).func_240198_a_(BlockModelFields.field_240203_d_, (Object)true)).func_240161_a_((Comparable)Direction.NORTH, (Comparable)Half.TOP, (Comparable)StairsShape.INNER_RIGHT, BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)innerModelLocation).func_240198_a_(BlockModelFields.field_240200_a_, (Object)BlockModelFields.Rotation.R180).func_240198_a_(BlockModelFields.field_240203_d_, (Object)true)).func_240161_a_((Comparable)Direction.EAST, (Comparable)Half.TOP, (Comparable)StairsShape.INNER_LEFT, BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)innerModelLocation).func_240198_a_(BlockModelFields.field_240200_a_, (Object)BlockModelFields.Rotation.R180).func_240198_a_(BlockModelFields.field_240203_d_, (Object)true)).func_240161_a_((Comparable)Direction.WEST, (Comparable)Half.TOP, (Comparable)StairsShape.INNER_LEFT, BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)innerModelLocation).func_240198_a_(BlockModelFields.field_240200_a_, (Object)BlockModelFields.Rotation.R180).func_240198_a_(BlockModelFields.field_240201_b_, (Object)BlockModelFields.Rotation.R180).func_240198_a_(BlockModelFields.field_240203_d_, (Object)true)).func_240161_a_((Comparable)Direction.SOUTH, (Comparable)Half.TOP, (Comparable)StairsShape.INNER_LEFT, BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)innerModelLocation).func_240198_a_(BlockModelFields.field_240200_a_, (Object)BlockModelFields.Rotation.R180).func_240198_a_(BlockModelFields.field_240201_b_, (Object)BlockModelFields.Rotation.R90).func_240198_a_(BlockModelFields.field_240203_d_, (Object)true)).func_240161_a_((Comparable)Direction.NORTH, (Comparable)Half.TOP, (Comparable)StairsShape.INNER_LEFT, BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)innerModelLocation).func_240198_a_(BlockModelFields.field_240200_a_, (Object)BlockModelFields.Rotation.R180).func_240198_a_(BlockModelFields.field_240201_b_, (Object)BlockModelFields.Rotation.R270).func_240198_a_(BlockModelFields.field_240203_d_, (Object)true)));
    }

    protected static IFinishedBlockState createOrientableTrapdoor(Block orientableTrapdoorBlock, ResourceLocation topModelLocation, ResourceLocation bottomModelLocation, ResourceLocation openModelLocation) {
        return FinishedVariantBlockState.func_240119_a_((Block)orientableTrapdoorBlock).func_240125_a_((BlockStateVariantBuilder)BlockStateVariantBuilder.func_240135_a_((Property)BlockStateProperties.field_208157_J, (Property)BlockStateProperties.field_208164_Q, (Property)BlockStateProperties.field_208193_t).func_240161_a_((Comparable)Direction.NORTH, (Comparable)Half.BOTTOM, (Comparable)Boolean.valueOf(false), BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)bottomModelLocation)).func_240161_a_((Comparable)Direction.SOUTH, (Comparable)Half.BOTTOM, (Comparable)Boolean.valueOf(false), BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)bottomModelLocation).func_240198_a_(BlockModelFields.field_240201_b_, (Object)BlockModelFields.Rotation.R180)).func_240161_a_((Comparable)Direction.EAST, (Comparable)Half.BOTTOM, (Comparable)Boolean.valueOf(false), BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)bottomModelLocation).func_240198_a_(BlockModelFields.field_240201_b_, (Object)BlockModelFields.Rotation.R90)).func_240161_a_((Comparable)Direction.WEST, (Comparable)Half.BOTTOM, (Comparable)Boolean.valueOf(false), BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)bottomModelLocation).func_240198_a_(BlockModelFields.field_240201_b_, (Object)BlockModelFields.Rotation.R270)).func_240161_a_((Comparable)Direction.NORTH, (Comparable)Half.TOP, (Comparable)Boolean.valueOf(false), BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)topModelLocation)).func_240161_a_((Comparable)Direction.SOUTH, (Comparable)Half.TOP, (Comparable)Boolean.valueOf(false), BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)topModelLocation).func_240198_a_(BlockModelFields.field_240201_b_, (Object)BlockModelFields.Rotation.R180)).func_240161_a_((Comparable)Direction.EAST, (Comparable)Half.TOP, (Comparable)Boolean.valueOf(false), BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)topModelLocation).func_240198_a_(BlockModelFields.field_240201_b_, (Object)BlockModelFields.Rotation.R90)).func_240161_a_((Comparable)Direction.WEST, (Comparable)Half.TOP, (Comparable)Boolean.valueOf(false), BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)topModelLocation).func_240198_a_(BlockModelFields.field_240201_b_, (Object)BlockModelFields.Rotation.R270)).func_240161_a_((Comparable)Direction.NORTH, (Comparable)Half.BOTTOM, (Comparable)Boolean.valueOf(true), BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)openModelLocation)).func_240161_a_((Comparable)Direction.SOUTH, (Comparable)Half.BOTTOM, (Comparable)Boolean.valueOf(true), BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)openModelLocation).func_240198_a_(BlockModelFields.field_240201_b_, (Object)BlockModelFields.Rotation.R180)).func_240161_a_((Comparable)Direction.EAST, (Comparable)Half.BOTTOM, (Comparable)Boolean.valueOf(true), BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)openModelLocation).func_240198_a_(BlockModelFields.field_240201_b_, (Object)BlockModelFields.Rotation.R90)).func_240161_a_((Comparable)Direction.WEST, (Comparable)Half.BOTTOM, (Comparable)Boolean.valueOf(true), BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)openModelLocation).func_240198_a_(BlockModelFields.field_240201_b_, (Object)BlockModelFields.Rotation.R270)).func_240161_a_((Comparable)Direction.NORTH, (Comparable)Half.TOP, (Comparable)Boolean.valueOf(true), BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)openModelLocation).func_240198_a_(BlockModelFields.field_240200_a_, (Object)BlockModelFields.Rotation.R180).func_240198_a_(BlockModelFields.field_240201_b_, (Object)BlockModelFields.Rotation.R180)).func_240161_a_((Comparable)Direction.SOUTH, (Comparable)Half.TOP, (Comparable)Boolean.valueOf(true), BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)openModelLocation).func_240198_a_(BlockModelFields.field_240200_a_, (Object)BlockModelFields.Rotation.R180).func_240198_a_(BlockModelFields.field_240201_b_, (Object)BlockModelFields.Rotation.R0)).func_240161_a_((Comparable)Direction.EAST, (Comparable)Half.TOP, (Comparable)Boolean.valueOf(true), BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)openModelLocation).func_240198_a_(BlockModelFields.field_240200_a_, (Object)BlockModelFields.Rotation.R180).func_240198_a_(BlockModelFields.field_240201_b_, (Object)BlockModelFields.Rotation.R270)).func_240161_a_((Comparable)Direction.WEST, (Comparable)Half.TOP, (Comparable)Boolean.valueOf(true), BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)openModelLocation).func_240198_a_(BlockModelFields.field_240200_a_, (Object)BlockModelFields.Rotation.R180).func_240198_a_(BlockModelFields.field_240201_b_, (Object)BlockModelFields.Rotation.R90)));
    }

    protected static IFinishedBlockState createTrapdoor(Block trapdoorBlock, ResourceLocation topModelLocation, ResourceLocation bottomModelLocation, ResourceLocation openModelLocation) {
        return FinishedVariantBlockState.func_240119_a_((Block)trapdoorBlock).func_240125_a_((BlockStateVariantBuilder)BlockStateVariantBuilder.func_240135_a_((Property)BlockStateProperties.field_208157_J, (Property)BlockStateProperties.field_208164_Q, (Property)BlockStateProperties.field_208193_t).func_240161_a_((Comparable)Direction.NORTH, (Comparable)Half.BOTTOM, (Comparable)Boolean.valueOf(false), BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)bottomModelLocation)).func_240161_a_((Comparable)Direction.SOUTH, (Comparable)Half.BOTTOM, (Comparable)Boolean.valueOf(false), BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)bottomModelLocation)).func_240161_a_((Comparable)Direction.EAST, (Comparable)Half.BOTTOM, (Comparable)Boolean.valueOf(false), BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)bottomModelLocation)).func_240161_a_((Comparable)Direction.WEST, (Comparable)Half.BOTTOM, (Comparable)Boolean.valueOf(false), BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)bottomModelLocation)).func_240161_a_((Comparable)Direction.NORTH, (Comparable)Half.TOP, (Comparable)Boolean.valueOf(false), BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)topModelLocation)).func_240161_a_((Comparable)Direction.SOUTH, (Comparable)Half.TOP, (Comparable)Boolean.valueOf(false), BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)topModelLocation)).func_240161_a_((Comparable)Direction.EAST, (Comparable)Half.TOP, (Comparable)Boolean.valueOf(false), BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)topModelLocation)).func_240161_a_((Comparable)Direction.WEST, (Comparable)Half.TOP, (Comparable)Boolean.valueOf(false), BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)topModelLocation)).func_240161_a_((Comparable)Direction.NORTH, (Comparable)Half.BOTTOM, (Comparable)Boolean.valueOf(true), BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)openModelLocation)).func_240161_a_((Comparable)Direction.SOUTH, (Comparable)Half.BOTTOM, (Comparable)Boolean.valueOf(true), BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)openModelLocation).func_240198_a_(BlockModelFields.field_240201_b_, (Object)BlockModelFields.Rotation.R180)).func_240161_a_((Comparable)Direction.EAST, (Comparable)Half.BOTTOM, (Comparable)Boolean.valueOf(true), BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)openModelLocation).func_240198_a_(BlockModelFields.field_240201_b_, (Object)BlockModelFields.Rotation.R90)).func_240161_a_((Comparable)Direction.WEST, (Comparable)Half.BOTTOM, (Comparable)Boolean.valueOf(true), BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)openModelLocation).func_240198_a_(BlockModelFields.field_240201_b_, (Object)BlockModelFields.Rotation.R270)).func_240161_a_((Comparable)Direction.NORTH, (Comparable)Half.TOP, (Comparable)Boolean.valueOf(true), BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)openModelLocation)).func_240161_a_((Comparable)Direction.SOUTH, (Comparable)Half.TOP, (Comparable)Boolean.valueOf(true), BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)openModelLocation).func_240198_a_(BlockModelFields.field_240201_b_, (Object)BlockModelFields.Rotation.R180)).func_240161_a_((Comparable)Direction.EAST, (Comparable)Half.TOP, (Comparable)Boolean.valueOf(true), BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)openModelLocation).func_240198_a_(BlockModelFields.field_240201_b_, (Object)BlockModelFields.Rotation.R90)).func_240161_a_((Comparable)Direction.WEST, (Comparable)Half.TOP, (Comparable)Boolean.valueOf(true), BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)openModelLocation).func_240198_a_(BlockModelFields.field_240201_b_, (Object)BlockModelFields.Rotation.R270)));
    }

    protected static FinishedVariantBlockState createSimpleBlock(Block block, ResourceLocation modelLocation) {
        return FinishedVariantBlockState.func_240120_a_((Block)block, (BlockModelDefinition)BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)modelLocation));
    }

    protected static BlockStateVariantBuilder createRotatedPillar() {
        return BlockStateVariantBuilder.func_240133_a_((Property)BlockStateProperties.field_208148_A).func_240143_a_((Comparable)Direction.Axis.Y, BlockModelDefinition.func_240194_a_()).func_240143_a_((Comparable)Direction.Axis.Z, BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240200_a_, (Object)BlockModelFields.Rotation.R90)).func_240143_a_((Comparable)Direction.Axis.X, BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240200_a_, (Object)BlockModelFields.Rotation.R90).func_240198_a_(BlockModelFields.field_240201_b_, (Object)BlockModelFields.Rotation.R90));
    }

    protected static IFinishedBlockState createAxisAlignedPillarBlock(Block axisAlignedPillarBlock, ResourceLocation modelLocation) {
        return FinishedVariantBlockState.func_240120_a_((Block)axisAlignedPillarBlock, (BlockModelDefinition)BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)modelLocation)).func_240125_a_(PollinatedBlockModelGenerator.createRotatedPillar());
    }

    protected void createAxisAlignedPillarBlockCustomModel(Block axisAlignedPillarBlock, ResourceLocation modelLocation) {
        this.blockStateOutput.accept(PollinatedBlockModelGenerator.createAxisAlignedPillarBlock(axisAlignedPillarBlock, modelLocation));
    }

    protected void createAxisAlignedPillarBlock(Block axisAlignedPillarBlock, TexturedModel.ISupplier provider) {
        ResourceLocation resourceLocation = provider.func_240466_a_(axisAlignedPillarBlock, this.modelOutput);
        this.blockStateOutput.accept(PollinatedBlockModelGenerator.createAxisAlignedPillarBlock(axisAlignedPillarBlock, resourceLocation));
    }

    protected void createHorizontallyRotatedBlock(Block horizontallyRotatedBlock, TexturedModel.ISupplier provider) {
        ResourceLocation resourceLocation = provider.func_240466_a_(horizontallyRotatedBlock, this.modelOutput);
        this.blockStateOutput.accept((IFinishedBlockState)FinishedVariantBlockState.func_240120_a_((Block)horizontallyRotatedBlock, (BlockModelDefinition)BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)resourceLocation)).func_240125_a_(PollinatedBlockModelGenerator.createHorizontalFacingDispatch()));
    }

    protected static IFinishedBlockState createRotatedPillarWithHorizontalVariant(Block rotatedPillarBlock, ResourceLocation modelLocation, ResourceLocation horizontalModelLocation) {
        return FinishedVariantBlockState.func_240119_a_((Block)rotatedPillarBlock).func_240125_a_((BlockStateVariantBuilder)BlockStateVariantBuilder.func_240133_a_((Property)BlockStateProperties.field_208148_A).func_240143_a_((Comparable)Direction.Axis.Y, BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)modelLocation)).func_240143_a_((Comparable)Direction.Axis.Z, BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)horizontalModelLocation).func_240198_a_(BlockModelFields.field_240200_a_, (Object)BlockModelFields.Rotation.R90)).func_240143_a_((Comparable)Direction.Axis.X, BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)horizontalModelLocation).func_240198_a_(BlockModelFields.field_240200_a_, (Object)BlockModelFields.Rotation.R90).func_240198_a_(BlockModelFields.field_240201_b_, (Object)BlockModelFields.Rotation.R90)));
    }

    protected void createRotatedPillarWithHorizontalVariant(Block rotatedPillarBlock, TexturedModel.ISupplier modelProvider, TexturedModel.ISupplier horizontalModelProvider) {
        ResourceLocation resourceLocation = modelProvider.func_240466_a_(rotatedPillarBlock, this.modelOutput);
        ResourceLocation resourceLocation2 = horizontalModelProvider.func_240466_a_(rotatedPillarBlock, this.modelOutput);
        this.blockStateOutput.accept(PollinatedBlockModelGenerator.createRotatedPillarWithHorizontalVariant(rotatedPillarBlock, resourceLocation, resourceLocation2));
    }

    protected ResourceLocation createSuffixedVariant(Block block, String suffix, ModelsUtil modelTemplate, Function<ResourceLocation, ModelTextures> textureMappingGetter) {
        return modelTemplate.func_240229_a_(block, suffix, textureMappingGetter.apply(ModelTextures.func_240347_a_((Block)block, (String)suffix)), this.modelOutput);
    }

    protected static IFinishedBlockState createPressurePlate(Block pressurePlateBlock, ResourceLocation unpoweredModelLocation, ResourceLocation poweredModelLocation) {
        return FinishedVariantBlockState.func_240119_a_((Block)pressurePlateBlock).func_240125_a_(PollinatedBlockModelGenerator.createBooleanModelDispatch(BlockStateProperties.field_208194_u, poweredModelLocation, unpoweredModelLocation));
    }

    protected static IFinishedBlockState createSlab(Block slabBlock, ResourceLocation bottomHalfModelLocation, ResourceLocation topHalfModelLocation, ResourceLocation doubleModelLocation) {
        return FinishedVariantBlockState.func_240119_a_((Block)slabBlock).func_240125_a_((BlockStateVariantBuilder)BlockStateVariantBuilder.func_240133_a_((Property)BlockStateProperties.field_208145_at).func_240143_a_((Comparable)SlabType.BOTTOM, BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)bottomHalfModelLocation)).func_240143_a_((Comparable)SlabType.TOP, BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)topHalfModelLocation)).func_240143_a_((Comparable)SlabType.DOUBLE, BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)doubleModelLocation)));
    }

    protected void createTrivialCube(Block block) {
        this.createTrivialBlock(block, TexturedModel.field_240434_a_);
    }

    protected void createTrivialBlock(Block block, TexturedModel.ISupplier provider) {
        this.blockStateOutput.accept((IFinishedBlockState)PollinatedBlockModelGenerator.createSimpleBlock(block, provider.func_240466_a_(block, this.modelOutput)));
    }

    protected void createTrivialBlock(Block block, ModelTextures textureMapping, ModelsUtil modelTemplate) {
        ResourceLocation resourceLocation = modelTemplate.func_240228_a_(block, textureMapping, this.modelOutput);
        this.blockStateOutput.accept((IFinishedBlockState)PollinatedBlockModelGenerator.createSimpleBlock(block, resourceLocation));
    }

    protected BlockFamilyProvider family(Block block, TexturedModel texturedModel) {
        return new BlockFamilyProvider(texturedModel.func_240464_b_()).fullBlock(block, texturedModel.func_240457_a_());
    }

    protected BlockFamilyProvider family(Block block, TexturedModel.ISupplier provider) {
        TexturedModel texturedModel = provider.get(block);
        return new BlockFamilyProvider(texturedModel.func_240464_b_()).fullBlock(block, texturedModel.func_240457_a_());
    }

    protected BlockFamilyProvider family(Block block) {
        return this.family(block, TexturedModel.field_240434_a_);
    }

    protected BlockFamilyProvider family(ModelTextures textureMapping) {
        return new BlockFamilyProvider(textureMapping);
    }

    protected void createDoor(Block doorBlock) {
        ModelTextures textureMapping = ModelTextures.func_240382_p_((Block)doorBlock);
        ResourceLocation resourceLocation = StockModelShapes.field_240319_o_.func_240228_a_(doorBlock, textureMapping, this.modelOutput);
        ResourceLocation resourceLocation2 = StockModelShapes.field_240320_p_.func_240228_a_(doorBlock, textureMapping, this.modelOutput);
        ResourceLocation resourceLocation3 = StockModelShapes.field_240321_q_.func_240228_a_(doorBlock, textureMapping, this.modelOutput);
        ResourceLocation resourceLocation4 = StockModelShapes.field_240322_r_.func_240228_a_(doorBlock, textureMapping, this.modelOutput);
        this.createSimpleFlatItemModel(doorBlock.func_199767_j());
        this.blockStateOutput.accept(PollinatedBlockModelGenerator.createDoor(doorBlock, resourceLocation, resourceLocation2, resourceLocation3, resourceLocation4));
    }

    protected void createOrientableTrapdoor(Block orientableTrapdoorBlock) {
        ModelTextures textureMapping = ModelTextures.func_240353_b_((Block)orientableTrapdoorBlock);
        ResourceLocation resourceLocation = StockModelShapes.field_240251_P_.func_240228_a_(orientableTrapdoorBlock, textureMapping, this.modelOutput);
        ResourceLocation resourceLocation2 = StockModelShapes.field_240252_Q_.func_240228_a_(orientableTrapdoorBlock, textureMapping, this.modelOutput);
        ResourceLocation resourceLocation3 = StockModelShapes.field_240253_R_.func_240228_a_(orientableTrapdoorBlock, textureMapping, this.modelOutput);
        this.blockStateOutput.accept(PollinatedBlockModelGenerator.createOrientableTrapdoor(orientableTrapdoorBlock, resourceLocation, resourceLocation2, resourceLocation3));
        this.delegateItemModel(orientableTrapdoorBlock, resourceLocation2);
    }

    protected void createTrapdoor(Block trapdoorBlock) {
        ModelTextures textureMapping = ModelTextures.func_240353_b_((Block)trapdoorBlock);
        ResourceLocation resourceLocation = StockModelShapes.field_240248_M_.func_240228_a_(trapdoorBlock, textureMapping, this.modelOutput);
        ResourceLocation resourceLocation2 = StockModelShapes.field_240249_N_.func_240228_a_(trapdoorBlock, textureMapping, this.modelOutput);
        ResourceLocation resourceLocation3 = StockModelShapes.field_240250_O_.func_240228_a_(trapdoorBlock, textureMapping, this.modelOutput);
        this.blockStateOutput.accept(PollinatedBlockModelGenerator.createTrapdoor(trapdoorBlock, resourceLocation, resourceLocation2, resourceLocation3));
        this.delegateItemModel(trapdoorBlock, resourceLocation2);
    }

    protected WoodProvider woodProvider(Block logBlock) {
        return new WoodProvider(ModelTextures.func_240378_l_((Block)logBlock));
    }

    protected void createNonTemplateModelBlock(Block block) {
        this.createNonTemplateModelBlock(block, block);
    }

    protected void createNonTemplateModelBlock(Block block, Block modelBlock) {
        this.blockStateOutput.accept((IFinishedBlockState)PollinatedBlockModelGenerator.createSimpleBlock(block, ModelsResourceUtil.func_240221_a_((Block)modelBlock)));
    }

    protected void createCrossBlockWithDefaultItem(Block crossBlock, BlockModelProvider.TintMode tintState) {
        this.createSimpleFlatItemModel(crossBlock);
        this.createCrossBlock(crossBlock, tintState);
    }

    protected void createCrossBlockWithDefaultItem(Block crossBlock, BlockModelProvider.TintMode tintState, ModelTextures textureMapping) {
        this.createSimpleFlatItemModel(crossBlock);
        this.createCrossBlock(crossBlock, tintState, textureMapping);
    }

    protected void createCrossBlock(Block crossBlock, BlockModelProvider.TintMode tintState) {
        ModelTextures textureMapping = ModelTextures.func_240358_c_((Block)crossBlock);
        this.createCrossBlock(crossBlock, tintState, textureMapping);
    }

    protected void createCrossBlock(Block crossBlock, BlockModelProvider.TintMode tintState, ModelTextures textureMapping) {
        ResourceLocation resourceLocation = tintState.func_240066_a_().func_240228_a_(crossBlock, textureMapping, this.modelOutput);
        this.blockStateOutput.accept((IFinishedBlockState)PollinatedBlockModelGenerator.createSimpleBlock(crossBlock, resourceLocation));
    }

    protected void createPlant(Block plantBlock, Block pottedPlantBlock, BlockModelProvider.TintMode tintState) {
        this.createCrossBlockWithDefaultItem(plantBlock, tintState);
        ModelTextures textureMapping = ModelTextures.func_240362_d_((Block)plantBlock);
        ResourceLocation resourceLocation = tintState.func_240067_b_().func_240228_a_(pottedPlantBlock, textureMapping, this.modelOutput);
        this.blockStateOutput.accept((IFinishedBlockState)PollinatedBlockModelGenerator.createSimpleBlock(pottedPlantBlock, resourceLocation));
    }

    protected void copyModel(Block sourceBlock, Block targetBlock) {
        ResourceLocation resourceLocation = ModelsResourceUtil.func_240221_a_((Block)sourceBlock);
        this.blockStateOutput.accept((IFinishedBlockState)FinishedVariantBlockState.func_240120_a_((Block)targetBlock, (BlockModelDefinition)BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)resourceLocation)));
        this.delegateItemModel(targetBlock, resourceLocation);
    }

    public class BlockFamilyProvider {
        private final ModelTextures mapping;
        @Nullable
        private ResourceLocation fullBlock;

        private BlockFamilyProvider(ModelTextures textureMapping) {
            this.mapping = textureMapping;
        }

        public BlockFamilyProvider fullBlock(Block block, ModelsUtil modelTemplate) {
            this.fullBlock = modelTemplate.func_240228_a_(block, this.mapping, PollinatedBlockModelGenerator.this.modelOutput);
            PollinatedBlockModelGenerator.this.blockStateOutput.accept(PollinatedBlockModelGenerator.createSimpleBlock(block, this.fullBlock));
            return this;
        }

        public BlockFamilyProvider fullBlock(Function<ModelTextures, ResourceLocation> function) {
            this.fullBlock = function.apply(this.mapping);
            return this;
        }

        public BlockFamilyProvider button(Block buttonBlock) {
            ResourceLocation resourceLocation = StockModelShapes.field_240316_l_.func_240228_a_(buttonBlock, this.mapping, PollinatedBlockModelGenerator.this.modelOutput);
            ResourceLocation resourceLocation2 = StockModelShapes.field_240317_m_.func_240228_a_(buttonBlock, this.mapping, PollinatedBlockModelGenerator.this.modelOutput);
            PollinatedBlockModelGenerator.this.blockStateOutput.accept(PollinatedBlockModelGenerator.createButton(buttonBlock, resourceLocation, resourceLocation2));
            ResourceLocation resourceLocation3 = StockModelShapes.field_240318_n_.func_240228_a_(buttonBlock, this.mapping, PollinatedBlockModelGenerator.this.modelOutput);
            PollinatedBlockModelGenerator.this.delegateItemModel(buttonBlock, resourceLocation3);
            return this;
        }

        public BlockFamilyProvider wall(Block wallBlock) {
            ResourceLocation resourceLocation = StockModelShapes.field_240326_v_.func_240228_a_(wallBlock, this.mapping, PollinatedBlockModelGenerator.this.modelOutput);
            ResourceLocation resourceLocation2 = StockModelShapes.field_240327_w_.func_240228_a_(wallBlock, this.mapping, PollinatedBlockModelGenerator.this.modelOutput);
            ResourceLocation resourceLocation3 = StockModelShapes.field_240328_x_.func_240228_a_(wallBlock, this.mapping, PollinatedBlockModelGenerator.this.modelOutput);
            PollinatedBlockModelGenerator.this.blockStateOutput.accept(PollinatedBlockModelGenerator.createWall(wallBlock, resourceLocation, resourceLocation2, resourceLocation3));
            ResourceLocation resourceLocation4 = StockModelShapes.field_240329_y_.func_240228_a_(wallBlock, this.mapping, PollinatedBlockModelGenerator.this.modelOutput);
            PollinatedBlockModelGenerator.this.delegateItemModel(wallBlock, resourceLocation4);
            return this;
        }

        public BlockFamilyProvider fence(Block fenceBlock) {
            ResourceLocation resourceLocation = StockModelShapes.field_240323_s_.func_240228_a_(fenceBlock, this.mapping, PollinatedBlockModelGenerator.this.modelOutput);
            ResourceLocation resourceLocation2 = StockModelShapes.field_240324_t_.func_240228_a_(fenceBlock, this.mapping, PollinatedBlockModelGenerator.this.modelOutput);
            PollinatedBlockModelGenerator.this.blockStateOutput.accept(PollinatedBlockModelGenerator.createFence(fenceBlock, resourceLocation, resourceLocation2));
            ResourceLocation resourceLocation3 = StockModelShapes.field_240325_u_.func_240228_a_(fenceBlock, this.mapping, PollinatedBlockModelGenerator.this.modelOutput);
            PollinatedBlockModelGenerator.this.delegateItemModel(fenceBlock, resourceLocation3);
            return this;
        }

        public BlockFamilyProvider fenceGate(Block fenceGateBlock) {
            ResourceLocation resourceLocation = StockModelShapes.field_240236_A_.func_240228_a_(fenceGateBlock, this.mapping, PollinatedBlockModelGenerator.this.modelOutput);
            ResourceLocation resourceLocation2 = StockModelShapes.field_240330_z_.func_240228_a_(fenceGateBlock, this.mapping, PollinatedBlockModelGenerator.this.modelOutput);
            ResourceLocation resourceLocation3 = StockModelShapes.field_240238_C_.func_240228_a_(fenceGateBlock, this.mapping, PollinatedBlockModelGenerator.this.modelOutput);
            ResourceLocation resourceLocation4 = StockModelShapes.field_240237_B_.func_240228_a_(fenceGateBlock, this.mapping, PollinatedBlockModelGenerator.this.modelOutput);
            PollinatedBlockModelGenerator.this.blockStateOutput.accept(PollinatedBlockModelGenerator.createFenceGate(fenceGateBlock, resourceLocation, resourceLocation2, resourceLocation3, resourceLocation4));
            return this;
        }

        public BlockFamilyProvider pressurePlate(Block pressurePlateBlock) {
            ResourceLocation resourceLocation = StockModelShapes.field_240239_D_.func_240228_a_(pressurePlateBlock, this.mapping, PollinatedBlockModelGenerator.this.modelOutput);
            ResourceLocation resourceLocation2 = StockModelShapes.field_240240_E_.func_240228_a_(pressurePlateBlock, this.mapping, PollinatedBlockModelGenerator.this.modelOutput);
            PollinatedBlockModelGenerator.this.blockStateOutput.accept(PollinatedBlockModelGenerator.createPressurePlate(pressurePlateBlock, resourceLocation, resourceLocation2));
            return this;
        }

        public BlockFamilyProvider sign(Block block, Block block2) {
            ResourceLocation resourceLocation = StockModelShapes.field_240241_F_.func_240228_a_(block, this.mapping, PollinatedBlockModelGenerator.this.modelOutput);
            PollinatedBlockModelGenerator.this.blockStateOutput.accept(PollinatedBlockModelGenerator.createSimpleBlock(block, resourceLocation));
            PollinatedBlockModelGenerator.this.blockStateOutput.accept(PollinatedBlockModelGenerator.createSimpleBlock(block2, resourceLocation));
            PollinatedBlockModelGenerator.this.createSimpleFlatItemModel(block.func_199767_j());
            PollinatedBlockModelGenerator.this.skipAutoItemBlock(block2);
            return this;
        }

        public BlockFamilyProvider slab(Block slabBlock) {
            if (this.fullBlock == null) {
                throw new IllegalStateException("Full block not generated yet");
            }
            ResourceLocation resourceLocation = StockModelShapes.field_240242_G_.func_240228_a_(slabBlock, this.mapping, PollinatedBlockModelGenerator.this.modelOutput);
            ResourceLocation resourceLocation2 = StockModelShapes.field_240243_H_.func_240228_a_(slabBlock, this.mapping, PollinatedBlockModelGenerator.this.modelOutput);
            PollinatedBlockModelGenerator.this.blockStateOutput.accept(PollinatedBlockModelGenerator.createSlab(slabBlock, resourceLocation, resourceLocation2, this.fullBlock));
            return this;
        }

        public BlockFamilyProvider stairs(Block stairsBlock) {
            ResourceLocation resourceLocation = StockModelShapes.field_240246_K_.func_240228_a_(stairsBlock, this.mapping, PollinatedBlockModelGenerator.this.modelOutput);
            ResourceLocation resourceLocation2 = StockModelShapes.field_240245_J_.func_240228_a_(stairsBlock, this.mapping, PollinatedBlockModelGenerator.this.modelOutput);
            ResourceLocation resourceLocation3 = StockModelShapes.field_240247_L_.func_240228_a_(stairsBlock, this.mapping, PollinatedBlockModelGenerator.this.modelOutput);
            PollinatedBlockModelGenerator.this.blockStateOutput.accept(PollinatedBlockModelGenerator.createStairs(stairsBlock, resourceLocation, resourceLocation2, resourceLocation3));
            return this;
        }
    }

    public class WoodProvider {
        private final ModelTextures logMapping;

        private WoodProvider(ModelTextures textureMapping) {
            this.logMapping = textureMapping;
        }

        public WoodProvider wood(Block woodBlock) {
            ModelTextures textureMapping = this.logMapping.func_240360_c_(StockTextureAliases.field_240407_d_, this.logMapping.func_240348_a_(StockTextureAliases.field_240412_i_));
            ResourceLocation resourceLocation = StockModelShapes.field_240309_e_.func_240228_a_(woodBlock, textureMapping, PollinatedBlockModelGenerator.this.modelOutput);
            PollinatedBlockModelGenerator.this.blockStateOutput.accept(PollinatedBlockModelGenerator.createAxisAlignedPillarBlock(woodBlock, resourceLocation));
            return this;
        }

        public WoodProvider log(Block logBlock) {
            ResourceLocation resourceLocation = StockModelShapes.field_240309_e_.func_240228_a_(logBlock, this.logMapping, PollinatedBlockModelGenerator.this.modelOutput);
            PollinatedBlockModelGenerator.this.blockStateOutput.accept(PollinatedBlockModelGenerator.createAxisAlignedPillarBlock(logBlock, resourceLocation));
            return this;
        }

        public WoodProvider logWithHorizontal(Block logBlock) {
            ResourceLocation resourceLocation = StockModelShapes.field_240309_e_.func_240228_a_(logBlock, this.logMapping, PollinatedBlockModelGenerator.this.modelOutput);
            ResourceLocation resourceLocation2 = StockModelShapes.field_240310_f_.func_240228_a_(logBlock, this.logMapping, PollinatedBlockModelGenerator.this.modelOutput);
            PollinatedBlockModelGenerator.this.blockStateOutput.accept(PollinatedBlockModelGenerator.createRotatedPillarWithHorizontalVariant(logBlock, resourceLocation, resourceLocation2));
            return this;
        }
    }

    public class BlockEntityModelGenerator {
        private final ResourceLocation baseModel;

        public BlockEntityModelGenerator(ResourceLocation resourceLocation, Block block) {
            this.baseModel = StockModelShapes.field_240241_F_.func_240234_a_(resourceLocation, ModelTextures.func_240383_q_((Block)block), PollinatedBlockModelGenerator.this.modelOutput);
        }

        public BlockEntityModelGenerator create(Block ... blocks) {
            for (Block block : blocks) {
                PollinatedBlockModelGenerator.this.blockStateOutput.accept(PollinatedBlockModelGenerator.createSimpleBlock(block, this.baseModel));
            }
            return this;
        }

        public BlockEntityModelGenerator createWithoutBlockItem(Block ... blocks) {
            for (Block block : blocks) {
                PollinatedBlockModelGenerator.this.skipAutoItemBlock(block);
            }
            return this.create(blocks);
        }

        public BlockEntityModelGenerator createWithCustomBlockItemModel(ModelsUtil modelTemplate, Block ... blocks) {
            for (Block block : blocks) {
                modelTemplate.func_240234_a_(ModelsResourceUtil.func_240219_a_((Item)block.func_199767_j()), ModelTextures.func_240383_q_((Block)block), PollinatedBlockModelGenerator.this.modelOutput);
            }
            return this.create(blocks);
        }
    }
}

