/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.api.datagen.provider.tags;

import com.google.gson.JsonObject;
import gg.moonflower.pollen.api.datagen.provider.ConditionalDataProvider;
import gg.moonflower.pollen.api.resource.condition.ConditionalTagEntry;
import gg.moonflower.pollen.api.resource.condition.PollinatedResourceConditionProvider;
import gg.moonflower.pollen.api.util.PollinatedModContainer;
import gg.moonflower.pollen.core.extensions.TagBuilderExtension;
import gg.moonflower.pollen.core.mixin.data.TagsProviderAccessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.TagsProvider;
import net.minecraft.tags.ITag;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;

public abstract class PollinatedTagsProvider<T>
extends TagsProvider<T>
implements ConditionalDataProvider {
    private final Map<ResourceLocation, List<PollinatedResourceConditionProvider>> providers = new HashMap<ResourceLocation, List<PollinatedResourceConditionProvider>>();
    private final String domain;

    public PollinatedTagsProvider(DataGenerator generator, PollinatedModContainer container, Registry<T> registry) {
        super(generator, registry);
        this.domain = container.getId();
    }

    public void addConditions(ITag.INamedTag<T> tag, PollinatedResourceConditionProvider ... providers) {
        this.addConditions(tag.func_230234_a_(), providers);
    }

    @Override
    public void addConditions(ResourceLocation id, PollinatedResourceConditionProvider ... providers) {
        if (providers.length == 0) {
            return;
        }
        this.providers.computeIfAbsent(id, __ -> new ArrayList()).addAll(Arrays.asList(providers));
    }

    @Override
    public void injectConditions(ResourceLocation id, JsonObject json) {
        if (this.providers.containsKey(id)) {
            PollinatedResourceConditionProvider.write(json, this.providers.get(id).toArray(new PollinatedResourceConditionProvider[0]));
        }
    }

    protected PollinatedTagAppender<T> tag(ITag.INamedTag<T> tag) {
        return new PollinatedTagAppender(this.func_240525_b_(tag), this.field_200435_c, this.domain);
    }

    protected ITag.Builder func_240525_b_(ITag.INamedTag<T> tag) {
        return ((TagsProviderAccessor)((Object)this)).getBuilders().computeIfAbsent(tag.func_230234_a_(), __ -> new ITag.Builder());
    }

    public static class PollinatedTagAppender<T>
    extends TagsProvider.Builder<T> {
        private final ITag.Builder builder;
        private final Registry<T> registry;
        private final String source;

        protected PollinatedTagAppender(ITag.Builder builder, Registry<T> registry, String source) {
            super(builder, registry, source);
            this.builder = builder;
            this.registry = registry;
            this.source = source;
        }

        public PollinatedTagAppender<T> add(T item) {
            return (PollinatedTagAppender)super.func_240532_a_(item);
        }

        public PollinatedTagAppender<T> addTag(ITag.INamedTag<T> tag) {
            return (PollinatedTagAppender)super.func_240531_a_(tag);
        }

        @SafeVarargs
        public final PollinatedTagAppender<T> pollenAdd(T ... toAdd) {
            return (PollinatedTagAppender)super.func_240534_a_((Object[])toAdd);
        }

        @SafeVarargs
        public final PollinatedTagAppender<T> addTag(ITag.INamedTag<T> ... values) {
            for (ITag.INamedTag<T> value : values) {
                this.addTag(value);
            }
            return this;
        }

        @SafeVarargs
        public final PollinatedTagAppender<T> add(RegistryKey<T> ... keys) {
            for (RegistryKey<T> key : keys) {
                this.builder.func_232961_a_(key.func_240901_a_(), this.source);
            }
            return this;
        }

        public PollinatedTagAppender<T> addOptional(ResourceLocation resourceLocation) {
            this.builder.func_232955_a_((ITag.ITagEntry)new ITag.OptionalItemEntry(resourceLocation), this.source);
            return this;
        }

        public PollinatedTagAppender<T> addOptionalTag(ResourceLocation resourceLocation) {
            this.builder.func_232955_a_((ITag.ITagEntry)new ITag.OptionalTagEntry(resourceLocation), this.source);
            return this;
        }

        public PollinatedTagAppender<T> replace() {
            return this.replace(true);
        }

        public PollinatedTagAppender<T> replace(boolean value) {
            ((TagBuilderExtension)this.builder).pollen_replace(value);
            return this;
        }

        private static JsonObject createConditionJson(PollinatedResourceConditionProvider[] conditions) {
            JsonObject json = new JsonObject();
            PollinatedResourceConditionProvider.write(json, conditions);
            return json;
        }

        public PollinatedTagAppender<T> addConditional(T item, PollinatedResourceConditionProvider ... conditions) {
            if (conditions.length == 0) {
                return this.add(item);
            }
            this.builder.func_232955_a_((ITag.ITagEntry)new ConditionalTagEntry((ITag.ITagEntry)new ITag.ItemEntry(this.registry.func_177774_c(item)), PollinatedTagAppender.createConditionJson(conditions)), this.source);
            return this;
        }

        public PollinatedTagAppender<T> addConditionalTag(ITag.INamedTag<T> tag, PollinatedResourceConditionProvider ... conditions) {
            if (conditions.length == 0) {
                return this.addTag(tag);
            }
            this.builder.func_232955_a_((ITag.ITagEntry)new ConditionalTagEntry((ITag.ITagEntry)new ITag.TagEntry(tag.func_230234_a_()), PollinatedTagAppender.createConditionJson(conditions)), this.source);
            return this;
        }

        public PollinatedTagAppender<T> addConditionalOptional(ResourceLocation item, PollinatedResourceConditionProvider ... conditions) {
            if (conditions.length == 0) {
                return this.addOptional(item);
            }
            this.builder.func_232955_a_((ITag.ITagEntry)new ConditionalTagEntry((ITag.ITagEntry)new ITag.OptionalItemEntry(item), PollinatedTagAppender.createConditionJson(conditions)), this.source);
            return this;
        }

        public PollinatedTagAppender<T> addConditionalOptionalTag(ResourceLocation tag, PollinatedResourceConditionProvider ... conditions) {
            if (conditions.length == 0) {
                return this.addOptionalTag(tag);
            }
            this.builder.func_232955_a_((ITag.ITagEntry)new ConditionalTagEntry((ITag.ITagEntry)new ITag.OptionalTagEntry(tag), PollinatedTagAppender.createConditionJson(conditions)), this.source);
            return this;
        }
    }
}

