/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.api.event.events.lifecycle;

import gg.moonflower.pollen.api.event.PollinatedEvent;
import gg.moonflower.pollen.api.registry.EventRegistry;
import net.minecraft.server.MinecraftServer;

public final class ServerLifecycleEvents {
    public static final PollinatedEvent<PreStart> PRE_STARTING = EventRegistry.create(PreStart.class, listeners -> server -> {
        for (PreStart listener : listeners) {
            if (listener.preStarting(server)) continue;
            return false;
        }
        return true;
    });
    public static final PollinatedEvent<Starting> STARTING = EventRegistry.create(Starting.class, listeners -> server -> {
        for (Starting listener : listeners) {
            if (listener.starting(server)) continue;
            return false;
        }
        return true;
    });
    public static final PollinatedEvent<Started> STARTED = EventRegistry.createLoop(Started.class);
    public static final PollinatedEvent<Stopping> STOPPING = EventRegistry.createLoop(Stopping.class);
    public static final PollinatedEvent<Stopped> STOPPED = EventRegistry.createLoop(Stopped.class);

    private ServerLifecycleEvents() {
    }

    @FunctionalInterface
    public static interface Starting {
        public boolean starting(MinecraftServer var1);
    }

    @FunctionalInterface
    public static interface PreStart {
        public boolean preStarting(MinecraftServer var1);
    }

    @FunctionalInterface
    public static interface Started {
        public void started(MinecraftServer var1);
    }

    @FunctionalInterface
    public static interface Stopping {
        public void stopping(MinecraftServer var1);
    }

    @FunctionalInterface
    public static interface Stopped {
        public void stopped(MinecraftServer var1);
    }
}

