/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.api.fluid;

import java.util.Random;
import net.minecraft.block.Blocks;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effects;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import org.jetbrains.annotations.Nullable;

public interface PollenFluidBehavior {
    default public boolean canDescend(PlayerEntity player) {
        return true;
    }

    default public boolean canAscend(LivingEntity entity) {
        return true;
    }

    default public boolean canSprint(PlayerEntity player) {
        return true;
    }

    default public boolean shouldEntityDrown(LivingEntity entity) {
        return !entity.field_70170_p.func_180495_p(entity.func_233580_cy_()).func_203425_a(Blocks.field_203203_C);
    }

    default public boolean canVehicleTraverse(LivingEntity entity, Entity vehicle) {
        return vehicle.func_205710_ba();
    }

    @Nullable
    default public IParticleData getDrowningParticles(LivingEntity entity) {
        return ParticleTypes.field_197612_e;
    }

    default public float getDrowningDamage(LivingEntity entity) {
        return 2.0f;
    }

    default public boolean negatesFallDamage(Entity entity) {
        return true;
    }

    default public boolean canExtinguishFire(Entity entity) {
        return true;
    }

    default public double getMotionScale(Entity entity) {
        return 0.014;
    }

    default public double getSlowDown(LivingEntity entity) {
        return entity.func_70051_ag() ? 0.9 : 0.8;
    }

    @Nullable
    default public SoundEvent getAmbientEnter(PlayerEntity player) {
        return SoundEvents.field_204326_e;
    }

    @Nullable
    default public SoundEvent getAmbientLoop(PlayerEntity player) {
        return SoundEvents.field_204323_b;
    }

    @Nullable
    default public SoundEvent getAmbientExit(PlayerEntity player) {
        return SoundEvents.field_204327_f;
    }

    default public void applyPhysics(LivingEntity entity, Vector3d travelVector, double fallSpeed, boolean falling) {
        double e = entity.func_226278_cu_();
        double f = this.getSlowDown(entity);
        float g = 0.02f;
        float h = EnchantmentHelper.func_185294_d((LivingEntity)entity);
        if (h > 3.0f) {
            h = 3.0f;
        }
        if (!entity.func_233570_aj_()) {
            h *= 0.5f;
        }
        if (h > 0.0f) {
            f += (0.546000063419342 - f) * (double)h / 3.0;
            g += (entity.func_70689_ay() - g) * h / 3.0f;
        }
        if (entity.func_70644_a(Effects.field_206827_D)) {
            f = 0.96f;
        }
        entity.func_213309_a(g, travelVector);
        entity.func_213315_a(MoverType.SELF, entity.func_213322_ci());
        Vector3d vec3 = entity.func_213322_ci();
        if (entity.field_70123_F && entity.func_70617_f_()) {
            vec3 = new Vector3d(vec3.field_72450_a, 0.2, vec3.field_72449_c);
        }
        entity.func_213317_d(vec3.func_216372_d(f, (double)0.8f, f));
        Vector3d vec32 = entity.func_233626_a_(fallSpeed, falling, entity.func_213322_ci());
        entity.func_213317_d(vec32);
        if (entity.field_70123_F && entity.func_70038_c(vec32.field_72450_a, vec32.field_72448_b + (double)0.6f - entity.func_226278_cu_() + e, vec32.field_72449_c)) {
            entity.func_213293_j(vec32.field_72450_a, (double)0.3f, vec32.field_72449_c);
        }
    }

    default public void doSplashEffect(Entity entity, Random random) {
        double e;
        double d;
        Entity vehicle = entity.func_184207_aI() && entity.func_184179_bs() != null ? entity.func_184179_bs() : entity;
        float f = vehicle == entity ? 0.2f : 0.9f;
        Vector3d vec3 = vehicle.func_213322_ci();
        float g = MathHelper.func_76133_a((double)(vec3.field_72450_a * vec3.field_72450_a * (double)0.2f + vec3.field_72448_b * vec3.field_72448_b + vec3.field_72449_c * vec3.field_72449_c * (double)0.2f)) * f;
        if (g > 1.0f) {
            g = 1.0f;
        }
        if ((double)g < 0.25) {
            entity.func_184185_a(entity.func_184181_aa(), g, 1.0f + (random.nextFloat() - random.nextFloat()) * 0.4f);
        } else {
            entity.func_184185_a(entity.func_204208_ah(), g, 1.0f + (random.nextFloat() - random.nextFloat()) * 0.4f);
        }
        float h = MathHelper.func_76128_c((double)entity.func_226278_cu_());
        int i = 0;
        while ((float)i < 1.0f + entity.func_213311_cf() * 20.0f) {
            d = (random.nextDouble() * 2.0 - 1.0) * (double)entity.func_213311_cf();
            e = (random.nextDouble() * 2.0 - 1.0) * (double)entity.func_213311_cf();
            entity.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197612_e, entity.func_226277_ct_() + d, (double)(h + 1.0f), entity.func_226281_cx_() + e, vec3.field_72450_a, vec3.field_72448_b - random.nextDouble() * (double)0.2f, vec3.field_72449_c);
            ++i;
        }
        i = 0;
        while ((float)i < 1.0f + entity.func_213311_cf() * 20.0f) {
            d = (random.nextDouble() * 2.0 - 1.0) * (double)entity.func_213311_cf();
            e = (random.nextDouble() * 2.0 - 1.0) * (double)entity.func_213311_cf();
            entity.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_218422_X, entity.func_226277_ct_() + d, (double)(h + 1.0f), entity.func_226281_cx_() + e, vec3.field_72450_a, vec3.field_72448_b, vec3.field_72449_c);
            ++i;
        }
    }
}

