/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.api.fluid;

import gg.moonflower.pollen.api.event.events.client.render.FogEvents;
import java.util.Arrays;
import java.util.Optional;
import net.minecraft.block.BlockState;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.fluid.FluidState;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public interface PollinatedFluid {
    public static final Direction[] DEFAULT_INTERACTIONS = (Direction[])Arrays.stream(Direction.values()).filter(direction -> direction != Direction.DOWN).toArray(Direction[]::new);

    public ResourceLocation getStillTextureName();

    public ResourceLocation getFlowingTextureName();

    @Nullable
    default public ResourceLocation getOverlayTextureName() {
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    default public int getFogColor(ActiveRenderInfo camera, ClientWorld level, Biome biome, float partialTicks) {
        return biome.func_204274_p();
    }

    @OnlyIn(value=Dist.CLIENT)
    default public void applyFog(GameRenderer renderer, ActiveRenderInfo camera, FogEvents.FogContext context, float distance, float partialTicks) {
        Entity entity = camera.func_216773_g();
        float f = 0.05f;
        if (entity instanceof ClientPlayerEntity) {
            ClientPlayerEntity localPlayer = (ClientPlayerEntity)entity;
            f -= localPlayer.func_203719_J() * localPlayer.func_203719_J() * 0.03f;
            Biome biome = localPlayer.field_70170_p.func_226691_t_(localPlayer.func_233580_cy_());
            if (biome.func_201856_r() == Biome.Category.SWAMP) {
                f += 0.005f;
            }
        }
        context.fogDensity(f);
        context.fogMode(2049);
    }

    default public Optional<SoundEvent> getPickupSound() {
        return Optional.of(SoundEvents.field_187624_K);
    }

    default public Optional<SoundEvent> getEmptySound() {
        return Optional.of(SoundEvents.field_187624_K);
    }

    default public Direction[] getInteractionDirections() {
        return DEFAULT_INTERACTIONS;
    }

    @Nullable
    default public BlockState getInteractionState(World level, FluidState fluidState, BlockPos pos, BlockPos neighborPos) {
        return null;
    }

    default public void playInteractionEffect(World level, FluidState fluidState, BlockPos pos) {
        level.func_217379_c(1501, pos, 0);
    }
}

