/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.api.item;

import gg.moonflower.pollen.api.fluid.PollinatedFluid;
import gg.moonflower.pollen.core.mixin.BucketItemAccessor;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IBucketPickupHandler;
import net.minecraft.block.ILiquidContainer;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BucketItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Direction;
import net.minecraft.util.DrinkHelper;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import org.jetbrains.annotations.Nullable;

public class BucketItemBase
extends BucketItem {
    protected final Supplier<? extends Fluid> fluid;

    public BucketItemBase(Supplier<? extends Fluid> fluid, Item.Properties builder) {
        super(Fluids.field_204541_a, builder);
        this.fluid = fluid;
    }

    public BucketItemBase(Fluid fluid, Item.Properties builder) {
        this(() -> fluid, builder);
    }

    public ActionResult<ItemStack> func_77659_a(World level, PlayerEntity player, Hand hand) {
        Fluid content = this.getFluid();
        ItemStack itemStack = player.func_184586_b(hand);
        BlockRayTraceResult hitResult = BucketItemBase.func_219968_a((World)level, (PlayerEntity)player, (RayTraceContext.FluidMode)(content == Fluids.field_204541_a ? RayTraceContext.FluidMode.SOURCE_ONLY : RayTraceContext.FluidMode.NONE));
        if (hitResult.func_216346_c() == RayTraceResult.Type.MISS) {
            return ActionResult.func_226250_c_((Object)itemStack);
        }
        if (hitResult.func_216346_c() != RayTraceResult.Type.BLOCK) {
            return ActionResult.func_226250_c_((Object)itemStack);
        }
        BlockPos pos = hitResult.func_216350_a();
        Direction direction = hitResult.func_216354_b();
        BlockPos offsetPos = pos.func_177972_a(direction);
        if (level.func_175660_a(player, pos) && player.func_175151_a(offsetPos, direction, itemStack)) {
            BlockState blockState = level.func_180495_p(pos);
            if (content == Fluids.field_204541_a) {
                Fluid fluid;
                if (blockState.func_177230_c() instanceof IBucketPickupHandler && (fluid = ((IBucketPickupHandler)blockState.func_177230_c()).func_204508_a((IWorld)level, pos, blockState)) != Fluids.field_204541_a) {
                    player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
                    this.playFillSound(player, (IWorld)level, pos);
                    ItemStack itemStack2 = DrinkHelper.func_242398_a((ItemStack)itemStack, (PlayerEntity)player, (ItemStack)new ItemStack((IItemProvider)fluid.func_204524_b()));
                    if (player instanceof ServerPlayerEntity) {
                        CriteriaTriggers.field_204813_j.func_204817_a((ServerPlayerEntity)player, new ItemStack((IItemProvider)fluid.func_204524_b()));
                    }
                    return ActionResult.func_233538_a_((Object)itemStack2, (boolean)level.func_201670_d());
                }
            } else {
                BlockPos emptyPos;
                BlockPos blockPos = emptyPos = blockState.func_177230_c() instanceof ILiquidContainer && content == Fluids.field_204546_a ? pos : offsetPos;
                if (this.func_180616_a(player, level, emptyPos, hitResult)) {
                    this.func_203792_a(level, itemStack, emptyPos);
                    if (player instanceof ServerPlayerEntity) {
                        CriteriaTriggers.field_193137_x.func_193173_a((ServerPlayerEntity)player, emptyPos, itemStack);
                    }
                    player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
                    return ActionResult.func_233538_a_((Object)this.func_203790_a(itemStack, player), (boolean)level.func_201670_d());
                }
            }
        }
        return ActionResult.func_226251_d_((Object)itemStack);
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group) || group == ItemGroup.field_78026_f) {
            Optional<ItemStack> optional;
            if (items.stream().anyMatch(stack -> stack.func_77973_b() instanceof BucketItem) && (optional = items.stream().filter(stack -> stack.func_77973_b() instanceof BucketItem && "minecraft".equals(Registry.field_212630_s.func_177774_c((Object)stack.func_77973_b()).func_110624_b()) && (stack.func_77973_b() == Items.field_151131_as || ((BucketItemAccessor)stack.func_77973_b()).getContent() != Fluids.field_204546_a)).reduce((a, b) -> b)).isPresent() && items.contains((Object)optional.get())) {
                items.add(items.indexOf((Object)optional.get()) + 1, (Object)new ItemStack((IItemProvider)this));
                return;
            }
            items.add((Object)new ItemStack((IItemProvider)this));
        }
    }

    public boolean func_180616_a(@Nullable PlayerEntity player, World level, BlockPos blockPos, @Nullable BlockRayTraceResult blockHitResult) {
        boolean bl2;
        Fluid content = this.getFluid();
        if (!(content instanceof FlowingFluid)) {
            return false;
        }
        BlockState blockState = level.func_180495_p(blockPos);
        Block block = blockState.func_177230_c();
        Material material = blockState.func_185904_a();
        boolean bl = blockState.func_227032_a_(content);
        boolean bl3 = bl2 = blockState.func_196958_f() || bl || block instanceof ILiquidContainer && ((ILiquidContainer)block).func_204510_a((IBlockReader)level, blockPos, blockState, content);
        if (!bl2) {
            return blockHitResult != null && this.func_180616_a(player, level, blockHitResult.func_216350_a().func_177972_a(blockHitResult.func_216354_b()), null);
        }
        if (level.func_230315_m_().func_236040_e_() && content.func_207185_a((ITag)FluidTags.field_206959_a)) {
            int i = blockPos.func_177958_n();
            int j = blockPos.func_177956_o();
            int k = blockPos.func_177952_p();
            level.func_184133_a(player, blockPos, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 0.5f, 2.6f + (level.field_73012_v.nextFloat() - level.field_73012_v.nextFloat()) * 0.8f);
            for (int l = 0; l < 8; ++l) {
                level.func_195594_a((IParticleData)ParticleTypes.field_197594_E, (double)i + Math.random(), (double)j + Math.random(), (double)k + Math.random(), 0.0, 0.0, 0.0);
            }
            return true;
        }
        if (block instanceof ILiquidContainer && content == Fluids.field_204546_a) {
            ((ILiquidContainer)block).func_204509_a((IWorld)level, blockPos, blockState, ((FlowingFluid)content).func_207204_a(false));
            this.func_203791_b(player, (IWorld)level, blockPos);
            return true;
        }
        if (!level.func_201670_d() && bl && !material.func_76224_d()) {
            level.func_175655_b(blockPos, true);
        }
        if (!level.func_180501_a(blockPos, content.func_207188_f().func_206883_i(), 11) && !blockState.func_204520_s().func_206889_d()) {
            return false;
        }
        this.func_203791_b(player, (IWorld)level, blockPos);
        return true;
    }

    protected void playFillSound(@Nullable PlayerEntity player, IWorld level, BlockPos pos) {
        Fluid content = this.getFluid();
        SoundEvent soundEvent = content instanceof PollinatedFluid ? (SoundEvent)((PollinatedFluid)content).getPickupSound().orElse(null) : (content.func_207185_a((ITag)FluidTags.field_206960_b) ? SoundEvents.field_187633_N : SoundEvents.field_187630_M);
        level.func_184133_a(player, pos, soundEvent, SoundCategory.BLOCKS, 1.0f, 1.0f);
    }

    protected void func_203791_b(@Nullable PlayerEntity player, IWorld level, BlockPos pos) {
        SoundEvent soundEvent;
        Fluid content = this.getFluid();
        if (content instanceof PollinatedFluid) {
            soundEvent = ((PollinatedFluid)content).getEmptySound().orElse(null);
        } else {
            SoundEvent soundEvent2 = soundEvent = content.func_207185_a((ITag)FluidTags.field_206960_b) ? SoundEvents.field_187627_L : SoundEvents.field_187624_K;
        }
        if (soundEvent != null) {
            level.func_184133_a(player, pos, soundEvent, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
    }

    public Fluid getFluid() {
        return this.fluid.get();
    }
}

