/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.api.network.forge;

import gg.moonflower.pollen.api.network.PacketDeserializer;
import gg.moonflower.pollen.api.network.PollinatedPlayNetworkChannel;
import gg.moonflower.pollen.api.network.forge.PollinatedNetworkChannelImpl;
import gg.moonflower.pollen.api.network.packet.PollinatedPacket;
import gg.moonflower.pollen.api.network.packet.PollinatedPacketDirection;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class PollinatedForgePlayChannel
extends PollinatedNetworkChannelImpl
implements PollinatedPlayNetworkChannel {
    public PollinatedForgePlayChannel(SimpleChannel channel, Supplier<Supplier<Object>> clientFactory, Supplier<Supplier<Object>> serverFactory) {
        super(channel, clientFactory, serverFactory);
    }

    @Override
    public void sendTo(ServerPlayerEntity player, PollinatedPacket<?> message) {
        this.channel.send(PacketDistributor.PLAYER.with(() -> player), message);
    }

    @Override
    public void sendTo(ServerWorld level, PollinatedPacket<?> message) {
        this.channel.send(PacketDistributor.DIMENSION.with(() -> ((ServerWorld)level).func_234923_W_()), message);
    }

    @Override
    public void sendToNear(ServerWorld level, double x, double y, double z, double radius, PollinatedPacket<?> message) {
        this.channel.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(x, y, z, radius * radius, level.func_234923_W_())), message);
    }

    @Override
    public void sendToAll(MinecraftServer server, PollinatedPacket<?> message) {
        this.channel.send(PacketDistributor.ALL.noArg(), message);
    }

    @Override
    public void sendToTracking(Entity entity, PollinatedPacket<?> message) {
        this.channel.send(PacketDistributor.TRACKING_ENTITY.with(() -> entity), message);
    }

    @Override
    public void sendToTracking(ServerWorld level, BlockPos pos, PollinatedPacket<?> message) {
        this.channel.send(PacketDistributor.TRACKING_CHUNK.with(() -> level.func_175726_f(pos)), message);
    }

    @Override
    public void sendToTracking(ServerWorld level, ChunkPos pos, PollinatedPacket<?> message) {
        this.channel.send(PacketDistributor.TRACKING_CHUNK.with(() -> level.func_212866_a_(pos.field_77276_a, pos.field_77275_b)), message);
    }

    @Override
    public void sendToTrackingAndSelf(Entity entity, PollinatedPacket<?> message) {
        this.channel.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity), message);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void sendToServer(PollinatedPacket<?> message) {
        this.channel.sendToServer(message);
    }

    @Override
    public <MSG extends PollinatedPacket<T>, T> void register(Class<MSG> clazz, PacketDeserializer<MSG, T> deserializer, @Nullable PollinatedPacketDirection direction) {
        this.getMessageBuilder(clazz, deserializer, direction).add();
    }

    @Override
    public IPacket<?> toVanillaPacket(PollinatedPacket<?> packet, PollinatedPacketDirection direction) {
        return this.channel.toVanillaPacket(packet, PollinatedForgePlayChannel.toNetworkDirection(direction));
    }
}

