/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.api.network.forge;

import gg.moonflower.pollen.api.network.PacketDeserializer;
import gg.moonflower.pollen.api.network.forge.PollinatedForgePacketContext;
import gg.moonflower.pollen.api.network.packet.PollinatedPacket;
import gg.moonflower.pollen.api.network.packet.PollinatedPacketDirection;
import gg.moonflower.pollen.api.registry.NetworkRegistry;
import java.io.IOException;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.LazyValue;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class PollinatedNetworkChannelImpl {
    protected final SimpleChannel channel;
    protected final LazyValue<LazyValue<Object>> clientMessageHandler;
    protected final LazyValue<LazyValue<Object>> serverMessageHandler;
    protected int nextId;

    protected PollinatedNetworkChannelImpl(SimpleChannel channel, Supplier<Supplier<Object>> clientFactory, Supplier<Supplier<Object>> serverFactory) {
        this.channel = channel;
        this.clientMessageHandler = new LazyValue(() -> new LazyValue((Supplier)clientFactory.get()));
        this.serverMessageHandler = new LazyValue(() -> new LazyValue((Supplier)serverFactory.get()));
    }

    protected static NetworkDirection toNetworkDirection(@Nullable PollinatedPacketDirection direction) {
        if (direction == null) {
            return null;
        }
        switch (direction) {
            case PLAY_SERVERBOUND: {
                return NetworkDirection.PLAY_TO_SERVER;
            }
            case PLAY_CLIENTBOUND: {
                return NetworkDirection.PLAY_TO_CLIENT;
            }
            case LOGIN_SERVERBOUND: {
                return NetworkDirection.LOGIN_TO_SERVER;
            }
            case LOGIN_CLIENTBOUND: {
                return NetworkDirection.LOGIN_TO_CLIENT;
            }
        }
        throw new IllegalStateException("Unknown network direction: " + (Object)((Object)direction));
    }

    protected <MSG extends PollinatedPacket<T>, T> SimpleChannel.MessageBuilder<MSG> getMessageBuilder(Class<MSG> clazz, PacketDeserializer<MSG, T> deserializer, @Nullable PollinatedPacketDirection direction) {
        return this.channel.messageBuilder(clazz, this.nextId++, PollinatedNetworkChannelImpl.toNetworkDirection(direction)).encoder((msg, buf) -> {
            try {
                msg.writePacketData((PacketBuffer)buf);
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to write packet data", e);
            }
        }).decoder(buf -> {
            try {
                return deserializer.deserialize((PacketBuffer)buf);
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to read packet data", e);
            }
        }).consumer((msg, ctx) -> {
            NetworkRegistry.processMessage(msg, new PollinatedForgePacketContext(this.channel, (Supplier<NetworkEvent.Context>)ctx), ((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide().isClient() ? ((LazyValue)this.clientMessageHandler.func_179281_c()).func_179281_c() : ((LazyValue)this.serverMessageHandler.func_179281_c()).func_179281_c());
            ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
        });
    }
}

