/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.api.platform;

import architectury_inject_pollen_common_7c4d7b7cb0a042e0ad50d659ddf711a6_12b99bba97eb5fa1359fafa7306df2824b2bb35eeb2c0fc407891b372eadc90cpollen1111165devjar.PlatformMethods;
import dev.architectury.injectables.annotations.ExpectPlatform;
import gg.moonflower.pollen.api.platform.forge.PlatformBuilderImpl;
import gg.moonflower.pollen.api.platform.forge.PlatformImpl;
import gg.moonflower.pollen.api.util.PollinatedModContainer;
import gg.moonflower.pollen.core.Pollen;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.network.play.ClientPlayNetHandler;
import net.minecraft.data.DataGenerator;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tags.ITagCollectionSupplier;
import net.minecraft.util.concurrent.ThreadTaskExecutor;
import org.jetbrains.annotations.ApiStatus;

public abstract class Platform {
    private static final boolean FORGE = PlatformMethods.getCurrentTarget().equals("forge");
    private static final Supplier<ITagCollectionSupplier> CLIENT_TAG_CONTAINER = () -> {
        ClientPlayNetHandler listener = Minecraft.func_71410_x().func_147114_u();
        return listener != null ? listener.func_199724_l() : null;
    };
    private static final Supplier<RecipeManager> CLIENT_RECIPE_MANAGER = () -> {
        ClientPlayNetHandler listener = Minecraft.func_71410_x().func_147114_u();
        return listener != null ? listener.func_199526_e() : null;
    };
    private final String modId;

    protected Platform(String modId) {
        this.modId = modId;
    }

    public static Builder builder(String modId) {
        return new Builder(modId);
    }

    public static <T> T error() {
        throw new AssertionError();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean isProduction() {
        return PlatformImpl.isProduction();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean isClient() {
        return PlatformImpl.isClient();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean isOptifineLoaded() {
        return PlatformImpl.isOptifineLoaded();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static ThreadTaskExecutor<?> getGameExecutor() {
        return PlatformImpl.getGameExecutor();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean isModLoaded(String modId) {
        return PlatformImpl.isModLoaded(modId);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Stream<PollinatedModContainer> getMods() {
        return PlatformImpl.getMods();
    }

    public static Optional<MinecraftServer> getRunningServer() {
        return Optional.ofNullable(Pollen.getRunningServer());
    }

    public static Optional<ITagCollectionSupplier> getTags() {
        MinecraftServer server = Pollen.getRunningServer();
        if (server != null) {
            return Optional.of(server.func_244266_aF());
        }
        return Platform.isClient() ? Optional.ofNullable(CLIENT_TAG_CONTAINER.get()) : Optional.empty();
    }

    public static Optional<RecipeManager> getRecipeManager() {
        MinecraftServer server = Pollen.getRunningServer();
        if (server != null) {
            return Optional.of(server.func_199529_aN());
        }
        return Platform.isClient() ? Optional.ofNullable(CLIENT_RECIPE_MANAGER.get()) : Optional.empty();
    }

    public static boolean isForge() {
        return FORGE;
    }

    public String getModId() {
        return this.modId;
    }

    public abstract void setup();

    public static class Builder {
        private final String modId;
        private Runnable commonInit = () -> {};
        private Runnable clientInit = () -> {};
        private Consumer<ModSetupContext> commonPostInit = __ -> {};
        private Consumer<ModSetupContext> clientPostInit = __ -> {};
        private Consumer<DataSetupContext> dataInit = __ -> {};

        private Builder(String modId) {
            this.modId = modId;
        }

        /*
         * WARNING - void declaration
         */
        @ApiStatus.Internal
        @ExpectPlatform
        @ExpectPlatform.Transformed
        public static Platform buildImpl(String modId, Runnable commonInit, Runnable clientInit, Consumer<ModSetupContext> commonPostInit, Consumer<ModSetupContext> clientPostInit, Consumer<DataSetupContext> dataInit) {
            void var5_5;
            void var4_4;
            void var3_3;
            void var2_2;
            void var1_1;
            return PlatformBuilderImpl.buildImpl(modId, (Runnable)var1_1, (Runnable)var2_2, (Consumer<ModSetupContext>)var3_3, (Consumer<ModSetupContext>)var4_4, (Consumer<DataSetupContext>)var5_5);
        }

        public Builder commonInit(Runnable onCommonInit) {
            this.commonInit = onCommonInit;
            return this;
        }

        public Builder clientInit(Runnable onClientInit) {
            this.clientInit = onClientInit;
            return this;
        }

        public Builder commonPostInit(Consumer<ModSetupContext> onCommonPostInit) {
            this.commonPostInit = onCommonPostInit;
            return this;
        }

        public Builder clientPostInit(Consumer<ModSetupContext> onClientPostInit) {
            this.clientPostInit = onClientPostInit;
            return this;
        }

        public Builder dataInit(Consumer<DataSetupContext> dataInit) {
            this.dataInit = dataInit;
            return this;
        }

        public Platform build() {
            return Builder.buildImpl(this.modId, this.commonInit, this.clientInit, this.commonPostInit, this.clientPostInit, this.dataInit);
        }
    }

    public static interface DataSetupContext {
        public DataGenerator getGenerator();

        public PollinatedModContainer getMod();
    }

    public static interface ModSetupContext {
        public CompletableFuture<Void> enqueueWork(Runnable var1);

        public <T> CompletableFuture<T> enqueueWork(Supplier<T> var1);
    }
}

