/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.api.registry;

import gg.moonflower.pollen.api.event.PollinatedEvent;
import gg.moonflower.pollen.core.event.PollinatedEventImpl;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.function.Function;
import net.minecraft.util.ActionResultType;

public final class EventRegistry {
    private EventRegistry() {
    }

    public static <T> PollinatedEvent<T> create(Class<? super T> type, Function<T[], T> invokerFactory) {
        return new PollinatedEventImpl<T>(type, invokerFactory);
    }

    public static <T> PollinatedEvent<T> createLoop(Class<? super T> type) {
        return EventRegistry.create(type, events -> Proxy.newProxyInstance(EventRegistry.class.getClassLoader(), new Class[]{type}, (proxy, method, args) -> {
            for (Object event : events) {
                EventRegistry.invokeFast(event, method, args);
            }
            return null;
        }));
    }

    public static <T> PollinatedEvent<T> createResult(Class<? super T> type) {
        return EventRegistry.create(type, events -> Proxy.newProxyInstance(EventRegistry.class.getClassLoader(), new Class[]{type}, (proxy, method, args) -> {
            for (Object event : events) {
                ActionResultType result = (ActionResultType)EventRegistry.invokeFast(event, method, args);
                if (result == ActionResultType.PASS) continue;
                return result;
            }
            return ActionResultType.PASS;
        }));
    }

    private static <T, S> S invokeFast(T object, Method method, Object[] args) throws Throwable {
        return (S)MethodHandles.lookup().unreflect(method).bindTo(object).invokeWithArguments(args);
    }
}

