/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.api.registry;

import gg.moonflower.pollen.api.fluid.PollenFluidBehavior;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.tags.ITag;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public final class FluidBehaviorRegistry {
    private static final Map<ITag<Fluid>, PollenFluidBehavior> FLUID_BEHAVIOR = new ConcurrentHashMap<ITag<Fluid>, PollenFluidBehavior>();

    private FluidBehaviorRegistry() {
    }

    public static void register(ITag<Fluid> tag, PollenFluidBehavior behavior) {
        FLUID_BEHAVIOR.put(tag, behavior);
    }

    @Nullable
    public static PollenFluidBehavior get(ITag<Fluid> tag) {
        return FLUID_BEHAVIOR.get(tag);
    }

    public static Set<ITag<Fluid>> getFluids() {
        return FLUID_BEHAVIOR.keySet();
    }

    @ApiStatus.Internal
    public static boolean doFluidPushing(ITag<Fluid> tag, Entity entity) {
        if (entity.func_184187_bx() instanceof BoatEntity) {
            return false;
        }
        PollenFluidBehavior behavior = FluidBehaviorRegistry.get(tag);
        if (behavior == null) {
            return false;
        }
        if (entity.func_210500_b(tag, behavior.getMotionScale(entity))) {
            if (behavior.canExtinguishFire(entity)) {
                entity.func_70066_B();
            }
            if (behavior.negatesFallDamage(entity)) {
                entity.field_70143_R = 0.0f;
            }
            return true;
        }
        return false;
    }
}

