/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.api.registry;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Keyable;
import com.mojang.serialization.Lifecycle;
import dev.architectury.injectables.annotations.ExpectPlatform;
import gg.moonflower.pollen.api.platform.Platform;
import gg.moonflower.pollen.api.registry.PollinatedBlockRegistry;
import gg.moonflower.pollen.api.registry.PollinatedEntityRegistry;
import gg.moonflower.pollen.api.registry.PollinatedFluidRegistry;
import gg.moonflower.pollen.api.registry.forge.PollinatedRegistryImpl;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.item.Item;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.DefaultedRegistry;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.SimpleRegistry;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PollinatedRegistry<T>
implements Codec<T>,
Keyable,
Iterable<T> {
    protected final String modId;
    private boolean registered;

    protected PollinatedRegistry(String modId) {
        this.modId = modId;
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <T> PollinatedRegistry<T> create(Registry<T> registry, String modId) {
        void var1_1;
        return PollinatedRegistryImpl.create(registry, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <T> PollinatedRegistry<T> create(PollinatedRegistry<T> registry, String modId) {
        void var1_1;
        return PollinatedRegistryImpl.create(registry, (String)var1_1);
    }

    public static PollinatedBlockRegistry createBlock(PollinatedRegistry<Item> itemRegistry) {
        return new PollinatedBlockRegistry(PollinatedRegistry.create(Registry.field_212618_g, itemRegistry.getModId()), itemRegistry);
    }

    public static PollinatedFluidRegistry createFluid(String domain) {
        return new PollinatedFluidRegistry(PollinatedRegistry.create(Registry.field_212619_h, domain));
    }

    public static PollinatedEntityRegistry createEntity(String domain) {
        return new PollinatedEntityRegistry(PollinatedRegistry.create(Registry.field_212629_r, domain));
    }

    public static <T> PollinatedRegistry<T> createVanilla(Registry<T> registry, String modId) {
        return new VanillaImpl(registry, modId);
    }

    public static <T> PollinatedRegistry<T> createSimple(Class<T> type, ResourceLocation registryId) {
        return PollinatedRegistry.createVanilla(new SimpleRegistry(RegistryKey.func_240904_a_((ResourceLocation)registryId), Lifecycle.stable()), registryId.func_110624_b());
    }

    public static <T> PollinatedRegistry<T> createDefaulted(Class<T> type, ResourceLocation registryId, ResourceLocation defaultId) {
        return PollinatedRegistry.createVanilla(new DefaultedRegistry(defaultId.toString(), RegistryKey.func_240904_a_((ResourceLocation)registryId), Lifecycle.stable()), registryId.func_110624_b());
    }

    public String getModId() {
        return this.modId;
    }

    public abstract <R extends T> Supplier<R> register(String var1, Supplier<R> var2);

    public <R extends T> Supplier<R> registerConditional(String id, Supplier<R> dummy, Supplier<R> object, boolean register) {
        return this.register(id, register ? object : dummy);
    }

    @Nullable
    public abstract ResourceLocation getKey(T var1);

    @Nullable
    public abstract T get(@Nullable ResourceLocation var1);

    public Optional<T> getOptional(@Nullable ResourceLocation name) {
        return Optional.ofNullable(this.get(name));
    }

    public abstract Set<ResourceLocation> keySet();

    public Stream<T> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    public abstract boolean containsKey(ResourceLocation var1);

    public final void register(Platform mod) {
        if (this.registered) {
            throw new IllegalStateException("Cannot register a PollinatedRegistry twice!");
        }
        this.registered = true;
        this.onRegister(mod);
    }

    @ApiStatus.OverrideOnly
    protected void onRegister(Platform mod) {
    }

    @ApiStatus.Internal
    public static class VanillaImpl<T>
    extends PollinatedRegistry<T> {
        private final Registry<T> registry;

        private VanillaImpl(Registry<T> registry, String modId) {
            super(modId);
            this.registry = registry;
        }

        public Registry<T> getRegistry() {
            return this.registry;
        }

        @Override
        public <R extends T> Supplier<R> register(String id, Supplier<R> object) {
            Object registered = Registry.func_218322_a(this.registry, (ResourceLocation)new ResourceLocation(this.modId, id), object.get());
            return () -> registered;
        }

        @Override
        @Nullable
        public ResourceLocation getKey(T value) {
            return this.registry.func_177774_c(value);
        }

        @Override
        @Nullable
        public T get(@Nullable ResourceLocation name) {
            return (T)this.registry.func_82594_a(name);
        }

        @Override
        public Set<ResourceLocation> keySet() {
            return this.registry.func_148742_b();
        }

        @Override
        public boolean containsKey(ResourceLocation name) {
            return this.registry.func_82594_a(name) != null;
        }

        public <T1> DataResult<Pair<T, T1>> decode(DynamicOps<T1> ops, T1 input) {
            return this.registry.decode(ops, input);
        }

        public <T1> DataResult<T1> encode(T input, DynamicOps<T1> ops, T1 prefix) {
            return this.registry.encode(input, ops, prefix);
        }

        public <T1> Stream<T1> keys(DynamicOps<T1> ops) {
            return this.registry.keys(ops);
        }

        @Override
        @NotNull
        public Iterator<T> iterator() {
            return this.registry.iterator();
        }
    }
}

