/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.api.registry.forge;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.ApiStatus;

@Mod.EventBusSubscriber(modid="pollen", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
@ApiStatus.Internal
public class EntityAttributeRegistryImpl {
    private static final Set<Consumer<EntityAttributeCreationEvent>> ATTRIBUTE_FACTORIES = ConcurrentHashMap.newKeySet();

    @SubscribeEvent
    public static void onEvent(EntityAttributeCreationEvent event) {
        ATTRIBUTE_FACTORIES.forEach(consumer -> consumer.accept(event));
    }

    public static <T extends LivingEntity> void register(Supplier<EntityType<T>> entity, Supplier<AttributeModifierMap.MutableAttribute> attributeBuilder) {
        ATTRIBUTE_FACTORIES.add(event -> event.put((EntityType)entity.get(), ((AttributeModifierMap.MutableAttribute)attributeBuilder.get()).func_233813_a_()));
    }
}

