/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.api.registry.resource.forge;

import com.mojang.datafixers.util.Pair;
import gg.moonflower.pollen.api.registry.resource.PollinatedPreparableReloadListener;
import gg.moonflower.pollen.api.util.PollinatedModContainer;
import gg.moonflower.pollen.api.util.forge.ForgeModResourcePack;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IPackNameDecorator;
import net.minecraft.resources.ResourcePackInfo;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class ResourceRegistryImpl {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Map<ResourcePackType, Set<PollinatedPreparableReloadListener>> LISTENERS = new HashMap<ResourcePackType, Set<PollinatedPreparableReloadListener>>();
    private static final Set<Pair<String, ForgeModResourcePack>> builtinResourcePacks = new HashSet<Pair<String, ForgeModResourcePack>>();

    public static synchronized void registerReloadListener(ResourcePackType type, PollinatedPreparableReloadListener listener) {
        if (!LISTENERS.computeIfAbsent(type, __ -> new HashSet()).add(listener)) {
            throw new RuntimeException("Attempted to add listener twice: " + listener.func_225594_i_() + "");
        }
    }

    public static void inject(ResourcePackType type, List<IFutureReloadListener> listeners) {
        Set<PollinatedPreparableReloadListener> addedListeners = LISTENERS.get(type);
        if (addedListeners == null) {
            return;
        }
        ArrayList<PollinatedPreparableReloadListener> listenersToAdd = new ArrayList<PollinatedPreparableReloadListener>(addedListeners);
        HashSet<ResourceLocation> resolvedIds = new HashSet<ResourceLocation>();
        for (IFutureReloadListener listener : listeners) {
            if (!(listener instanceof PollinatedPreparableReloadListener)) continue;
            resolvedIds.add(((PollinatedPreparableReloadListener)listener).getPollenId());
        }
        int lastSize = -1;
        while (listeners.size() != lastSize) {
            lastSize = listeners.size();
            Iterator it = listenersToAdd.iterator();
            while (it.hasNext()) {
                PollinatedPreparableReloadListener pollinatedPreparableReloadListener = (PollinatedPreparableReloadListener)it.next();
                if (!resolvedIds.containsAll(pollinatedPreparableReloadListener.getPollenDependencies())) continue;
                resolvedIds.add(pollinatedPreparableReloadListener.getPollenId());
                listeners.add(pollinatedPreparableReloadListener);
                it.remove();
            }
        }
        for (IFutureReloadListener iFutureReloadListener : listenersToAdd) {
            LOGGER.warn("Could not resolve dependencies for listener: " + iFutureReloadListener.func_225594_i_() + "!");
        }
    }

    public static void inject(ResourcePackType type, Consumer<ResourcePackInfo> consumer, ResourcePackInfo.IFactory factory) {
        for (Pair<String, ForgeModResourcePack> entry : builtinResourcePacks) {
            ForgeModResourcePack pack = (ForgeModResourcePack)((Object)entry.getSecond());
            if (pack.func_195759_a(type).isEmpty()) continue;
            ResourcePackInfo profile = ResourcePackInfo.func_195793_a((String)((String)entry.getFirst()), (boolean)false, () -> entry.getSecond(), (ResourcePackInfo.IFactory)factory, (ResourcePackInfo.Priority)ResourcePackInfo.Priority.TOP, (IPackNameDecorator)IPackNameDecorator.field_232626_b_);
            if (profile == null) continue;
            consumer.accept(profile);
        }
    }

    public static synchronized boolean registerBuiltinResourcePack(ResourceLocation id, PollinatedModContainer container, boolean enabledByDefault) {
        String separator = container.resolve("").getFileSystem().getSeparator();
        String subPath = ("resourcepacks/" + id.func_110623_a()).replace("/", separator);
        Path resourcePackPath = container.resolve(subPath).toAbsolutePath().normalize();
        if (!Files.exists(resourcePackPath, new LinkOption[0])) {
            return false;
        }
        final String name = id.func_110624_b() + "/" + id.func_110623_a();
        builtinResourcePacks.add((Pair<String, ForgeModResourcePack>)Pair.of((Object)name, (Object)((Object)new ForgeModResourcePack(container, resourcePackPath, null, enabledByDefault){

            @Override
            public String func_195762_a() {
                return name;
            }
        })));
        return true;
    }
}

