/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.api.resource.condition.forge;

import com.google.gson.JsonObject;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class BlockExistsCondition
implements ICondition {
    private static final ResourceLocation NAME = new ResourceLocation("pollen", "block_exists");
    private final ResourceLocation block;

    public BlockExistsCondition(ResourceLocation block) {
        this.block = block;
    }

    public ResourceLocation getID() {
        return NAME;
    }

    public boolean test() {
        return ForgeRegistries.BLOCKS.containsKey(this.block);
    }

    public String toString() {
        return "block_exists(\"" + this.block + "\")";
    }

    public static class Serializer
    implements IConditionSerializer<BlockExistsCondition> {
        public static final Serializer INSTANCE = new Serializer();

        public void write(JsonObject json, BlockExistsCondition value) {
            json.addProperty("block", value.block.toString());
        }

        public BlockExistsCondition read(JsonObject json) {
            return new BlockExistsCondition(new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"block")));
        }

        public ResourceLocation getID() {
            return NAME;
        }
    }
}

